/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.openxr.XrVector4f;
import org.lwjgl.openxr.XrVector4sFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandTrackingMeshFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int JOINTCAPACITYINPUT;
    public static final int JOINTCOUNTOUTPUT;
    public static final int JOINTBINDPOSES;
    public static final int JOINTRADII;
    public static final int JOINTPARENTS;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTEXPOSITIONS;
    public static final int VERTEXNORMALS;
    public static final int VERTEXUVS;
    public static final int VERTEXBLENDINDICES;
    public static final int VERTEXBLENDWEIGHTS;
    public static final int INDEXCAPACITYINPUT;
    public static final int INDEXCOUNTOUTPUT;
    public static final int INDICES;

    public XrHandTrackingMeshFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandTrackingMeshFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandTrackingMeshFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandTrackingMeshFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCapacityInput() {
        return XrHandTrackingMeshFB.njointCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCountOutput() {
        return XrHandTrackingMeshFB.njointCountOutput(this.address());
    }

    @NativeType(value="XrPosef *")
    public XrPosef.Buffer jointBindPoses() {
        return XrHandTrackingMeshFB.njointBindPoses(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer jointRadii() {
        return XrHandTrackingMeshFB.njointRadii(this.address());
    }

    @NativeType(value="XrHandJointEXT *")
    public IntBuffer jointParents() {
        return XrHandTrackingMeshFB.njointParents(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrHandTrackingMeshFB.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrHandTrackingMeshFB.nvertexCountOutput(this.address());
    }

    @NativeType(value="XrVector3f *")
    public XrVector3f.Buffer vertexPositions() {
        return XrHandTrackingMeshFB.nvertexPositions(this.address());
    }

    @NativeType(value="XrVector3f *")
    public XrVector3f.Buffer vertexNormals() {
        return XrHandTrackingMeshFB.nvertexNormals(this.address());
    }

    @NativeType(value="XrVector2f *")
    public XrVector2f.Buffer vertexUVs() {
        return XrHandTrackingMeshFB.nvertexUVs(this.address());
    }

    @NativeType(value="XrVector4sFB *")
    public XrVector4sFB.Buffer vertexBlendIndices() {
        return XrHandTrackingMeshFB.nvertexBlendIndices(this.address());
    }

    @NativeType(value="XrVector4f *")
    public XrVector4f.Buffer vertexBlendWeights() {
        return XrHandTrackingMeshFB.nvertexBlendWeights(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCapacityInput() {
        return XrHandTrackingMeshFB.nindexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCountOutput() {
        return XrHandTrackingMeshFB.nindexCountOutput(this.address());
    }

    @NativeType(value="int16_t *")
    public ShortBuffer indices() {
        return XrHandTrackingMeshFB.nindices(this.address());
    }

    public XrHandTrackingMeshFB type(@NativeType(value="XrStructureType") int value) {
        XrHandTrackingMeshFB.ntype(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB type$Default() {
        return this.type(1000110001);
    }

    public XrHandTrackingMeshFB next(@NativeType(value="void *") long value) {
        XrHandTrackingMeshFB.nnext(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointCapacityInput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.njointCapacityInput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.njointCountOutput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointBindPoses(@NativeType(value="XrPosef *") XrPosef.Buffer value) {
        XrHandTrackingMeshFB.njointBindPoses(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointRadii(@NativeType(value="float *") FloatBuffer value) {
        XrHandTrackingMeshFB.njointRadii(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB jointParents(@NativeType(value="XrHandJointEXT *") IntBuffer value) {
        XrHandTrackingMeshFB.njointParents(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.nvertexCapacityInput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexPositions(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
        XrHandTrackingMeshFB.nvertexPositions(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexNormals(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
        XrHandTrackingMeshFB.nvertexNormals(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexUVs(@NativeType(value="XrVector2f *") XrVector2f.Buffer value) {
        XrHandTrackingMeshFB.nvertexUVs(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexBlendIndices(@NativeType(value="XrVector4sFB *") XrVector4sFB.Buffer value) {
        XrHandTrackingMeshFB.nvertexBlendIndices(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB vertexBlendWeights(@NativeType(value="XrVector4f *") XrVector4f.Buffer value) {
        XrHandTrackingMeshFB.nvertexBlendWeights(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB indexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandTrackingMeshFB.nindexCountOutput(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB indices(@NativeType(value="int16_t *") ShortBuffer value) {
        XrHandTrackingMeshFB.nindices(this.address(), value);
        return this;
    }

    public XrHandTrackingMeshFB set(int type, long next, int jointCapacityInput, int jointCountOutput, XrPosef.Buffer jointBindPoses, FloatBuffer jointRadii, IntBuffer jointParents, int vertexCapacityInput, int vertexCountOutput, XrVector3f.Buffer vertexPositions, XrVector3f.Buffer vertexNormals, XrVector2f.Buffer vertexUVs, XrVector4sFB.Buffer vertexBlendIndices, XrVector4f.Buffer vertexBlendWeights, int indexCountOutput, ShortBuffer indices) {
        this.type(type);
        this.next(next);
        this.jointCapacityInput(jointCapacityInput);
        this.jointCountOutput(jointCountOutput);
        this.jointBindPoses(jointBindPoses);
        this.jointRadii(jointRadii);
        this.jointParents(jointParents);
        this.vertexCapacityInput(vertexCapacityInput);
        this.vertexCountOutput(vertexCountOutput);
        this.vertexPositions(vertexPositions);
        this.vertexNormals(vertexNormals);
        this.vertexUVs(vertexUVs);
        this.vertexBlendIndices(vertexBlendIndices);
        this.vertexBlendWeights(vertexBlendWeights);
        this.indexCountOutput(indexCountOutput);
        this.indices(indices);
        return this;
    }

    public XrHandTrackingMeshFB set(XrHandTrackingMeshFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandTrackingMeshFB malloc() {
        return XrHandTrackingMeshFB.wrap(XrHandTrackingMeshFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandTrackingMeshFB calloc() {
        return XrHandTrackingMeshFB.wrap(XrHandTrackingMeshFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandTrackingMeshFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandTrackingMeshFB.wrap(XrHandTrackingMeshFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandTrackingMeshFB create(long address) {
        return XrHandTrackingMeshFB.wrap(XrHandTrackingMeshFB.class, address);
    }

    @Nullable
    public static XrHandTrackingMeshFB createSafe(long address) {
        return address == 0L ? null : XrHandTrackingMeshFB.wrap(XrHandTrackingMeshFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandTrackingMeshFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandTrackingMeshFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandTrackingMeshFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandTrackingMeshFB.__create(capacity, SIZEOF);
        return XrHandTrackingMeshFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandTrackingMeshFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandTrackingMeshFB.wrap(Buffer.class, address, capacity);
    }

    public static XrHandTrackingMeshFB malloc(MemoryStack stack) {
        return XrHandTrackingMeshFB.wrap(XrHandTrackingMeshFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandTrackingMeshFB calloc(MemoryStack stack) {
        return XrHandTrackingMeshFB.wrap(XrHandTrackingMeshFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandTrackingMeshFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandTrackingMeshFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int njointCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)JOINTCAPACITYINPUT);
    }

    public static int njointCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)JOINTCOUNTOUTPUT);
    }

    public static XrPosef.Buffer njointBindPoses(long struct) {
        return XrPosef.create(MemoryUtil.memGetAddress(struct + (long)JOINTBINDPOSES), XrHandTrackingMeshFB.njointCapacityInput(struct));
    }

    public static FloatBuffer njointRadii(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)JOINTRADII), XrHandTrackingMeshFB.njointCapacityInput(struct));
    }

    public static IntBuffer njointParents(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)JOINTPARENTS), XrHandTrackingMeshFB.njointCapacityInput(struct));
    }

    public static int nvertexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNTOUTPUT);
    }

    public static XrVector3f.Buffer nvertexPositions(long struct) {
        return XrVector3f.create(MemoryUtil.memGetAddress(struct + (long)VERTEXPOSITIONS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static XrVector3f.Buffer nvertexNormals(long struct) {
        return XrVector3f.create(MemoryUtil.memGetAddress(struct + (long)VERTEXNORMALS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static XrVector2f.Buffer nvertexUVs(long struct) {
        return XrVector2f.create(MemoryUtil.memGetAddress(struct + (long)VERTEXUVS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static XrVector4sFB.Buffer nvertexBlendIndices(long struct) {
        return XrVector4sFB.create(MemoryUtil.memGetAddress(struct + (long)VERTEXBLENDINDICES), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static XrVector4f.Buffer nvertexBlendWeights(long struct) {
        return XrVector4f.create(MemoryUtil.memGetAddress(struct + (long)VERTEXBLENDWEIGHTS), XrHandTrackingMeshFB.nvertexCapacityInput(struct));
    }

    public static int nindexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCAPACITYINPUT);
    }

    public static int nindexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCOUNTOUTPUT);
    }

    public static ShortBuffer nindices(long struct) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)INDICES), XrHandTrackingMeshFB.nindexCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void njointCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)JOINTCAPACITYINPUT, value);
    }

    public static void njointCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)JOINTCOUNTOUTPUT, value);
    }

    public static void njointBindPoses(long struct, XrPosef.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTBINDPOSES, value.address());
    }

    public static void njointRadii(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTRADII, MemoryUtil.memAddress(value));
    }

    public static void njointParents(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTPARENTS, MemoryUtil.memAddress(value));
    }

    public static void nvertexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertexPositions(long struct, XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXPOSITIONS, value.address());
    }

    public static void nvertexNormals(long struct, XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXNORMALS, value.address());
    }

    public static void nvertexUVs(long struct, XrVector2f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXUVS, value.address());
    }

    public static void nvertexBlendIndices(long struct, XrVector4sFB.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXBLENDINDICES, value.address());
    }

    public static void nvertexBlendWeights(long struct, XrVector4f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXBLENDWEIGHTS, value.address());
    }

    public static void nindexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCAPACITYINPUT, value);
    }

    public static void nindexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCOUNTOUTPUT, value);
    }

    public static void nindices(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDICES, MemoryUtil.memAddress(value));
        XrHandTrackingMeshFB.nindexCapacityInput(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JOINTBINDPOSES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JOINTRADII));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JOINTPARENTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEXPOSITIONS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEXNORMALS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEXUVS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEXBLENDINDICES));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTEXBLENDWEIGHTS));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INDICES));
    }

    static {
        Struct.Layout layout = XrHandTrackingMeshFB.__struct(XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(POINTER_SIZE), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(4), XrHandTrackingMeshFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        JOINTCAPACITYINPUT = layout.offsetof(2);
        JOINTCOUNTOUTPUT = layout.offsetof(3);
        JOINTBINDPOSES = layout.offsetof(4);
        JOINTRADII = layout.offsetof(5);
        JOINTPARENTS = layout.offsetof(6);
        VERTEXCAPACITYINPUT = layout.offsetof(7);
        VERTEXCOUNTOUTPUT = layout.offsetof(8);
        VERTEXPOSITIONS = layout.offsetof(9);
        VERTEXNORMALS = layout.offsetof(10);
        VERTEXUVS = layout.offsetof(11);
        VERTEXBLENDINDICES = layout.offsetof(12);
        VERTEXBLENDWEIGHTS = layout.offsetof(13);
        INDEXCAPACITYINPUT = layout.offsetof(14);
        INDEXCOUNTOUTPUT = layout.offsetof(15);
        INDICES = layout.offsetof(16);
    }

    public static class Buffer
    extends StructBuffer<XrHandTrackingMeshFB, Buffer>
    implements NativeResource {
        private static final XrHandTrackingMeshFB ELEMENT_FACTORY = XrHandTrackingMeshFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandTrackingMeshFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandTrackingMeshFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandTrackingMeshFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCapacityInput() {
            return XrHandTrackingMeshFB.njointCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCountOutput() {
            return XrHandTrackingMeshFB.njointCountOutput(this.address());
        }

        @NativeType(value="XrPosef *")
        public XrPosef.Buffer jointBindPoses() {
            return XrHandTrackingMeshFB.njointBindPoses(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer jointRadii() {
            return XrHandTrackingMeshFB.njointRadii(this.address());
        }

        @NativeType(value="XrHandJointEXT *")
        public IntBuffer jointParents() {
            return XrHandTrackingMeshFB.njointParents(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrHandTrackingMeshFB.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrHandTrackingMeshFB.nvertexCountOutput(this.address());
        }

        @NativeType(value="XrVector3f *")
        public XrVector3f.Buffer vertexPositions() {
            return XrHandTrackingMeshFB.nvertexPositions(this.address());
        }

        @NativeType(value="XrVector3f *")
        public XrVector3f.Buffer vertexNormals() {
            return XrHandTrackingMeshFB.nvertexNormals(this.address());
        }

        @NativeType(value="XrVector2f *")
        public XrVector2f.Buffer vertexUVs() {
            return XrHandTrackingMeshFB.nvertexUVs(this.address());
        }

        @NativeType(value="XrVector4sFB *")
        public XrVector4sFB.Buffer vertexBlendIndices() {
            return XrHandTrackingMeshFB.nvertexBlendIndices(this.address());
        }

        @NativeType(value="XrVector4f *")
        public XrVector4f.Buffer vertexBlendWeights() {
            return XrHandTrackingMeshFB.nvertexBlendWeights(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCapacityInput() {
            return XrHandTrackingMeshFB.nindexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCountOutput() {
            return XrHandTrackingMeshFB.nindexCountOutput(this.address());
        }

        @NativeType(value="int16_t *")
        public ShortBuffer indices() {
            return XrHandTrackingMeshFB.nindices(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandTrackingMeshFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000110001);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandTrackingMeshFB.nnext(this.address(), value);
            return this;
        }

        public Buffer jointCapacityInput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.njointCapacityInput(this.address(), value);
            return this;
        }

        public Buffer jointCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.njointCountOutput(this.address(), value);
            return this;
        }

        public Buffer jointBindPoses(@NativeType(value="XrPosef *") XrPosef.Buffer value) {
            XrHandTrackingMeshFB.njointBindPoses(this.address(), value);
            return this;
        }

        public Buffer jointRadii(@NativeType(value="float *") FloatBuffer value) {
            XrHandTrackingMeshFB.njointRadii(this.address(), value);
            return this;
        }

        public Buffer jointParents(@NativeType(value="XrHandJointEXT *") IntBuffer value) {
            XrHandTrackingMeshFB.njointParents(this.address(), value);
            return this;
        }

        public Buffer vertexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.nvertexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertexPositions(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
            XrHandTrackingMeshFB.nvertexPositions(this.address(), value);
            return this;
        }

        public Buffer vertexNormals(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
            XrHandTrackingMeshFB.nvertexNormals(this.address(), value);
            return this;
        }

        public Buffer vertexUVs(@NativeType(value="XrVector2f *") XrVector2f.Buffer value) {
            XrHandTrackingMeshFB.nvertexUVs(this.address(), value);
            return this;
        }

        public Buffer vertexBlendIndices(@NativeType(value="XrVector4sFB *") XrVector4sFB.Buffer value) {
            XrHandTrackingMeshFB.nvertexBlendIndices(this.address(), value);
            return this;
        }

        public Buffer vertexBlendWeights(@NativeType(value="XrVector4f *") XrVector4f.Buffer value) {
            XrHandTrackingMeshFB.nvertexBlendWeights(this.address(), value);
            return this;
        }

        public Buffer indexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandTrackingMeshFB.nindexCountOutput(this.address(), value);
            return this;
        }

        public Buffer indices(@NativeType(value="int16_t *") ShortBuffer value) {
            XrHandTrackingMeshFB.nindices(this.address(), value);
            return this;
        }
    }
}

