/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandPoseTypeInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int HANDPOSETYPE;

    public XrHandPoseTypeInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandPoseTypeInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandPoseTypeInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHandPoseTypeInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrHandPoseTypeMSFT")
    public int handPoseType() {
        return XrHandPoseTypeInfoMSFT.nhandPoseType(this.address());
    }

    public XrHandPoseTypeInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrHandPoseTypeInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrHandPoseTypeInfoMSFT type$Default() {
        return this.type(1000052004);
    }

    public XrHandPoseTypeInfoMSFT next(@NativeType(value="void const *") long value) {
        XrHandPoseTypeInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrHandPoseTypeInfoMSFT handPoseType(@NativeType(value="XrHandPoseTypeMSFT") int value) {
        XrHandPoseTypeInfoMSFT.nhandPoseType(this.address(), value);
        return this;
    }

    public XrHandPoseTypeInfoMSFT set(int type, long next, int handPoseType) {
        this.type(type);
        this.next(next);
        this.handPoseType(handPoseType);
        return this;
    }

    public XrHandPoseTypeInfoMSFT set(XrHandPoseTypeInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandPoseTypeInfoMSFT malloc() {
        return XrHandPoseTypeInfoMSFT.wrap(XrHandPoseTypeInfoMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandPoseTypeInfoMSFT calloc() {
        return XrHandPoseTypeInfoMSFT.wrap(XrHandPoseTypeInfoMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandPoseTypeInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandPoseTypeInfoMSFT.wrap(XrHandPoseTypeInfoMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandPoseTypeInfoMSFT create(long address) {
        return XrHandPoseTypeInfoMSFT.wrap(XrHandPoseTypeInfoMSFT.class, address);
    }

    @Nullable
    public static XrHandPoseTypeInfoMSFT createSafe(long address) {
        return address == 0L ? null : XrHandPoseTypeInfoMSFT.wrap(XrHandPoseTypeInfoMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandPoseTypeInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandPoseTypeInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandPoseTypeInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandPoseTypeInfoMSFT.__create(capacity, SIZEOF);
        return XrHandPoseTypeInfoMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandPoseTypeInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandPoseTypeInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandPoseTypeInfoMSFT malloc(MemoryStack stack) {
        return XrHandPoseTypeInfoMSFT.wrap(XrHandPoseTypeInfoMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandPoseTypeInfoMSFT calloc(MemoryStack stack) {
        return XrHandPoseTypeInfoMSFT.wrap(XrHandPoseTypeInfoMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandPoseTypeInfoMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandPoseTypeInfoMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nhandPoseType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDPOSETYPE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nhandPoseType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDPOSETYPE, value);
    }

    static {
        Struct.Layout layout = XrHandPoseTypeInfoMSFT.__struct(XrHandPoseTypeInfoMSFT.__member(4), XrHandPoseTypeInfoMSFT.__member(POINTER_SIZE), XrHandPoseTypeInfoMSFT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        HANDPOSETYPE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrHandPoseTypeInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrHandPoseTypeInfoMSFT ELEMENT_FACTORY = XrHandPoseTypeInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandPoseTypeInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandPoseTypeInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHandPoseTypeInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrHandPoseTypeMSFT")
        public int handPoseType() {
            return XrHandPoseTypeInfoMSFT.nhandPoseType(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandPoseTypeInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000052004);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHandPoseTypeInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer handPoseType(@NativeType(value="XrHandPoseTypeMSFT") int value) {
            XrHandPoseTypeInfoMSFT.nhandPoseType(this.address(), value);
            return this;
        }
    }
}

