/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshVertexMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITION;
    public static final int NORMAL;

    public XrHandMeshVertexMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandMeshVertexMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrVector3f position$() {
        return XrHandMeshVertexMSFT.nposition$(this.address());
    }

    public XrVector3f normal() {
        return XrHandMeshVertexMSFT.nnormal(this.address());
    }

    public XrHandMeshVertexMSFT position$(XrVector3f value) {
        XrHandMeshVertexMSFT.nposition$(this.address(), value);
        return this;
    }

    public XrHandMeshVertexMSFT position$(Consumer<XrVector3f> consumer) {
        consumer.accept(this.position$());
        return this;
    }

    public XrHandMeshVertexMSFT normal(XrVector3f value) {
        XrHandMeshVertexMSFT.nnormal(this.address(), value);
        return this;
    }

    public XrHandMeshVertexMSFT normal(Consumer<XrVector3f> consumer) {
        consumer.accept(this.normal());
        return this;
    }

    public XrHandMeshVertexMSFT set(XrVector3f position$, XrVector3f normal) {
        this.position$(position$);
        this.normal(normal);
        return this;
    }

    public XrHandMeshVertexMSFT set(XrHandMeshVertexMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandMeshVertexMSFT malloc() {
        return XrHandMeshVertexMSFT.wrap(XrHandMeshVertexMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandMeshVertexMSFT calloc() {
        return XrHandMeshVertexMSFT.wrap(XrHandMeshVertexMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandMeshVertexMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandMeshVertexMSFT.wrap(XrHandMeshVertexMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandMeshVertexMSFT create(long address) {
        return XrHandMeshVertexMSFT.wrap(XrHandMeshVertexMSFT.class, address);
    }

    @Nullable
    public static XrHandMeshVertexMSFT createSafe(long address) {
        return address == 0L ? null : XrHandMeshVertexMSFT.wrap(XrHandMeshVertexMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandMeshVertexMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandMeshVertexMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandMeshVertexMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshVertexMSFT.__create(capacity, SIZEOF);
        return XrHandMeshVertexMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandMeshVertexMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandMeshVertexMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandMeshVertexMSFT malloc(MemoryStack stack) {
        return XrHandMeshVertexMSFT.wrap(XrHandMeshVertexMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandMeshVertexMSFT calloc(MemoryStack stack) {
        return XrHandMeshVertexMSFT.wrap(XrHandMeshVertexMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandMeshVertexMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandMeshVertexMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrVector3f nposition$(long struct) {
        return XrVector3f.create(struct + (long)POSITION);
    }

    public static XrVector3f nnormal(long struct) {
        return XrVector3f.create(struct + (long)NORMAL);
    }

    public static void nposition$(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSITION, XrVector3f.SIZEOF);
    }

    public static void nnormal(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NORMAL, XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrHandMeshVertexMSFT.__struct(XrHandMeshVertexMSFT.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF), XrHandMeshVertexMSFT.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITION = layout.offsetof(0);
        NORMAL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshVertexMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshVertexMSFT ELEMENT_FACTORY = XrHandMeshVertexMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandMeshVertexMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrVector3f position$() {
            return XrHandMeshVertexMSFT.nposition$(this.address());
        }

        public XrVector3f normal() {
            return XrHandMeshVertexMSFT.nnormal(this.address());
        }

        public Buffer position$(XrVector3f value) {
            XrHandMeshVertexMSFT.nposition$(this.address(), value);
            return this;
        }

        public Buffer position$(Consumer<XrVector3f> consumer) {
            consumer.accept(this.position$());
            return this;
        }

        public Buffer normal(XrVector3f value) {
            XrHandMeshVertexMSFT.nnormal(this.address(), value);
            return this;
        }

        public Buffer normal(Consumer<XrVector3f> consumer) {
            consumer.accept(this.normal());
            return this;
        }
    }
}

