/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandMeshVertexMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshVertexBufferMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEXUPDATETIME;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTICES;

    public XrHandMeshVertexBufferMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandMeshVertexBufferMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrTime")
    public long vertexUpdateTime() {
        return XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrHandMeshVertexBufferMSFT.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address());
    }

    @NativeType(value="XrHandMeshVertexMSFT *")
    public XrHandMeshVertexMSFT.Buffer vertices() {
        return XrHandMeshVertexBufferMSFT.nvertices(this.address());
    }

    public XrHandMeshVertexBufferMSFT vertexUpdateTime(@NativeType(value="XrTime") long value) {
        XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address(), value);
        return this;
    }

    public XrHandMeshVertexBufferMSFT vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrHandMeshVertexBufferMSFT vertices(@NativeType(value="XrHandMeshVertexMSFT *") XrHandMeshVertexMSFT.Buffer value) {
        XrHandMeshVertexBufferMSFT.nvertices(this.address(), value);
        return this;
    }

    public XrHandMeshVertexBufferMSFT set(long vertexUpdateTime, int vertexCountOutput, XrHandMeshVertexMSFT.Buffer vertices) {
        this.vertexUpdateTime(vertexUpdateTime);
        this.vertexCountOutput(vertexCountOutput);
        this.vertices(vertices);
        return this;
    }

    public XrHandMeshVertexBufferMSFT set(XrHandMeshVertexBufferMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandMeshVertexBufferMSFT malloc() {
        return XrHandMeshVertexBufferMSFT.wrap(XrHandMeshVertexBufferMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandMeshVertexBufferMSFT calloc() {
        return XrHandMeshVertexBufferMSFT.wrap(XrHandMeshVertexBufferMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandMeshVertexBufferMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandMeshVertexBufferMSFT.wrap(XrHandMeshVertexBufferMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandMeshVertexBufferMSFT create(long address) {
        return XrHandMeshVertexBufferMSFT.wrap(XrHandMeshVertexBufferMSFT.class, address);
    }

    @Nullable
    public static XrHandMeshVertexBufferMSFT createSafe(long address) {
        return address == 0L ? null : XrHandMeshVertexBufferMSFT.wrap(XrHandMeshVertexBufferMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandMeshVertexBufferMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandMeshVertexBufferMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandMeshVertexBufferMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshVertexBufferMSFT.__create(capacity, SIZEOF);
        return XrHandMeshVertexBufferMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandMeshVertexBufferMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandMeshVertexBufferMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandMeshVertexBufferMSFT malloc(MemoryStack stack) {
        return XrHandMeshVertexBufferMSFT.wrap(XrHandMeshVertexBufferMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandMeshVertexBufferMSFT calloc(MemoryStack stack) {
        return XrHandMeshVertexBufferMSFT.wrap(XrHandMeshVertexBufferMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandMeshVertexBufferMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandMeshVertexBufferMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nvertexUpdateTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)VERTEXUPDATETIME);
    }

    public static int nvertexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNTOUTPUT);
    }

    public static XrHandMeshVertexMSFT.Buffer nvertices(long struct) {
        return XrHandMeshVertexMSFT.create(MemoryUtil.memGetAddress(struct + (long)VERTICES), XrHandMeshVertexBufferMSFT.nvertexCapacityInput(struct));
    }

    public static void nvertexUpdateTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VERTEXUPDATETIME, value);
    }

    public static void nvertexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertices(long struct, XrHandMeshVertexMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTICES, value.address());
        XrHandMeshVertexBufferMSFT.nvertexCapacityInput(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)VERTICES));
    }

    static {
        Struct.Layout layout = XrHandMeshVertexBufferMSFT.__struct(XrHandMeshVertexBufferMSFT.__member(8), XrHandMeshVertexBufferMSFT.__member(4), XrHandMeshVertexBufferMSFT.__member(4), XrHandMeshVertexBufferMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEXUPDATETIME = layout.offsetof(0);
        VERTEXCAPACITYINPUT = layout.offsetof(1);
        VERTEXCOUNTOUTPUT = layout.offsetof(2);
        VERTICES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshVertexBufferMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshVertexBufferMSFT ELEMENT_FACTORY = XrHandMeshVertexBufferMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandMeshVertexBufferMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrTime")
        public long vertexUpdateTime() {
            return XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrHandMeshVertexBufferMSFT.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address());
        }

        @NativeType(value="XrHandMeshVertexMSFT *")
        public XrHandMeshVertexMSFT.Buffer vertices() {
            return XrHandMeshVertexBufferMSFT.nvertices(this.address());
        }

        public Buffer vertexUpdateTime(@NativeType(value="XrTime") long value) {
            XrHandMeshVertexBufferMSFT.nvertexUpdateTime(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrHandMeshVertexBufferMSFT.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertices(@NativeType(value="XrHandMeshVertexMSFT *") XrHandMeshVertexMSFT.Buffer value) {
            XrHandMeshVertexBufferMSFT.nvertices(this.address(), value);
            return this;
        }
    }
}

