/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandMeshSpaceCreateInfoMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int HANDPOSETYPE;
    public static final int POSEINHANDMESHSPACE;

    public XrHandMeshSpaceCreateInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandMeshSpaceCreateInfoMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandMeshSpaceCreateInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHandMeshSpaceCreateInfoMSFT.nnext(this.address());
    }

    @NativeType(value="XrHandPoseTypeMSFT")
    public int handPoseType() {
        return XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address());
    }

    public XrPosef poseInHandMeshSpace() {
        return XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address());
    }

    public XrHandMeshSpaceCreateInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrHandMeshSpaceCreateInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT type$Default() {
        return this.type(1000052001);
    }

    public XrHandMeshSpaceCreateInfoMSFT next(@NativeType(value="void const *") long value) {
        XrHandMeshSpaceCreateInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT handPoseType(@NativeType(value="XrHandPoseTypeMSFT") int value) {
        XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT poseInHandMeshSpace(XrPosef value) {
        XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address(), value);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT poseInHandMeshSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInHandMeshSpace());
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT set(int type, long next, int handPoseType, XrPosef poseInHandMeshSpace) {
        this.type(type);
        this.next(next);
        this.handPoseType(handPoseType);
        this.poseInHandMeshSpace(poseInHandMeshSpace);
        return this;
    }

    public XrHandMeshSpaceCreateInfoMSFT set(XrHandMeshSpaceCreateInfoMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandMeshSpaceCreateInfoMSFT malloc() {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(XrHandMeshSpaceCreateInfoMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandMeshSpaceCreateInfoMSFT calloc() {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(XrHandMeshSpaceCreateInfoMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandMeshSpaceCreateInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandMeshSpaceCreateInfoMSFT.wrap(XrHandMeshSpaceCreateInfoMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandMeshSpaceCreateInfoMSFT create(long address) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(XrHandMeshSpaceCreateInfoMSFT.class, address);
    }

    @Nullable
    public static XrHandMeshSpaceCreateInfoMSFT createSafe(long address) {
        return address == 0L ? null : XrHandMeshSpaceCreateInfoMSFT.wrap(XrHandMeshSpaceCreateInfoMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandMeshSpaceCreateInfoMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandMeshSpaceCreateInfoMSFT.__create(capacity, SIZEOF);
        return XrHandMeshSpaceCreateInfoMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandMeshSpaceCreateInfoMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandMeshSpaceCreateInfoMSFT malloc(MemoryStack stack) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(XrHandMeshSpaceCreateInfoMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandMeshSpaceCreateInfoMSFT calloc(MemoryStack stack) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(XrHandMeshSpaceCreateInfoMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandMeshSpaceCreateInfoMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nhandPoseType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDPOSETYPE);
    }

    public static XrPosef nposeInHandMeshSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINHANDMESHSPACE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nhandPoseType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDPOSETYPE, value);
    }

    public static void nposeInHandMeshSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINHANDMESHSPACE, XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrHandMeshSpaceCreateInfoMSFT.__struct(XrHandMeshSpaceCreateInfoMSFT.__member(4), XrHandMeshSpaceCreateInfoMSFT.__member(POINTER_SIZE), XrHandMeshSpaceCreateInfoMSFT.__member(4), XrHandMeshSpaceCreateInfoMSFT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        HANDPOSETYPE = layout.offsetof(2);
        POSEINHANDMESHSPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandMeshSpaceCreateInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrHandMeshSpaceCreateInfoMSFT ELEMENT_FACTORY = XrHandMeshSpaceCreateInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandMeshSpaceCreateInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandMeshSpaceCreateInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHandMeshSpaceCreateInfoMSFT.nnext(this.address());
        }

        @NativeType(value="XrHandPoseTypeMSFT")
        public int handPoseType() {
            return XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address());
        }

        public XrPosef poseInHandMeshSpace() {
            return XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandMeshSpaceCreateInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000052001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHandMeshSpaceCreateInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer handPoseType(@NativeType(value="XrHandPoseTypeMSFT") int value) {
            XrHandMeshSpaceCreateInfoMSFT.nhandPoseType(this.address(), value);
            return this;
        }

        public Buffer poseInHandMeshSpace(XrPosef value) {
            XrHandMeshSpaceCreateInfoMSFT.nposeInHandMeshSpace(this.address(), value);
            return this;
        }

        public Buffer poseInHandMeshSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInHandMeshSpace());
            return this;
        }
    }
}

