/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandJointVelocityEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VELOCITYFLAGS;
    public static final int LINEARVELOCITY;
    public static final int ANGULARVELOCITY;

    public XrHandJointVelocityEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandJointVelocityEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceVelocityFlags")
    public long velocityFlags() {
        return XrHandJointVelocityEXT.nvelocityFlags(this.address());
    }

    public XrVector3f linearVelocity() {
        return XrHandJointVelocityEXT.nlinearVelocity(this.address());
    }

    public XrVector3f angularVelocity() {
        return XrHandJointVelocityEXT.nangularVelocity(this.address());
    }

    public XrHandJointVelocityEXT velocityFlags(@NativeType(value="XrSpaceVelocityFlags") long value) {
        XrHandJointVelocityEXT.nvelocityFlags(this.address(), value);
        return this;
    }

    public XrHandJointVelocityEXT linearVelocity(XrVector3f value) {
        XrHandJointVelocityEXT.nlinearVelocity(this.address(), value);
        return this;
    }

    public XrHandJointVelocityEXT linearVelocity(Consumer<XrVector3f> consumer) {
        consumer.accept(this.linearVelocity());
        return this;
    }

    public XrHandJointVelocityEXT angularVelocity(XrVector3f value) {
        XrHandJointVelocityEXT.nangularVelocity(this.address(), value);
        return this;
    }

    public XrHandJointVelocityEXT angularVelocity(Consumer<XrVector3f> consumer) {
        consumer.accept(this.angularVelocity());
        return this;
    }

    public XrHandJointVelocityEXT set(long velocityFlags, XrVector3f linearVelocity, XrVector3f angularVelocity) {
        this.velocityFlags(velocityFlags);
        this.linearVelocity(linearVelocity);
        this.angularVelocity(angularVelocity);
        return this;
    }

    public XrHandJointVelocityEXT set(XrHandJointVelocityEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandJointVelocityEXT malloc() {
        return XrHandJointVelocityEXT.wrap(XrHandJointVelocityEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandJointVelocityEXT calloc() {
        return XrHandJointVelocityEXT.wrap(XrHandJointVelocityEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandJointVelocityEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandJointVelocityEXT.wrap(XrHandJointVelocityEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandJointVelocityEXT create(long address) {
        return XrHandJointVelocityEXT.wrap(XrHandJointVelocityEXT.class, address);
    }

    @Nullable
    public static XrHandJointVelocityEXT createSafe(long address) {
        return address == 0L ? null : XrHandJointVelocityEXT.wrap(XrHandJointVelocityEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandJointVelocityEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandJointVelocityEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandJointVelocityEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandJointVelocityEXT.__create(capacity, SIZEOF);
        return XrHandJointVelocityEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandJointVelocityEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandJointVelocityEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandJointVelocityEXT malloc(MemoryStack stack) {
        return XrHandJointVelocityEXT.wrap(XrHandJointVelocityEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandJointVelocityEXT calloc(MemoryStack stack) {
        return XrHandJointVelocityEXT.wrap(XrHandJointVelocityEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandJointVelocityEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandJointVelocityEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nvelocityFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)VELOCITYFLAGS);
    }

    public static XrVector3f nlinearVelocity(long struct) {
        return XrVector3f.create(struct + (long)LINEARVELOCITY);
    }

    public static XrVector3f nangularVelocity(long struct) {
        return XrVector3f.create(struct + (long)ANGULARVELOCITY);
    }

    public static void nvelocityFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VELOCITYFLAGS, value);
    }

    public static void nlinearVelocity(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LINEARVELOCITY, XrVector3f.SIZEOF);
    }

    public static void nangularVelocity(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ANGULARVELOCITY, XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrHandJointVelocityEXT.__struct(XrHandJointVelocityEXT.__member(8), XrHandJointVelocityEXT.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF), XrHandJointVelocityEXT.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VELOCITYFLAGS = layout.offsetof(0);
        LINEARVELOCITY = layout.offsetof(1);
        ANGULARVELOCITY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrHandJointVelocityEXT, Buffer>
    implements NativeResource {
        private static final XrHandJointVelocityEXT ELEMENT_FACTORY = XrHandJointVelocityEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandJointVelocityEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceVelocityFlags")
        public long velocityFlags() {
            return XrHandJointVelocityEXT.nvelocityFlags(this.address());
        }

        public XrVector3f linearVelocity() {
            return XrHandJointVelocityEXT.nlinearVelocity(this.address());
        }

        public XrVector3f angularVelocity() {
            return XrHandJointVelocityEXT.nangularVelocity(this.address());
        }

        public Buffer velocityFlags(@NativeType(value="XrSpaceVelocityFlags") long value) {
            XrHandJointVelocityEXT.nvelocityFlags(this.address(), value);
            return this;
        }

        public Buffer linearVelocity(XrVector3f value) {
            XrHandJointVelocityEXT.nlinearVelocity(this.address(), value);
            return this;
        }

        public Buffer linearVelocity(Consumer<XrVector3f> consumer) {
            consumer.accept(this.linearVelocity());
            return this;
        }

        public Buffer angularVelocity(XrVector3f value) {
            XrHandJointVelocityEXT.nangularVelocity(this.address(), value);
            return this;
        }

        public Buffer angularVelocity(Consumer<XrVector3f> consumer) {
            consumer.accept(this.angularVelocity());
            return this;
        }
    }
}

