/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHandJointVelocityEXT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandJointVelocitiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int JOINTCOUNT;
    public static final int JOINTVELOCITIES;

    public XrHandJointVelocitiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandJointVelocitiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHandJointVelocitiesEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrHandJointVelocitiesEXT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCount() {
        return XrHandJointVelocitiesEXT.njointCount(this.address());
    }

    @NativeType(value="XrHandJointVelocityEXT *")
    public XrHandJointVelocityEXT.Buffer jointVelocities() {
        return XrHandJointVelocitiesEXT.njointVelocities(this.address());
    }

    public XrHandJointVelocitiesEXT type(@NativeType(value="XrStructureType") int value) {
        XrHandJointVelocitiesEXT.ntype(this.address(), value);
        return this;
    }

    public XrHandJointVelocitiesEXT type$Default() {
        return this.type(1000051004);
    }

    public XrHandJointVelocitiesEXT next(@NativeType(value="void *") long value) {
        XrHandJointVelocitiesEXT.nnext(this.address(), value);
        return this;
    }

    public XrHandJointVelocitiesEXT jointVelocities(@NativeType(value="XrHandJointVelocityEXT *") XrHandJointVelocityEXT.Buffer value) {
        XrHandJointVelocitiesEXT.njointVelocities(this.address(), value);
        return this;
    }

    public XrHandJointVelocitiesEXT set(int type, long next, XrHandJointVelocityEXT.Buffer jointVelocities) {
        this.type(type);
        this.next(next);
        this.jointVelocities(jointVelocities);
        return this;
    }

    public XrHandJointVelocitiesEXT set(XrHandJointVelocitiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandJointVelocitiesEXT malloc() {
        return XrHandJointVelocitiesEXT.wrap(XrHandJointVelocitiesEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandJointVelocitiesEXT calloc() {
        return XrHandJointVelocitiesEXT.wrap(XrHandJointVelocitiesEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandJointVelocitiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandJointVelocitiesEXT.wrap(XrHandJointVelocitiesEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandJointVelocitiesEXT create(long address) {
        return XrHandJointVelocitiesEXT.wrap(XrHandJointVelocitiesEXT.class, address);
    }

    @Nullable
    public static XrHandJointVelocitiesEXT createSafe(long address) {
        return address == 0L ? null : XrHandJointVelocitiesEXT.wrap(XrHandJointVelocitiesEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandJointVelocitiesEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandJointVelocitiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandJointVelocitiesEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandJointVelocitiesEXT.__create(capacity, SIZEOF);
        return XrHandJointVelocitiesEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandJointVelocitiesEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandJointVelocitiesEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandJointVelocitiesEXT malloc(MemoryStack stack) {
        return XrHandJointVelocitiesEXT.wrap(XrHandJointVelocitiesEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandJointVelocitiesEXT calloc(MemoryStack stack) {
        return XrHandJointVelocitiesEXT.wrap(XrHandJointVelocitiesEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandJointVelocitiesEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandJointVelocitiesEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int njointCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)JOINTCOUNT);
    }

    public static XrHandJointVelocityEXT.Buffer njointVelocities(long struct) {
        return XrHandJointVelocityEXT.create(MemoryUtil.memGetAddress(struct + (long)JOINTVELOCITIES), XrHandJointVelocitiesEXT.njointCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void njointCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)JOINTCOUNT, value);
    }

    public static void njointVelocities(long struct, XrHandJointVelocityEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)JOINTVELOCITIES, value.address());
        XrHandJointVelocitiesEXT.njointCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JOINTVELOCITIES));
    }

    static {
        Struct.Layout layout = XrHandJointVelocitiesEXT.__struct(XrHandJointVelocitiesEXT.__member(4), XrHandJointVelocitiesEXT.__member(POINTER_SIZE), XrHandJointVelocitiesEXT.__member(4), XrHandJointVelocitiesEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        JOINTCOUNT = layout.offsetof(2);
        JOINTVELOCITIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHandJointVelocitiesEXT, Buffer>
    implements NativeResource {
        private static final XrHandJointVelocitiesEXT ELEMENT_FACTORY = XrHandJointVelocitiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandJointVelocitiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHandJointVelocitiesEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrHandJointVelocitiesEXT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCount() {
            return XrHandJointVelocitiesEXT.njointCount(this.address());
        }

        @NativeType(value="XrHandJointVelocityEXT *")
        public XrHandJointVelocityEXT.Buffer jointVelocities() {
            return XrHandJointVelocitiesEXT.njointVelocities(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHandJointVelocitiesEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000051004);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrHandJointVelocitiesEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer jointVelocities(@NativeType(value="XrHandJointVelocityEXT *") XrHandJointVelocityEXT.Buffer value) {
            XrHandJointVelocitiesEXT.njointVelocities(this.address(), value);
            return this;
        }
    }
}

