/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandJointLocationEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATIONFLAGS;
    public static final int POSE;
    public static final int RADIUS;

    public XrHandJointLocationEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHandJointLocationEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceLocationFlags")
    public long locationFlags() {
        return XrHandJointLocationEXT.nlocationFlags(this.address());
    }

    public XrPosef pose() {
        return XrHandJointLocationEXT.npose(this.address());
    }

    public float radius() {
        return XrHandJointLocationEXT.nradius(this.address());
    }

    public XrHandJointLocationEXT locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
        XrHandJointLocationEXT.nlocationFlags(this.address(), value);
        return this;
    }

    public XrHandJointLocationEXT pose(XrPosef value) {
        XrHandJointLocationEXT.npose(this.address(), value);
        return this;
    }

    public XrHandJointLocationEXT pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrHandJointLocationEXT radius(float value) {
        XrHandJointLocationEXT.nradius(this.address(), value);
        return this;
    }

    public XrHandJointLocationEXT set(long locationFlags, XrPosef pose, float radius) {
        this.locationFlags(locationFlags);
        this.pose(pose);
        this.radius(radius);
        return this;
    }

    public XrHandJointLocationEXT set(XrHandJointLocationEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHandJointLocationEXT malloc() {
        return XrHandJointLocationEXT.wrap(XrHandJointLocationEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHandJointLocationEXT calloc() {
        return XrHandJointLocationEXT.wrap(XrHandJointLocationEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHandJointLocationEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHandJointLocationEXT.wrap(XrHandJointLocationEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHandJointLocationEXT create(long address) {
        return XrHandJointLocationEXT.wrap(XrHandJointLocationEXT.class, address);
    }

    @Nullable
    public static XrHandJointLocationEXT createSafe(long address) {
        return address == 0L ? null : XrHandJointLocationEXT.wrap(XrHandJointLocationEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrHandJointLocationEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHandJointLocationEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHandJointLocationEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandJointLocationEXT.__create(capacity, SIZEOF);
        return XrHandJointLocationEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHandJointLocationEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHandJointLocationEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrHandJointLocationEXT malloc(MemoryStack stack) {
        return XrHandJointLocationEXT.wrap(XrHandJointLocationEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHandJointLocationEXT calloc(MemoryStack stack) {
        return XrHandJointLocationEXT.wrap(XrHandJointLocationEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHandJointLocationEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHandJointLocationEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlocationFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOCATIONFLAGS);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static void nlocationFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LOCATIONFLAGS, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RADIUS, value);
    }

    static {
        Struct.Layout layout = XrHandJointLocationEXT.__struct(XrHandJointLocationEXT.__member(8), XrHandJointLocationEXT.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrHandJointLocationEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATIONFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
        RADIUS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrHandJointLocationEXT, Buffer>
    implements NativeResource {
        private static final XrHandJointLocationEXT ELEMENT_FACTORY = XrHandJointLocationEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHandJointLocationEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceLocationFlags")
        public long locationFlags() {
            return XrHandJointLocationEXT.nlocationFlags(this.address());
        }

        public XrPosef pose() {
            return XrHandJointLocationEXT.npose(this.address());
        }

        public float radius() {
            return XrHandJointLocationEXT.nradius(this.address());
        }

        public Buffer locationFlags(@NativeType(value="XrSpaceLocationFlags") long value) {
            XrHandJointLocationEXT.nlocationFlags(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrHandJointLocationEXT.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer radius(float value) {
            XrHandJointLocationEXT.nradius(this.address(), value);
            return this;
        }
    }
}

