/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGraphicsRequirementsOpenGLKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MINAPIVERSIONSUPPORTED;
    public static final int MAXAPIVERSIONSUPPORTED;

    public XrGraphicsRequirementsOpenGLKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrGraphicsRequirementsOpenGLKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGraphicsRequirementsOpenGLKHR.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrGraphicsRequirementsOpenGLKHR.nnext(this.address());
    }

    @NativeType(value="XrVersion")
    public long minApiVersionSupported() {
        return XrGraphicsRequirementsOpenGLKHR.nminApiVersionSupported(this.address());
    }

    @NativeType(value="XrVersion")
    public long maxApiVersionSupported() {
        return XrGraphicsRequirementsOpenGLKHR.nmaxApiVersionSupported(this.address());
    }

    public XrGraphicsRequirementsOpenGLKHR type(@NativeType(value="XrStructureType") int value) {
        XrGraphicsRequirementsOpenGLKHR.ntype(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLKHR type$Default() {
        return this.type(1000023005);
    }

    public XrGraphicsRequirementsOpenGLKHR next(@NativeType(value="void *") long value) {
        XrGraphicsRequirementsOpenGLKHR.nnext(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLKHR minApiVersionSupported(@NativeType(value="XrVersion") long value) {
        XrGraphicsRequirementsOpenGLKHR.nminApiVersionSupported(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLKHR maxApiVersionSupported(@NativeType(value="XrVersion") long value) {
        XrGraphicsRequirementsOpenGLKHR.nmaxApiVersionSupported(this.address(), value);
        return this;
    }

    public XrGraphicsRequirementsOpenGLKHR set(int type, long next, long minApiVersionSupported, long maxApiVersionSupported) {
        this.type(type);
        this.next(next);
        this.minApiVersionSupported(minApiVersionSupported);
        this.maxApiVersionSupported(maxApiVersionSupported);
        return this;
    }

    public XrGraphicsRequirementsOpenGLKHR set(XrGraphicsRequirementsOpenGLKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrGraphicsRequirementsOpenGLKHR malloc() {
        return XrGraphicsRequirementsOpenGLKHR.wrap(XrGraphicsRequirementsOpenGLKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrGraphicsRequirementsOpenGLKHR calloc() {
        return XrGraphicsRequirementsOpenGLKHR.wrap(XrGraphicsRequirementsOpenGLKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrGraphicsRequirementsOpenGLKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrGraphicsRequirementsOpenGLKHR.wrap(XrGraphicsRequirementsOpenGLKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrGraphicsRequirementsOpenGLKHR create(long address) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(XrGraphicsRequirementsOpenGLKHR.class, address);
    }

    @Nullable
    public static XrGraphicsRequirementsOpenGLKHR createSafe(long address) {
        return address == 0L ? null : XrGraphicsRequirementsOpenGLKHR.wrap(XrGraphicsRequirementsOpenGLKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrGraphicsRequirementsOpenGLKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGraphicsRequirementsOpenGLKHR.__create(capacity, SIZEOF);
        return XrGraphicsRequirementsOpenGLKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrGraphicsRequirementsOpenGLKHR.wrap(Buffer.class, address, capacity);
    }

    public static XrGraphicsRequirementsOpenGLKHR malloc(MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(XrGraphicsRequirementsOpenGLKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGraphicsRequirementsOpenGLKHR calloc(MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(XrGraphicsRequirementsOpenGLKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrGraphicsRequirementsOpenGLKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nminApiVersionSupported(long struct) {
        return UNSAFE.getLong(null, struct + (long)MINAPIVERSIONSUPPORTED);
    }

    public static long nmaxApiVersionSupported(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXAPIVERSIONSUPPORTED);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nminApiVersionSupported(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MINAPIVERSIONSUPPORTED, value);
    }

    public static void nmaxApiVersionSupported(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXAPIVERSIONSUPPORTED, value);
    }

    static {
        Struct.Layout layout = XrGraphicsRequirementsOpenGLKHR.__struct(XrGraphicsRequirementsOpenGLKHR.__member(4), XrGraphicsRequirementsOpenGLKHR.__member(POINTER_SIZE), XrGraphicsRequirementsOpenGLKHR.__member(8), XrGraphicsRequirementsOpenGLKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MINAPIVERSIONSUPPORTED = layout.offsetof(2);
        MAXAPIVERSIONSUPPORTED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrGraphicsRequirementsOpenGLKHR, Buffer>
    implements NativeResource {
        private static final XrGraphicsRequirementsOpenGLKHR ELEMENT_FACTORY = XrGraphicsRequirementsOpenGLKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrGraphicsRequirementsOpenGLKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGraphicsRequirementsOpenGLKHR.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrGraphicsRequirementsOpenGLKHR.nnext(this.address());
        }

        @NativeType(value="XrVersion")
        public long minApiVersionSupported() {
            return XrGraphicsRequirementsOpenGLKHR.nminApiVersionSupported(this.address());
        }

        @NativeType(value="XrVersion")
        public long maxApiVersionSupported() {
            return XrGraphicsRequirementsOpenGLKHR.nmaxApiVersionSupported(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGraphicsRequirementsOpenGLKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000023005);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrGraphicsRequirementsOpenGLKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer minApiVersionSupported(@NativeType(value="XrVersion") long value) {
            XrGraphicsRequirementsOpenGLKHR.nminApiVersionSupported(this.address(), value);
            return this;
        }

        public Buffer maxApiVersionSupported(@NativeType(value="XrVersion") long value) {
            XrGraphicsRequirementsOpenGLKHR.nmaxApiVersionSupported(this.address(), value);
            return this;
        }
    }
}

