/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFrameWaitInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrFrameWaitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrFrameWaitInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFrameWaitInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFrameWaitInfo.nnext(this.address());
    }

    public XrFrameWaitInfo type(@NativeType(value="XrStructureType") int value) {
        XrFrameWaitInfo.ntype(this.address(), value);
        return this;
    }

    public XrFrameWaitInfo type$Default() {
        return this.type(33);
    }

    public XrFrameWaitInfo next(@NativeType(value="void const *") long value) {
        XrFrameWaitInfo.nnext(this.address(), value);
        return this;
    }

    public XrFrameWaitInfo set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrFrameWaitInfo set(XrFrameWaitInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrFrameWaitInfo malloc() {
        return XrFrameWaitInfo.wrap(XrFrameWaitInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrFrameWaitInfo calloc() {
        return XrFrameWaitInfo.wrap(XrFrameWaitInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrFrameWaitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrFrameWaitInfo.wrap(XrFrameWaitInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrFrameWaitInfo create(long address) {
        return XrFrameWaitInfo.wrap(XrFrameWaitInfo.class, address);
    }

    @Nullable
    public static XrFrameWaitInfo createSafe(long address) {
        return address == 0L ? null : XrFrameWaitInfo.wrap(XrFrameWaitInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrFrameWaitInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrFrameWaitInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrFrameWaitInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFrameWaitInfo.__create(capacity, SIZEOF);
        return XrFrameWaitInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrFrameWaitInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrFrameWaitInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrFrameWaitInfo malloc(MemoryStack stack) {
        return XrFrameWaitInfo.wrap(XrFrameWaitInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrFrameWaitInfo calloc(MemoryStack stack) {
        return XrFrameWaitInfo.wrap(XrFrameWaitInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrFrameWaitInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrFrameWaitInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrFrameWaitInfo.__struct(XrFrameWaitInfo.__member(4), XrFrameWaitInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrFrameWaitInfo, Buffer>
    implements NativeResource {
        private static final XrFrameWaitInfo ELEMENT_FACTORY = XrFrameWaitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrFrameWaitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFrameWaitInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFrameWaitInfo.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFrameWaitInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(33);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFrameWaitInfo.nnext(this.address(), value);
            return this;
        }
    }
}

