/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExtensionProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int EXTENSIONNAME;
    public static final int EXTENSIONVERSION;

    public XrExtensionProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrExtensionProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrExtensionProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrExtensionProperties.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer extensionName() {
        return XrExtensionProperties.nextensionName(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
    public String extensionNameString() {
        return XrExtensionProperties.nextensionNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int extensionVersion() {
        return XrExtensionProperties.nextensionVersion(this.address());
    }

    public XrExtensionProperties type(@NativeType(value="XrStructureType") int value) {
        XrExtensionProperties.ntype(this.address(), value);
        return this;
    }

    public XrExtensionProperties type$Default() {
        return this.type(2);
    }

    public XrExtensionProperties next(@NativeType(value="void *") long value) {
        XrExtensionProperties.nnext(this.address(), value);
        return this;
    }

    public XrExtensionProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrExtensionProperties set(XrExtensionProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrExtensionProperties malloc() {
        return XrExtensionProperties.wrap(XrExtensionProperties.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrExtensionProperties calloc() {
        return XrExtensionProperties.wrap(XrExtensionProperties.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrExtensionProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrExtensionProperties.wrap(XrExtensionProperties.class, MemoryUtil.memAddress(container), container);
    }

    public static XrExtensionProperties create(long address) {
        return XrExtensionProperties.wrap(XrExtensionProperties.class, address);
    }

    @Nullable
    public static XrExtensionProperties createSafe(long address) {
        return address == 0L ? null : XrExtensionProperties.wrap(XrExtensionProperties.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrExtensionProperties.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrExtensionProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrExtensionProperties.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtensionProperties.__create(capacity, SIZEOF);
        return XrExtensionProperties.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrExtensionProperties.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrExtensionProperties.wrap(Buffer.class, address, capacity);
    }

    public static XrExtensionProperties malloc(MemoryStack stack) {
        return XrExtensionProperties.wrap(XrExtensionProperties.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrExtensionProperties calloc(MemoryStack stack) {
        return XrExtensionProperties.wrap(XrExtensionProperties.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrExtensionProperties.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrExtensionProperties.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nextensionName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)EXTENSIONNAME, 128);
    }

    public static String nextensionNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)EXTENSIONNAME);
    }

    public static int nextensionVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXTENSIONVERSION);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrExtensionProperties.__struct(XrExtensionProperties.__member(4), XrExtensionProperties.__member(POINTER_SIZE), XrExtensionProperties.__array(1, 128), XrExtensionProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        EXTENSIONNAME = layout.offsetof(2);
        EXTENSIONVERSION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrExtensionProperties, Buffer>
    implements NativeResource {
        private static final XrExtensionProperties ELEMENT_FACTORY = XrExtensionProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrExtensionProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrExtensionProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrExtensionProperties.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer extensionName() {
            return XrExtensionProperties.nextensionName(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTENSION_NAME_SIZE]")
        public String extensionNameString() {
            return XrExtensionProperties.nextensionNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int extensionVersion() {
            return XrExtensionProperties.nextensionVersion(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrExtensionProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(2);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrExtensionProperties.nnext(this.address(), value);
            return this;
        }
    }
}

