/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataBaseHeader;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataReferenceSpaceChangePending
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SESSION;
    public static final int REFERENCESPACETYPE;
    public static final int CHANGETIME;
    public static final int POSEVALID;
    public static final int POSEINPREVIOUSSPACE;

    public XrEventDataReferenceSpaceChangePending(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataReferenceSpaceChangePending.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataReferenceSpaceChangePending.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataReferenceSpaceChangePending.nnext(this.address());
    }

    @NativeType(value="XrSession")
    public long session() {
        return XrEventDataReferenceSpaceChangePending.nsession(this.address());
    }

    @NativeType(value="XrReferenceSpaceType")
    public int referenceSpaceType() {
        return XrEventDataReferenceSpaceChangePending.nreferenceSpaceType(this.address());
    }

    @NativeType(value="XrTime")
    public long changeTime() {
        return XrEventDataReferenceSpaceChangePending.nchangeTime(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean poseValid() {
        return XrEventDataReferenceSpaceChangePending.nposeValid(this.address()) != 0;
    }

    public XrPosef poseInPreviousSpace() {
        return XrEventDataReferenceSpaceChangePending.nposeInPreviousSpace(this.address());
    }

    public XrEventDataReferenceSpaceChangePending type(@NativeType(value="XrStructureType") int value) {
        XrEventDataReferenceSpaceChangePending.ntype(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending type$Default() {
        return this.type(40);
    }

    public XrEventDataReferenceSpaceChangePending next(@NativeType(value="void const *") long value) {
        XrEventDataReferenceSpaceChangePending.nnext(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending session(XrSession value) {
        XrEventDataReferenceSpaceChangePending.nsession(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending referenceSpaceType(@NativeType(value="XrReferenceSpaceType") int value) {
        XrEventDataReferenceSpaceChangePending.nreferenceSpaceType(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending changeTime(@NativeType(value="XrTime") long value) {
        XrEventDataReferenceSpaceChangePending.nchangeTime(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending poseValid(@NativeType(value="XrBool32") boolean value) {
        XrEventDataReferenceSpaceChangePending.nposeValid(this.address(), value ? 1 : 0);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending poseInPreviousSpace(XrPosef value) {
        XrEventDataReferenceSpaceChangePending.nposeInPreviousSpace(this.address(), value);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending poseInPreviousSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInPreviousSpace());
        return this;
    }

    public XrEventDataReferenceSpaceChangePending set(int type, long next, XrSession session, int referenceSpaceType, long changeTime, boolean poseValid, XrPosef poseInPreviousSpace) {
        this.type(type);
        this.next(next);
        this.session(session);
        this.referenceSpaceType(referenceSpaceType);
        this.changeTime(changeTime);
        this.poseValid(poseValid);
        this.poseInPreviousSpace(poseInPreviousSpace);
        return this;
    }

    public XrEventDataReferenceSpaceChangePending set(XrEventDataReferenceSpaceChangePending src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataReferenceSpaceChangePending malloc() {
        return XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrEventDataReferenceSpaceChangePending calloc() {
        return XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrEventDataReferenceSpaceChangePending create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataReferenceSpaceChangePending create(long address) {
        return XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, address);
    }

    @Nullable
    public static XrEventDataReferenceSpaceChangePending createSafe(long address) {
        return address == 0L ? null : XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, address);
    }

    public static XrEventDataReferenceSpaceChangePending create(XrEventDataBaseHeader value) {
        return XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrEventDataReferenceSpaceChangePending.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataReferenceSpaceChangePending.__create(capacity, SIZEOF);
        return XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrEventDataBaseHeader.Buffer value) {
        return XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, value);
    }

    public static XrEventDataReferenceSpaceChangePending malloc(MemoryStack stack) {
        return XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataReferenceSpaceChangePending calloc(MemoryStack stack) {
        return XrEventDataReferenceSpaceChangePending.wrap(XrEventDataReferenceSpaceChangePending.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrEventDataReferenceSpaceChangePending.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nsession(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SESSION);
    }

    public static int nreferenceSpaceType(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCESPACETYPE);
    }

    public static long nchangeTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)CHANGETIME);
    }

    public static int nposeValid(long struct) {
        return UNSAFE.getInt(null, struct + (long)POSEVALID);
    }

    public static XrPosef nposeInPreviousSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINPREVIOUSSPACE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsession(long struct, XrSession value) {
        MemoryUtil.memPutAddress(struct + (long)SESSION, value.address());
    }

    public static void nreferenceSpaceType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCESPACETYPE, value);
    }

    public static void nchangeTime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)CHANGETIME, value);
    }

    public static void nposeValid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)POSEVALID, value);
    }

    public static void nposeInPreviousSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSEINPREVIOUSSPACE, XrPosef.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SESSION));
    }

    static {
        Struct.Layout layout = XrEventDataReferenceSpaceChangePending.__struct(XrEventDataReferenceSpaceChangePending.__member(4), XrEventDataReferenceSpaceChangePending.__member(POINTER_SIZE), XrEventDataReferenceSpaceChangePending.__member(POINTER_SIZE), XrEventDataReferenceSpaceChangePending.__member(4), XrEventDataReferenceSpaceChangePending.__member(8), XrEventDataReferenceSpaceChangePending.__member(4), XrEventDataReferenceSpaceChangePending.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SESSION = layout.offsetof(2);
        REFERENCESPACETYPE = layout.offsetof(3);
        CHANGETIME = layout.offsetof(4);
        POSEVALID = layout.offsetof(5);
        POSEINPREVIOUSSPACE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataReferenceSpaceChangePending, Buffer>
    implements NativeResource {
        private static final XrEventDataReferenceSpaceChangePending ELEMENT_FACTORY = XrEventDataReferenceSpaceChangePending.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrEventDataReferenceSpaceChangePending getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataReferenceSpaceChangePending.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataReferenceSpaceChangePending.nnext(this.address());
        }

        @NativeType(value="XrSession")
        public long session() {
            return XrEventDataReferenceSpaceChangePending.nsession(this.address());
        }

        @NativeType(value="XrReferenceSpaceType")
        public int referenceSpaceType() {
            return XrEventDataReferenceSpaceChangePending.nreferenceSpaceType(this.address());
        }

        @NativeType(value="XrTime")
        public long changeTime() {
            return XrEventDataReferenceSpaceChangePending.nchangeTime(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean poseValid() {
            return XrEventDataReferenceSpaceChangePending.nposeValid(this.address()) != 0;
        }

        public XrPosef poseInPreviousSpace() {
            return XrEventDataReferenceSpaceChangePending.nposeInPreviousSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataReferenceSpaceChangePending.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(40);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataReferenceSpaceChangePending.nnext(this.address(), value);
            return this;
        }

        public Buffer session(XrSession value) {
            XrEventDataReferenceSpaceChangePending.nsession(this.address(), value);
            return this;
        }

        public Buffer referenceSpaceType(@NativeType(value="XrReferenceSpaceType") int value) {
            XrEventDataReferenceSpaceChangePending.nreferenceSpaceType(this.address(), value);
            return this;
        }

        public Buffer changeTime(@NativeType(value="XrTime") long value) {
            XrEventDataReferenceSpaceChangePending.nchangeTime(this.address(), value);
            return this;
        }

        public Buffer poseValid(@NativeType(value="XrBool32") boolean value) {
            XrEventDataReferenceSpaceChangePending.nposeValid(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer poseInPreviousSpace(XrPosef value) {
            XrEventDataReferenceSpaceChangePending.nposeInPreviousSpace(this.address(), value);
            return this;
        }

        public Buffer poseInPreviousSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInPreviousSpace());
            return this;
        }
    }
}

