/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VARYING;

    public XrEventDataBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataBuffer.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataBuffer.nnext(this.address());
    }

    @NativeType(value="uint8_t[4000]")
    public ByteBuffer varying() {
        return XrEventDataBuffer.nvarying(this.address());
    }

    @NativeType(value="uint8_t")
    public byte varying(int index) {
        return XrEventDataBuffer.nvarying(this.address(), index);
    }

    public XrEventDataBuffer type(@NativeType(value="XrStructureType") int value) {
        XrEventDataBuffer.ntype(this.address(), value);
        return this;
    }

    public XrEventDataBuffer type$Default() {
        return this.type(16);
    }

    public XrEventDataBuffer next(@NativeType(value="void const *") long value) {
        XrEventDataBuffer.nnext(this.address(), value);
        return this;
    }

    public XrEventDataBuffer varying(@NativeType(value="uint8_t[4000]") ByteBuffer value) {
        XrEventDataBuffer.nvarying(this.address(), value);
        return this;
    }

    public XrEventDataBuffer varying(int index, @NativeType(value="uint8_t") byte value) {
        XrEventDataBuffer.nvarying(this.address(), index, value);
        return this;
    }

    public XrEventDataBuffer set(int type, long next, ByteBuffer varying) {
        this.type(type);
        this.next(next);
        this.varying(varying);
        return this;
    }

    public XrEventDataBuffer set(XrEventDataBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataBuffer malloc() {
        return XrEventDataBuffer.wrap(XrEventDataBuffer.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrEventDataBuffer calloc() {
        return XrEventDataBuffer.wrap(XrEventDataBuffer.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrEventDataBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrEventDataBuffer.wrap(XrEventDataBuffer.class, MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataBuffer create(long address) {
        return XrEventDataBuffer.wrap(XrEventDataBuffer.class, address);
    }

    @Nullable
    public static XrEventDataBuffer createSafe(long address) {
        return address == 0L ? null : XrEventDataBuffer.wrap(XrEventDataBuffer.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrEventDataBuffer.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrEventDataBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrEventDataBuffer.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataBuffer.__create(capacity, SIZEOF);
        return XrEventDataBuffer.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrEventDataBuffer.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrEventDataBuffer.wrap(Buffer.class, address, capacity);
    }

    public static XrEventDataBuffer malloc(MemoryStack stack) {
        return XrEventDataBuffer.wrap(XrEventDataBuffer.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataBuffer calloc(MemoryStack stack) {
        return XrEventDataBuffer.wrap(XrEventDataBuffer.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrEventDataBuffer.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrEventDataBuffer.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static ByteBuffer nvarying(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)VARYING, 4000);
    }

    public static byte nvarying(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)VARYING + Checks.check(index, 4000) * 1L);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nvarying(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4000);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)VARYING, value.remaining() * 1);
    }

    public static void nvarying(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)VARYING + Checks.check(index, 4000) * 1L, value);
    }

    static {
        Struct.Layout layout = XrEventDataBuffer.__struct(XrEventDataBuffer.__member(4), XrEventDataBuffer.__member(POINTER_SIZE), XrEventDataBuffer.__array(1, 4000));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VARYING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataBuffer, Buffer>
    implements NativeResource {
        private static final XrEventDataBuffer ELEMENT_FACTORY = XrEventDataBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrEventDataBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataBuffer.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataBuffer.nnext(this.address());
        }

        @NativeType(value="uint8_t[4000]")
        public ByteBuffer varying() {
            return XrEventDataBuffer.nvarying(this.address());
        }

        @NativeType(value="uint8_t")
        public byte varying(int index) {
            return XrEventDataBuffer.nvarying(this.address(), index);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataBuffer.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(16);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataBuffer.nnext(this.address(), value);
            return this;
        }

        public Buffer varying(@NativeType(value="uint8_t[4000]") ByteBuffer value) {
            XrEventDataBuffer.nvarying(this.address(), value);
            return this;
        }

        public Buffer varying(int index, @NativeType(value="uint8_t") byte value) {
            XrEventDataBuffer.nvarying(this.address(), index, value);
            return this;
        }
    }
}

