/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrEventDataDisplayRefreshRateChangedFB;
import org.lwjgl.openxr.XrEventDataEventsLost;
import org.lwjgl.openxr.XrEventDataInstanceLossPending;
import org.lwjgl.openxr.XrEventDataInteractionProfileChanged;
import org.lwjgl.openxr.XrEventDataMainSessionVisibilityChangedEXTX;
import org.lwjgl.openxr.XrEventDataMarkerTrackingUpdateVARJO;
import org.lwjgl.openxr.XrEventDataPerfSettingsEXT;
import org.lwjgl.openxr.XrEventDataReferenceSpaceChangePending;
import org.lwjgl.openxr.XrEventDataSessionStateChanged;
import org.lwjgl.openxr.XrEventDataVisibilityMaskChangedKHR;
import org.lwjgl.openxr.XrEventDataViveTrackerConnectedHTCX;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrEventDataBaseHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrEventDataBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrEventDataBaseHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrEventDataBaseHeader.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrEventDataBaseHeader.nnext(this.address());
    }

    public XrEventDataBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrEventDataBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrEventDataBaseHeader next(@NativeType(value="void const *") long value) {
        XrEventDataBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrEventDataBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrEventDataBaseHeader set(XrEventDataBaseHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrEventDataBaseHeader malloc() {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrEventDataBaseHeader calloc() {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrEventDataBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, MemoryUtil.memAddress(container), container);
    }

    public static XrEventDataBaseHeader create(long address) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, address);
    }

    @Nullable
    public static XrEventDataBaseHeader createSafe(long address) {
        return address == 0L ? null : XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, address);
    }

    public static XrEventDataBaseHeader create(XrEventDataEventsLost value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataInstanceLossPending value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataSessionStateChanged value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataReferenceSpaceChangePending value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataInteractionProfileChanged value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataPerfSettingsEXT value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataVisibilityMaskChangedKHR value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataMainSessionVisibilityChangedEXTX value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataDisplayRefreshRateChangedFB value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataViveTrackerConnectedHTCX value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static XrEventDataBaseHeader create(XrEventDataMarkerTrackingUpdateVARJO value) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrEventDataBaseHeader.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrEventDataBaseHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrEventDataBaseHeader.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrEventDataBaseHeader.__create(capacity, SIZEOF);
        return XrEventDataBaseHeader.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrEventDataBaseHeader.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrEventDataBaseHeader.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrEventDataEventsLost.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataInstanceLossPending.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataSessionStateChanged.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataReferenceSpaceChangePending.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataInteractionProfileChanged.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataPerfSettingsEXT.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataVisibilityMaskChangedKHR.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataMainSessionVisibilityChangedEXTX.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataDisplayRefreshRateChangedFB.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataViveTrackerConnectedHTCX.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static Buffer create(XrEventDataMarkerTrackingUpdateVARJO.Buffer value) {
        return XrEventDataBaseHeader.wrap(Buffer.class, value);
    }

    public static XrEventDataBaseHeader malloc(MemoryStack stack) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrEventDataBaseHeader calloc(MemoryStack stack) {
        return XrEventDataBaseHeader.wrap(XrEventDataBaseHeader.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrEventDataBaseHeader.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrEventDataBaseHeader.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrEventDataBaseHeader.__struct(XrEventDataBaseHeader.__member(4), XrEventDataBaseHeader.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrEventDataBaseHeader, Buffer>
    implements NativeResource {
        private static final XrEventDataBaseHeader ELEMENT_FACTORY = XrEventDataBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrEventDataBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrEventDataBaseHeader.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrEventDataBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrEventDataBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrEventDataBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

