/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerSecureContentFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;

    public XrCompositionLayerSecureContentFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerSecureContentFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerSecureContentFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerSecureContentFB.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerSecureContentFlagsFB")
    public long flags() {
        return XrCompositionLayerSecureContentFB.nflags(this.address());
    }

    public XrCompositionLayerSecureContentFB type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerSecureContentFB.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerSecureContentFB type$Default() {
        return this.type(1000072000);
    }

    public XrCompositionLayerSecureContentFB next(@NativeType(value="void const *") long value) {
        XrCompositionLayerSecureContentFB.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerSecureContentFB flags(@NativeType(value="XrCompositionLayerSecureContentFlagsFB") long value) {
        XrCompositionLayerSecureContentFB.nflags(this.address(), value);
        return this;
    }

    public XrCompositionLayerSecureContentFB set(int type, long next, long flags) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        return this;
    }

    public XrCompositionLayerSecureContentFB set(XrCompositionLayerSecureContentFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerSecureContentFB malloc() {
        return XrCompositionLayerSecureContentFB.wrap(XrCompositionLayerSecureContentFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrCompositionLayerSecureContentFB calloc() {
        return XrCompositionLayerSecureContentFB.wrap(XrCompositionLayerSecureContentFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrCompositionLayerSecureContentFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrCompositionLayerSecureContentFB.wrap(XrCompositionLayerSecureContentFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerSecureContentFB create(long address) {
        return XrCompositionLayerSecureContentFB.wrap(XrCompositionLayerSecureContentFB.class, address);
    }

    @Nullable
    public static XrCompositionLayerSecureContentFB createSafe(long address) {
        return address == 0L ? null : XrCompositionLayerSecureContentFB.wrap(XrCompositionLayerSecureContentFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrCompositionLayerSecureContentFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrCompositionLayerSecureContentFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrCompositionLayerSecureContentFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerSecureContentFB.__create(capacity, SIZEOF);
        return XrCompositionLayerSecureContentFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrCompositionLayerSecureContentFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrCompositionLayerSecureContentFB.wrap(Buffer.class, address, capacity);
    }

    public static XrCompositionLayerSecureContentFB malloc(MemoryStack stack) {
        return XrCompositionLayerSecureContentFB.wrap(XrCompositionLayerSecureContentFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerSecureContentFB calloc(MemoryStack stack) {
        return XrCompositionLayerSecureContentFB.wrap(XrCompositionLayerSecureContentFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrCompositionLayerSecureContentFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrCompositionLayerSecureContentFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = XrCompositionLayerSecureContentFB.__struct(XrCompositionLayerSecureContentFB.__member(4), XrCompositionLayerSecureContentFB.__member(POINTER_SIZE), XrCompositionLayerSecureContentFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerSecureContentFB, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerSecureContentFB ELEMENT_FACTORY = XrCompositionLayerSecureContentFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrCompositionLayerSecureContentFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerSecureContentFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerSecureContentFB.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerSecureContentFlagsFB")
        public long flags() {
            return XrCompositionLayerSecureContentFB.nflags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerSecureContentFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000072000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerSecureContentFB.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrCompositionLayerSecureContentFlagsFB") long value) {
            XrCompositionLayerSecureContentFB.nflags(this.address(), value);
            return this;
        }
    }
}

