/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerDepthInfoKHR;
import org.lwjgl.openxr.XrCompositionLayerSpaceWarpInfoFB;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerProjectionView
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int POSE;
    public static final int FOV;
    public static final int SUBIMAGE;

    public XrCompositionLayerProjectionView(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerProjectionView.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerProjectionView.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerProjectionView.nnext(this.address());
    }

    public XrPosef pose() {
        return XrCompositionLayerProjectionView.npose(this.address());
    }

    public XrFovf fov() {
        return XrCompositionLayerProjectionView.nfov(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerProjectionView.nsubImage(this.address());
    }

    public XrCompositionLayerProjectionView type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerProjectionView.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView type$Default() {
        return this.type(48);
    }

    public XrCompositionLayerProjectionView next(@NativeType(value="void const *") long value) {
        XrCompositionLayerProjectionView.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView next(XrCompositionLayerDepthInfoKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerProjectionView next(XrCompositionLayerSpaceWarpInfoFB value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerProjectionView pose(XrPosef value) {
        XrCompositionLayerProjectionView.npose(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrCompositionLayerProjectionView fov(XrFovf value) {
        XrCompositionLayerProjectionView.nfov(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    public XrCompositionLayerProjectionView subImage(XrSwapchainSubImage value) {
        XrCompositionLayerProjectionView.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjectionView subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerProjectionView set(int type, long next, XrPosef pose, XrFovf fov, XrSwapchainSubImage subImage) {
        this.type(type);
        this.next(next);
        this.pose(pose);
        this.fov(fov);
        this.subImage(subImage);
        return this;
    }

    public XrCompositionLayerProjectionView set(XrCompositionLayerProjectionView src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerProjectionView malloc() {
        return XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrCompositionLayerProjectionView calloc() {
        return XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrCompositionLayerProjectionView create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerProjectionView create(long address) {
        return XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, address);
    }

    @Nullable
    public static XrCompositionLayerProjectionView createSafe(long address) {
        return address == 0L ? null : XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrCompositionLayerProjectionView.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrCompositionLayerProjectionView.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrCompositionLayerProjectionView.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerProjectionView.__create(capacity, SIZEOF);
        return XrCompositionLayerProjectionView.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrCompositionLayerProjectionView.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrCompositionLayerProjectionView.wrap(Buffer.class, address, capacity);
    }

    public static XrCompositionLayerProjectionView malloc(MemoryStack stack) {
        return XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerProjectionView calloc(MemoryStack stack) {
        return XrCompositionLayerProjectionView.wrap(XrCompositionLayerProjectionView.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrCompositionLayerProjectionView.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrCompositionLayerProjectionView.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrFovf nfov(long struct) {
        return XrFovf.create(struct + (long)FOV);
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nfov(long struct, XrFovf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, XrFovf.SIZEOF);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBIMAGE, XrSwapchainSubImage.SIZEOF);
    }

    public static void validate(long struct) {
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerProjectionView.__struct(XrCompositionLayerProjectionView.__member(4), XrCompositionLayerProjectionView.__member(POINTER_SIZE), XrCompositionLayerProjectionView.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrCompositionLayerProjectionView.__member(XrFovf.SIZEOF, XrFovf.ALIGNOF), XrCompositionLayerProjectionView.__member(XrSwapchainSubImage.SIZEOF, XrSwapchainSubImage.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        POSE = layout.offsetof(2);
        FOV = layout.offsetof(3);
        SUBIMAGE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerProjectionView, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerProjectionView ELEMENT_FACTORY = XrCompositionLayerProjectionView.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrCompositionLayerProjectionView getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerProjectionView.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerProjectionView.nnext(this.address());
        }

        public XrPosef pose() {
            return XrCompositionLayerProjectionView.npose(this.address());
        }

        public XrFovf fov() {
            return XrCompositionLayerProjectionView.nfov(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerProjectionView.nsubImage(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerProjectionView.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(48);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerProjectionView.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrCompositionLayerDepthInfoKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerSpaceWarpInfoFB value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer pose(XrPosef value) {
            XrCompositionLayerProjectionView.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer fov(XrFovf value) {
            XrCompositionLayerProjectionView.nfov(this.address(), value);
            return this;
        }

        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerProjectionView.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }
    }
}

