/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchainSubImage;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerEquirectKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int EYEVISIBILITY;
    public static final int SUBIMAGE;
    public static final int POSE;
    public static final int RADIUS;
    public static final int SCALE;
    public static final int BIAS;

    public XrCompositionLayerEquirectKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrCompositionLayerEquirectKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerEquirectKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerEquirectKHR.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerEquirectKHR.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerEquirectKHR.nspace(this.address());
    }

    @NativeType(value="XrEyeVisibility")
    public int eyeVisibility() {
        return XrCompositionLayerEquirectKHR.neyeVisibility(this.address());
    }

    public XrSwapchainSubImage subImage() {
        return XrCompositionLayerEquirectKHR.nsubImage(this.address());
    }

    public XrPosef pose() {
        return XrCompositionLayerEquirectKHR.npose(this.address());
    }

    public float radius() {
        return XrCompositionLayerEquirectKHR.nradius(this.address());
    }

    public XrVector2f scale() {
        return XrCompositionLayerEquirectKHR.nscale(this.address());
    }

    public XrVector2f bias() {
        return XrCompositionLayerEquirectKHR.nbias(this.address());
    }

    public XrCompositionLayerEquirectKHR type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerEquirectKHR.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR type$Default() {
        return this.type(1000018000);
    }

    public XrCompositionLayerEquirectKHR next(@NativeType(value="void const *") long value) {
        XrCompositionLayerEquirectKHR.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerEquirectKHR.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR space(XrSpace value) {
        XrCompositionLayerEquirectKHR.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
        XrCompositionLayerEquirectKHR.neyeVisibility(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR subImage(XrSwapchainSubImage value) {
        XrCompositionLayerEquirectKHR.nsubImage(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR subImage(Consumer<XrSwapchainSubImage> consumer) {
        consumer.accept(this.subImage());
        return this;
    }

    public XrCompositionLayerEquirectKHR pose(XrPosef value) {
        XrCompositionLayerEquirectKHR.npose(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrCompositionLayerEquirectKHR radius(float value) {
        XrCompositionLayerEquirectKHR.nradius(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR scale(XrVector2f value) {
        XrCompositionLayerEquirectKHR.nscale(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR scale(Consumer<XrVector2f> consumer) {
        consumer.accept(this.scale());
        return this;
    }

    public XrCompositionLayerEquirectKHR bias(XrVector2f value) {
        XrCompositionLayerEquirectKHR.nbias(this.address(), value);
        return this;
    }

    public XrCompositionLayerEquirectKHR bias(Consumer<XrVector2f> consumer) {
        consumer.accept(this.bias());
        return this;
    }

    public XrCompositionLayerEquirectKHR set(int type, long next, long layerFlags, XrSpace space, int eyeVisibility, XrSwapchainSubImage subImage, XrPosef pose, float radius, XrVector2f scale, XrVector2f bias) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.eyeVisibility(eyeVisibility);
        this.subImage(subImage);
        this.pose(pose);
        this.radius(radius);
        this.scale(scale);
        this.bias(bias);
        return this;
    }

    public XrCompositionLayerEquirectKHR set(XrCompositionLayerEquirectKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrCompositionLayerEquirectKHR malloc() {
        return XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrCompositionLayerEquirectKHR calloc() {
        return XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrCompositionLayerEquirectKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrCompositionLayerEquirectKHR create(long address) {
        return XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, address);
    }

    @Nullable
    public static XrCompositionLayerEquirectKHR createSafe(long address) {
        return address == 0L ? null : XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, address);
    }

    public static XrCompositionLayerEquirectKHR create(XrCompositionLayerBaseHeader value) {
        return XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrCompositionLayerEquirectKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrCompositionLayerEquirectKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrCompositionLayerEquirectKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerEquirectKHR.__create(capacity, SIZEOF);
        return XrCompositionLayerEquirectKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrCompositionLayerEquirectKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrCompositionLayerEquirectKHR.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return XrCompositionLayerEquirectKHR.wrap(Buffer.class, value);
    }

    public static XrCompositionLayerEquirectKHR malloc(MemoryStack stack) {
        return XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerEquirectKHR calloc(MemoryStack stack) {
        return XrCompositionLayerEquirectKHR.wrap(XrCompositionLayerEquirectKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrCompositionLayerEquirectKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrCompositionLayerEquirectKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nlayerFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SPACE);
    }

    public static int neyeVisibility(long struct) {
        return UNSAFE.getInt(null, struct + (long)EYEVISIBILITY);
    }

    public static XrSwapchainSubImage nsubImage(long struct) {
        return XrSwapchainSubImage.create(struct + (long)SUBIMAGE);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static XrVector2f nscale(long struct) {
        return XrVector2f.create(struct + (long)SCALE);
    }

    public static XrVector2f nbias(long struct) {
        return XrVector2f.create(struct + (long)BIAS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlayerFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress(struct + (long)SPACE, value.address());
    }

    public static void neyeVisibility(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EYEVISIBILITY, value);
    }

    public static void nsubImage(long struct, XrSwapchainSubImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBIMAGE, XrSwapchainSubImage.SIZEOF);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RADIUS, value);
    }

    public static void nscale(long struct, XrVector2f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCALE, XrVector2f.SIZEOF);
    }

    public static void nbias(long struct, XrVector2f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BIAS, XrVector2f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPACE));
        XrSwapchainSubImage.validate(struct + (long)SUBIMAGE);
    }

    static {
        Struct.Layout layout = XrCompositionLayerEquirectKHR.__struct(XrCompositionLayerEquirectKHR.__member(4), XrCompositionLayerEquirectKHR.__member(POINTER_SIZE), XrCompositionLayerEquirectKHR.__member(8), XrCompositionLayerEquirectKHR.__member(POINTER_SIZE), XrCompositionLayerEquirectKHR.__member(4), XrCompositionLayerEquirectKHR.__member(XrSwapchainSubImage.SIZEOF, XrSwapchainSubImage.ALIGNOF), XrCompositionLayerEquirectKHR.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrCompositionLayerEquirectKHR.__member(4), XrCompositionLayerEquirectKHR.__member(XrVector2f.SIZEOF, XrVector2f.ALIGNOF), XrCompositionLayerEquirectKHR.__member(XrVector2f.SIZEOF, XrVector2f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        EYEVISIBILITY = layout.offsetof(4);
        SUBIMAGE = layout.offsetof(5);
        POSE = layout.offsetof(6);
        RADIUS = layout.offsetof(7);
        SCALE = layout.offsetof(8);
        BIAS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerEquirectKHR, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerEquirectKHR ELEMENT_FACTORY = XrCompositionLayerEquirectKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrCompositionLayerEquirectKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerEquirectKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerEquirectKHR.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerEquirectKHR.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerEquirectKHR.nspace(this.address());
        }

        @NativeType(value="XrEyeVisibility")
        public int eyeVisibility() {
            return XrCompositionLayerEquirectKHR.neyeVisibility(this.address());
        }

        public XrSwapchainSubImage subImage() {
            return XrCompositionLayerEquirectKHR.nsubImage(this.address());
        }

        public XrPosef pose() {
            return XrCompositionLayerEquirectKHR.npose(this.address());
        }

        public float radius() {
            return XrCompositionLayerEquirectKHR.nradius(this.address());
        }

        public XrVector2f scale() {
            return XrCompositionLayerEquirectKHR.nscale(this.address());
        }

        public XrVector2f bias() {
            return XrCompositionLayerEquirectKHR.nbias(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerEquirectKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000018000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerEquirectKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerEquirectKHR.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerEquirectKHR.nspace(this.address(), value);
            return this;
        }

        public Buffer eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
            XrCompositionLayerEquirectKHR.neyeVisibility(this.address(), value);
            return this;
        }

        public Buffer subImage(XrSwapchainSubImage value) {
            XrCompositionLayerEquirectKHR.nsubImage(this.address(), value);
            return this;
        }

        public Buffer subImage(Consumer<XrSwapchainSubImage> consumer) {
            consumer.accept(this.subImage());
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrCompositionLayerEquirectKHR.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer radius(float value) {
            XrCompositionLayerEquirectKHR.nradius(this.address(), value);
            return this;
        }

        public Buffer scale(XrVector2f value) {
            XrCompositionLayerEquirectKHR.nscale(this.address(), value);
            return this;
        }

        public Buffer scale(Consumer<XrVector2f> consumer) {
            consumer.accept(this.scale());
            return this;
        }

        public Buffer bias(XrVector2f value) {
            XrCompositionLayerEquirectKHR.nbias(this.address(), value);
            return this;
        }

        public Buffer bias(Consumer<XrVector2f> consumer) {
            consumer.accept(this.bias());
            return this;
        }
    }
}

