/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBoundSourcesForActionEnumerateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;

    public XrBoundSourcesForActionEnumerateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBoundSourcesForActionEnumerateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBoundSourcesForActionEnumerateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBoundSourcesForActionEnumerateInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrBoundSourcesForActionEnumerateInfo.naction(this.address());
    }

    public XrBoundSourcesForActionEnumerateInfo type(@NativeType(value="XrStructureType") int value) {
        XrBoundSourcesForActionEnumerateInfo.ntype(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo type$Default() {
        return this.type(62);
    }

    public XrBoundSourcesForActionEnumerateInfo next(@NativeType(value="void const *") long value) {
        XrBoundSourcesForActionEnumerateInfo.nnext(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo action(XrAction value) {
        XrBoundSourcesForActionEnumerateInfo.naction(this.address(), value);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo set(int type, long next, XrAction action) {
        this.type(type);
        this.next(next);
        this.action(action);
        return this;
    }

    public XrBoundSourcesForActionEnumerateInfo set(XrBoundSourcesForActionEnumerateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBoundSourcesForActionEnumerateInfo malloc() {
        return XrBoundSourcesForActionEnumerateInfo.wrap(XrBoundSourcesForActionEnumerateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrBoundSourcesForActionEnumerateInfo calloc() {
        return XrBoundSourcesForActionEnumerateInfo.wrap(XrBoundSourcesForActionEnumerateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrBoundSourcesForActionEnumerateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrBoundSourcesForActionEnumerateInfo.wrap(XrBoundSourcesForActionEnumerateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrBoundSourcesForActionEnumerateInfo create(long address) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(XrBoundSourcesForActionEnumerateInfo.class, address);
    }

    @Nullable
    public static XrBoundSourcesForActionEnumerateInfo createSafe(long address) {
        return address == 0L ? null : XrBoundSourcesForActionEnumerateInfo.wrap(XrBoundSourcesForActionEnumerateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrBoundSourcesForActionEnumerateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBoundSourcesForActionEnumerateInfo.__create(capacity, SIZEOF);
        return XrBoundSourcesForActionEnumerateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrBoundSourcesForActionEnumerateInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrBoundSourcesForActionEnumerateInfo malloc(MemoryStack stack) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(XrBoundSourcesForActionEnumerateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBoundSourcesForActionEnumerateInfo calloc(MemoryStack stack) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(XrBoundSourcesForActionEnumerateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrBoundSourcesForActionEnumerateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTION);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress(struct + (long)ACTION, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTION));
    }

    static {
        Struct.Layout layout = XrBoundSourcesForActionEnumerateInfo.__struct(XrBoundSourcesForActionEnumerateInfo.__member(4), XrBoundSourcesForActionEnumerateInfo.__member(POINTER_SIZE), XrBoundSourcesForActionEnumerateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrBoundSourcesForActionEnumerateInfo, Buffer>
    implements NativeResource {
        private static final XrBoundSourcesForActionEnumerateInfo ELEMENT_FACTORY = XrBoundSourcesForActionEnumerateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrBoundSourcesForActionEnumerateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBoundSourcesForActionEnumerateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBoundSourcesForActionEnumerateInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrBoundSourcesForActionEnumerateInfo.naction(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBoundSourcesForActionEnumerateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(62);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBoundSourcesForActionEnumerateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrBoundSourcesForActionEnumerateInfo.naction(this.address(), value);
            return this;
        }
    }
}

