/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrInteractionProfileAnalogThresholdVALVE;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBindingModificationBaseHeaderKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrBindingModificationBaseHeaderKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBindingModificationBaseHeaderKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBindingModificationBaseHeaderKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrBindingModificationBaseHeaderKHR.nnext(this.address());
    }

    public XrBindingModificationBaseHeaderKHR type(@NativeType(value="XrStructureType") int value) {
        XrBindingModificationBaseHeaderKHR.ntype(this.address(), value);
        return this;
    }

    public XrBindingModificationBaseHeaderKHR next(@NativeType(value="void const *") long value) {
        XrBindingModificationBaseHeaderKHR.nnext(this.address(), value);
        return this;
    }

    public XrBindingModificationBaseHeaderKHR set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBindingModificationBaseHeaderKHR set(XrBindingModificationBaseHeaderKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBindingModificationBaseHeaderKHR malloc() {
        return XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrBindingModificationBaseHeaderKHR calloc() {
        return XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrBindingModificationBaseHeaderKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrBindingModificationBaseHeaderKHR create(long address) {
        return XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, address);
    }

    @Nullable
    public static XrBindingModificationBaseHeaderKHR createSafe(long address) {
        return address == 0L ? null : XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, address);
    }

    public static XrBindingModificationBaseHeaderKHR create(XrInteractionProfileAnalogThresholdVALVE value) {
        return XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrBindingModificationBaseHeaderKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBindingModificationBaseHeaderKHR.__create(capacity, SIZEOF);
        return XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrInteractionProfileAnalogThresholdVALVE.Buffer value) {
        return XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, value);
    }

    public static XrBindingModificationBaseHeaderKHR malloc(MemoryStack stack) {
        return XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBindingModificationBaseHeaderKHR calloc(MemoryStack stack) {
        return XrBindingModificationBaseHeaderKHR.wrap(XrBindingModificationBaseHeaderKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrBindingModificationBaseHeaderKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrBindingModificationBaseHeaderKHR.__struct(XrBindingModificationBaseHeaderKHR.__member(4), XrBindingModificationBaseHeaderKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBindingModificationBaseHeaderKHR, Buffer>
    implements NativeResource {
        private static final XrBindingModificationBaseHeaderKHR ELEMENT_FACTORY = XrBindingModificationBaseHeaderKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrBindingModificationBaseHeaderKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBindingModificationBaseHeaderKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrBindingModificationBaseHeaderKHR.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBindingModificationBaseHeaderKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrBindingModificationBaseHeaderKHR.nnext(this.address(), value);
            return this;
        }
    }
}

