/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBaseInStructure
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrBaseInStructure(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrBaseInStructure.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBaseInStructure.ntype(this.address());
    }

    @NativeType(value="XrBaseInStructure const *")
    public XrBaseInStructure next() {
        return XrBaseInStructure.nnext(this.address());
    }

    public XrBaseInStructure type(@NativeType(value="XrStructureType") int value) {
        XrBaseInStructure.ntype(this.address(), value);
        return this;
    }

    public XrBaseInStructure next(@NativeType(value="XrBaseInStructure const *") XrBaseInStructure value) {
        XrBaseInStructure.nnext(this.address(), value);
        return this;
    }

    public XrBaseInStructure set(int type, XrBaseInStructure next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrBaseInStructure set(XrBaseInStructure src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrBaseInStructure malloc() {
        return XrBaseInStructure.wrap(XrBaseInStructure.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrBaseInStructure calloc() {
        return XrBaseInStructure.wrap(XrBaseInStructure.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrBaseInStructure create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrBaseInStructure.wrap(XrBaseInStructure.class, MemoryUtil.memAddress(container), container);
    }

    public static XrBaseInStructure create(long address) {
        return XrBaseInStructure.wrap(XrBaseInStructure.class, address);
    }

    @Nullable
    public static XrBaseInStructure createSafe(long address) {
        return address == 0L ? null : XrBaseInStructure.wrap(XrBaseInStructure.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrBaseInStructure.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrBaseInStructure.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrBaseInStructure.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBaseInStructure.__create(capacity, SIZEOF);
        return XrBaseInStructure.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrBaseInStructure.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrBaseInStructure.wrap(Buffer.class, address, capacity);
    }

    public static XrBaseInStructure malloc(MemoryStack stack) {
        return XrBaseInStructure.wrap(XrBaseInStructure.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrBaseInStructure calloc(MemoryStack stack) {
        return XrBaseInStructure.wrap(XrBaseInStructure.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrBaseInStructure.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrBaseInStructure.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static XrBaseInStructure nnext(long struct) {
        return XrBaseInStructure.create(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, XrBaseInStructure value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    static {
        Struct.Layout layout = XrBaseInStructure.__struct(XrBaseInStructure.__member(4), XrBaseInStructure.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBaseInStructure, Buffer>
    implements NativeResource {
        private static final XrBaseInStructure ELEMENT_FACTORY = XrBaseInStructure.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrBaseInStructure getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBaseInStructure.ntype(this.address());
        }

        @NativeType(value="XrBaseInStructure const *")
        public XrBaseInStructure next() {
            return XrBaseInStructure.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBaseInStructure.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="XrBaseInStructure const *") XrBaseInStructure value) {
            XrBaseInStructure.nnext(this.address(), value);
            return this;
        }
    }
}

