/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActiveActionSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIONSET;
    public static final int SUBACTIONPATH;

    public XrActiveActionSet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrActiveActionSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrActionSet")
    public long actionSet() {
        return XrActiveActionSet.nactionSet(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrActiveActionSet.nsubactionPath(this.address());
    }

    public XrActiveActionSet actionSet(XrActionSet value) {
        XrActiveActionSet.nactionSet(this.address(), value);
        return this;
    }

    public XrActiveActionSet subactionPath(@NativeType(value="XrPath") long value) {
        XrActiveActionSet.nsubactionPath(this.address(), value);
        return this;
    }

    public XrActiveActionSet set(XrActionSet actionSet, long subactionPath) {
        this.actionSet(actionSet);
        this.subactionPath(subactionPath);
        return this;
    }

    public XrActiveActionSet set(XrActiveActionSet src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrActiveActionSet malloc() {
        return XrActiveActionSet.wrap(XrActiveActionSet.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrActiveActionSet calloc() {
        return XrActiveActionSet.wrap(XrActiveActionSet.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrActiveActionSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrActiveActionSet.wrap(XrActiveActionSet.class, MemoryUtil.memAddress(container), container);
    }

    public static XrActiveActionSet create(long address) {
        return XrActiveActionSet.wrap(XrActiveActionSet.class, address);
    }

    @Nullable
    public static XrActiveActionSet createSafe(long address) {
        return address == 0L ? null : XrActiveActionSet.wrap(XrActiveActionSet.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrActiveActionSet.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrActiveActionSet.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrActiveActionSet.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActiveActionSet.__create(capacity, SIZEOF);
        return XrActiveActionSet.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrActiveActionSet.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrActiveActionSet.wrap(Buffer.class, address, capacity);
    }

    public static XrActiveActionSet malloc(MemoryStack stack) {
        return XrActiveActionSet.wrap(XrActiveActionSet.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrActiveActionSet calloc(MemoryStack stack) {
        return XrActiveActionSet.wrap(XrActiveActionSet.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrActiveActionSet.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrActiveActionSet.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nactionSet(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTIONSET);
    }

    public static long nsubactionPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBACTIONPATH);
    }

    public static void nactionSet(long struct, XrActionSet value) {
        MemoryUtil.memPutAddress(struct + (long)ACTIONSET, value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBACTIONPATH, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTIONSET));
    }

    static {
        Struct.Layout layout = XrActiveActionSet.__struct(XrActiveActionSet.__member(POINTER_SIZE), XrActiveActionSet.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIONSET = layout.offsetof(0);
        SUBACTIONPATH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrActiveActionSet, Buffer>
    implements NativeResource {
        private static final XrActiveActionSet ELEMENT_FACTORY = XrActiveActionSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrActiveActionSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrActionSet")
        public long actionSet() {
            return XrActiveActionSet.nactionSet(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrActiveActionSet.nsubactionPath(this.address());
        }

        public Buffer actionSet(XrActionSet value) {
            XrActiveActionSet.nactionSet(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrActiveActionSet.nsubactionPath(this.address(), value);
            return this;
        }
    }
}

