/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.util.Set;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;

public class XRCapabilities {
    public final long xrDestroyInstance;
    public final long xrGetInstanceProperties;
    public final long xrPollEvent;
    public final long xrResultToString;
    public final long xrStructureTypeToString;
    public final long xrGetSystem;
    public final long xrGetSystemProperties;
    public final long xrEnumerateEnvironmentBlendModes;
    public final long xrCreateSession;
    public final long xrDestroySession;
    public final long xrEnumerateReferenceSpaces;
    public final long xrCreateReferenceSpace;
    public final long xrGetReferenceSpaceBoundsRect;
    public final long xrCreateActionSpace;
    public final long xrLocateSpace;
    public final long xrDestroySpace;
    public final long xrEnumerateViewConfigurations;
    public final long xrGetViewConfigurationProperties;
    public final long xrEnumerateViewConfigurationViews;
    public final long xrEnumerateSwapchainFormats;
    public final long xrCreateSwapchain;
    public final long xrDestroySwapchain;
    public final long xrEnumerateSwapchainImages;
    public final long xrAcquireSwapchainImage;
    public final long xrWaitSwapchainImage;
    public final long xrReleaseSwapchainImage;
    public final long xrBeginSession;
    public final long xrEndSession;
    public final long xrRequestExitSession;
    public final long xrWaitFrame;
    public final long xrBeginFrame;
    public final long xrEndFrame;
    public final long xrLocateViews;
    public final long xrStringToPath;
    public final long xrPathToString;
    public final long xrCreateActionSet;
    public final long xrDestroyActionSet;
    public final long xrCreateAction;
    public final long xrDestroyAction;
    public final long xrSuggestInteractionProfileBindings;
    public final long xrAttachSessionActionSets;
    public final long xrGetCurrentInteractionProfile;
    public final long xrGetActionStateBoolean;
    public final long xrGetActionStateFloat;
    public final long xrGetActionStateVector2f;
    public final long xrGetActionStatePose;
    public final long xrSyncActions;
    public final long xrEnumerateBoundSourcesForAction;
    public final long xrGetInputSourceLocalizedName;
    public final long xrApplyHapticFeedback;
    public final long xrStopHapticFeedback;
    public final long xrSetDigitalLensControlALMALENCE;
    public final long xrSetInputDeviceActiveEXT;
    public final long xrSetInputDeviceStateBoolEXT;
    public final long xrSetInputDeviceStateFloatEXT;
    public final long xrSetInputDeviceStateVector2fEXT;
    public final long xrSetInputDeviceLocationEXT;
    public final long xrSetDebugUtilsObjectNameEXT;
    public final long xrCreateDebugUtilsMessengerEXT;
    public final long xrDestroyDebugUtilsMessengerEXT;
    public final long xrSubmitDebugUtilsMessageEXT;
    public final long xrSessionBeginDebugUtilsLabelRegionEXT;
    public final long xrSessionEndDebugUtilsLabelRegionEXT;
    public final long xrSessionInsertDebugUtilsLabelEXT;
    public final long xrCreateHandTrackerEXT;
    public final long xrDestroyHandTrackerEXT;
    public final long xrLocateHandJointsEXT;
    public final long xrPerfSettingsSetPerformanceLevelEXT;
    public final long xrThermalGetTemperatureTrendEXT;
    public final long xrEnumerateColorSpacesFB;
    public final long xrSetColorSpaceFB;
    public final long xrEnumerateDisplayRefreshRatesFB;
    public final long xrGetDisplayRefreshRateFB;
    public final long xrRequestDisplayRefreshRateFB;
    public final long xrCreateFoveationProfileFB;
    public final long xrDestroyFoveationProfileFB;
    public final long xrGetHandMeshFB;
    public final long xrQuerySystemTrackedKeyboardFB;
    public final long xrCreateKeyboardSpaceFB;
    public final long xrCreatePassthroughFB;
    public final long xrDestroyPassthroughFB;
    public final long xrPassthroughStartFB;
    public final long xrPassthroughPauseFB;
    public final long xrCreatePassthroughLayerFB;
    public final long xrDestroyPassthroughLayerFB;
    public final long xrPassthroughLayerPauseFB;
    public final long xrPassthroughLayerResumeFB;
    public final long xrPassthroughLayerSetStyleFB;
    public final long xrCreateGeometryInstanceFB;
    public final long xrDestroyGeometryInstanceFB;
    public final long xrGeometryInstanceSetTransformFB;
    public final long xrPassthroughLayerSetKeyboardHandsIntensityFB;
    public final long xrEnumerateRenderModelPathsFB;
    public final long xrGetRenderModelPropertiesFB;
    public final long xrLoadRenderModelFB;
    public final long xrUpdateSwapchainFB;
    public final long xrGetSwapchainStateFB;
    public final long xrCreateTriangleMeshFB;
    public final long xrDestroyTriangleMeshFB;
    public final long xrTriangleMeshGetVertexBufferFB;
    public final long xrTriangleMeshGetIndexBufferFB;
    public final long xrTriangleMeshBeginUpdateFB;
    public final long xrTriangleMeshEndUpdateFB;
    public final long xrTriangleMeshBeginVertexBufferUpdateFB;
    public final long xrTriangleMeshEndVertexBufferUpdateFB;
    public final long xrCreateFacialTrackerHTC;
    public final long xrDestroyFacialTrackerHTC;
    public final long xrGetFacialExpressionsHTC;
    public final long xrEnumerateViveTrackerPathsHTCX;
    public final long xrConvertTimespecTimeToTimeKHR;
    public final long xrConvertTimeToTimespecTimeKHR;
    public final long xrGetOpenGLGraphicsRequirementsKHR;
    public final long xrGetOpenGLESGraphicsRequirementsKHR;
    public final long xrGetVisibilityMaskKHR;
    public final long xrGetVulkanInstanceExtensionsKHR;
    public final long xrGetVulkanDeviceExtensionsKHR;
    public final long xrGetVulkanGraphicsDeviceKHR;
    public final long xrGetVulkanGraphicsRequirementsKHR;
    public final long xrCreateVulkanInstanceKHR;
    public final long xrCreateVulkanDeviceKHR;
    public final long xrGetVulkanGraphicsDevice2KHR;
    public final long xrGetVulkanGraphicsRequirements2KHR;
    public final long xrConvertWin32PerformanceCounterToTimeKHR;
    public final long xrConvertTimeToWin32PerformanceCounterKHR;
    public final long xrEnumerateReprojectionModesMSFT;
    public final long xrGetControllerModelKeyMSFT;
    public final long xrLoadControllerModelMSFT;
    public final long xrGetControllerModelPropertiesMSFT;
    public final long xrGetControllerModelStateMSFT;
    public final long xrCreateHandMeshSpaceMSFT;
    public final long xrUpdateHandMeshMSFT;
    public final long xrCreateSpatialAnchorFromPerceptionAnchorMSFT;
    public final long xrTryGetPerceptionAnchorFromSpatialAnchorMSFT;
    public final long xrEnumerateSceneComputeFeaturesMSFT;
    public final long xrCreateSceneObserverMSFT;
    public final long xrDestroySceneObserverMSFT;
    public final long xrCreateSceneMSFT;
    public final long xrDestroySceneMSFT;
    public final long xrComputeNewSceneMSFT;
    public final long xrGetSceneComputeStateMSFT;
    public final long xrGetSceneComponentsMSFT;
    public final long xrLocateSceneComponentsMSFT;
    public final long xrGetSceneMeshBuffersMSFT;
    public final long xrDeserializeSceneMSFT;
    public final long xrGetSerializedSceneFragmentDataMSFT;
    public final long xrCreateSpatialAnchorMSFT;
    public final long xrCreateSpatialAnchorSpaceMSFT;
    public final long xrDestroySpatialAnchorMSFT;
    public final long xrCreateSpatialAnchorStoreConnectionMSFT;
    public final long xrDestroySpatialAnchorStoreConnectionMSFT;
    public final long xrPersistSpatialAnchorMSFT;
    public final long xrEnumeratePersistedSpatialAnchorNamesMSFT;
    public final long xrCreateSpatialAnchorFromPersistedNameMSFT;
    public final long xrUnpersistSpatialAnchorMSFT;
    public final long xrClearSpatialAnchorStoreMSFT;
    public final long xrCreateSpatialGraphNodeSpaceMSFT;
    public final long xrGetAudioOutputDeviceGuidOculus;
    public final long xrGetAudioInputDeviceGuidOculus;
    public final long xrSetEnvironmentDepthEstimationVARJO;
    public final long xrSetMarkerTrackingVARJO;
    public final long xrSetMarkerTrackingTimeoutVARJO;
    public final long xrSetMarkerTrackingPredictionVARJO;
    public final long xrGetMarkerSizeVARJO;
    public final long xrCreateMarkerSpaceVARJO;
    public final long apiVersion;
    public final boolean OpenXR10;
    public final boolean XR_ALMALENCE_digital_lens_control;
    public final boolean XR_EPIC_view_configuration_fov;
    public final boolean XR_EXT_conformance_automation;
    public final boolean XR_EXT_debug_utils;
    public final boolean XR_EXT_eye_gaze_interaction;
    public final boolean XR_EXT_hand_joints_motion_range;
    public final boolean XR_EXT_hand_tracking;
    public final boolean XR_EXT_hp_mixed_reality_controller;
    public final boolean XR_EXT_performance_settings;
    public final boolean XR_EXT_samsung_odyssey_controller;
    public final boolean XR_EXT_thermal_query;
    public final boolean XR_EXT_uuid;
    public final boolean XR_EXT_view_configuration_depth_range;
    public final boolean XR_EXT_win32_appcontainer_compatible;
    public final boolean XR_EXTX_overlay;
    public final boolean XR_FB_color_space;
    public final boolean XR_FB_composition_layer_alpha_blend;
    public final boolean XR_FB_composition_layer_image_layout;
    public final boolean XR_FB_composition_layer_secure_content;
    public final boolean XR_FB_display_refresh_rate;
    public final boolean XR_FB_foveation;
    public final boolean XR_FB_foveation_configuration;
    public final boolean XR_FB_foveation_vulkan;
    public final boolean XR_FB_hand_tracking_aim;
    public final boolean XR_FB_hand_tracking_capsules;
    public final boolean XR_FB_hand_tracking_mesh;
    public final boolean XR_FB_keyboard_tracking;
    public final boolean XR_FB_passthrough;
    public final boolean XR_FB_passthrough_keyboard_hands;
    public final boolean XR_FB_render_model;
    public final boolean XR_FB_space_warp;
    public final boolean XR_FB_swapchain_update_state;
    public final boolean XR_FB_swapchain_update_state_opengl_es;
    public final boolean XR_FB_swapchain_update_state_vulkan;
    public final boolean XR_FB_triangle_mesh;
    public final boolean XR_HTC_facial_tracking;
    public final boolean XR_HTC_vive_cosmos_controller_interaction;
    public final boolean XR_HTC_vive_focus3_controller_interaction;
    public final boolean XR_HTCX_vive_tracker_interaction;
    public final boolean XR_HUAWEI_controller_interaction;
    public final boolean XR_KHR_binding_modification;
    public final boolean XR_KHR_composition_layer_color_scale_bias;
    public final boolean XR_KHR_composition_layer_cube;
    public final boolean XR_KHR_composition_layer_cylinder;
    public final boolean XR_KHR_composition_layer_depth;
    public final boolean XR_KHR_composition_layer_equirect;
    public final boolean XR_KHR_composition_layer_equirect2;
    public final boolean XR_KHR_convert_timespec_time;
    public final boolean XR_KHR_loader_init;
    public final boolean XR_KHR_opengl_enable;
    public final boolean XR_KHR_opengl_es_enable;
    public final boolean XR_KHR_swapchain_usage_input_attachment_bit;
    public final boolean XR_KHR_visibility_mask;
    public final boolean XR_KHR_vulkan_enable;
    public final boolean XR_KHR_vulkan_enable2;
    public final boolean XR_KHR_vulkan_swapchain_format_list;
    public final boolean XR_KHR_win32_convert_performance_counter_time;
    public final boolean XR_MND_headless;
    public final boolean XR_MND_swapchain_usage_input_attachment_bit;
    public final boolean XR_MNDX_egl_enable;
    public final boolean XR_MSFT_composition_layer_reprojection;
    public final boolean XR_MSFT_controller_model;
    public final boolean XR_MSFT_first_person_observer;
    public final boolean XR_MSFT_hand_interaction;
    public final boolean XR_MSFT_hand_tracking_mesh;
    public final boolean XR_MSFT_holographic_window_attachment;
    public final boolean XR_MSFT_perception_anchor_interop;
    public final boolean XR_MSFT_scene_understanding;
    public final boolean XR_MSFT_scene_understanding_serialization;
    public final boolean XR_MSFT_secondary_view_configuration;
    public final boolean XR_MSFT_spatial_anchor;
    public final boolean XR_MSFT_spatial_anchor_persistence;
    public final boolean XR_MSFT_spatial_graph_bridge;
    public final boolean XR_MSFT_unbounded_reference_space;
    public final boolean XR_OCULUS_audio_device_guid;
    public final boolean XR_VALVE_analog_threshold;
    public final boolean XR_VARJO_composition_layer_depth_test;
    public final boolean XR_VARJO_environment_depth_estimation;
    public final boolean XR_VARJO_foveated_rendering;
    public final boolean XR_VARJO_marker_tracking;
    public final boolean XR_VARJO_quad_views;

    XRCapabilities(FunctionProvider provider, long apiVersion, Set<String> ext) {
        this.apiVersion = apiVersion;
        long[] caps = new long[164];
        this.OpenXR10 = XRCapabilities.check_XR10(provider, caps, ext);
        this.XR_ALMALENCE_digital_lens_control = XRCapabilities.check_ALMALENCE_digital_lens_control(provider, caps, ext);
        this.XR_EPIC_view_configuration_fov = ext.contains("XR_EPIC_view_configuration_fov");
        this.XR_EXT_conformance_automation = XRCapabilities.check_EXT_conformance_automation(provider, caps, ext);
        this.XR_EXT_debug_utils = XRCapabilities.check_EXT_debug_utils(provider, caps, ext);
        this.XR_EXT_eye_gaze_interaction = ext.contains("XR_EXT_eye_gaze_interaction");
        this.XR_EXT_hand_joints_motion_range = ext.contains("XR_EXT_hand_joints_motion_range");
        this.XR_EXT_hand_tracking = XRCapabilities.check_EXT_hand_tracking(provider, caps, ext);
        this.XR_EXT_hp_mixed_reality_controller = ext.contains("XR_EXT_hp_mixed_reality_controller");
        this.XR_EXT_performance_settings = XRCapabilities.check_EXT_performance_settings(provider, caps, ext);
        this.XR_EXT_samsung_odyssey_controller = ext.contains("XR_EXT_samsung_odyssey_controller");
        this.XR_EXT_thermal_query = XRCapabilities.check_EXT_thermal_query(provider, caps, ext);
        this.XR_EXT_uuid = ext.contains("XR_EXT_uuid");
        this.XR_EXT_view_configuration_depth_range = ext.contains("XR_EXT_view_configuration_depth_range");
        this.XR_EXT_win32_appcontainer_compatible = ext.contains("XR_EXT_win32_appcontainer_compatible");
        this.XR_EXTX_overlay = ext.contains("XR_EXTX_overlay");
        this.XR_FB_color_space = XRCapabilities.check_FB_color_space(provider, caps, ext);
        this.XR_FB_composition_layer_alpha_blend = ext.contains("XR_FB_composition_layer_alpha_blend");
        this.XR_FB_composition_layer_image_layout = ext.contains("XR_FB_composition_layer_image_layout");
        this.XR_FB_composition_layer_secure_content = ext.contains("XR_FB_composition_layer_secure_content");
        this.XR_FB_display_refresh_rate = XRCapabilities.check_FB_display_refresh_rate(provider, caps, ext);
        this.XR_FB_foveation = XRCapabilities.check_FB_foveation(provider, caps, ext);
        this.XR_FB_foveation_configuration = ext.contains("XR_FB_foveation_configuration");
        this.XR_FB_foveation_vulkan = ext.contains("XR_FB_foveation_vulkan");
        this.XR_FB_hand_tracking_aim = ext.contains("XR_FB_hand_tracking_aim");
        this.XR_FB_hand_tracking_capsules = ext.contains("XR_FB_hand_tracking_capsules");
        this.XR_FB_hand_tracking_mesh = XRCapabilities.check_FB_hand_tracking_mesh(provider, caps, ext);
        this.XR_FB_keyboard_tracking = XRCapabilities.check_FB_keyboard_tracking(provider, caps, ext);
        this.XR_FB_passthrough = XRCapabilities.check_FB_passthrough(provider, caps, ext);
        this.XR_FB_passthrough_keyboard_hands = XRCapabilities.check_FB_passthrough_keyboard_hands(provider, caps, ext);
        this.XR_FB_render_model = XRCapabilities.check_FB_render_model(provider, caps, ext);
        this.XR_FB_space_warp = ext.contains("XR_FB_space_warp");
        this.XR_FB_swapchain_update_state = XRCapabilities.check_FB_swapchain_update_state(provider, caps, ext);
        this.XR_FB_swapchain_update_state_opengl_es = ext.contains("XR_FB_swapchain_update_state_opengl_es");
        this.XR_FB_swapchain_update_state_vulkan = ext.contains("XR_FB_swapchain_update_state_vulkan");
        this.XR_FB_triangle_mesh = XRCapabilities.check_FB_triangle_mesh(provider, caps, ext);
        this.XR_HTC_facial_tracking = XRCapabilities.check_HTC_facial_tracking(provider, caps, ext);
        this.XR_HTC_vive_cosmos_controller_interaction = ext.contains("XR_HTC_vive_cosmos_controller_interaction");
        this.XR_HTC_vive_focus3_controller_interaction = ext.contains("XR_HTC_vive_focus3_controller_interaction");
        this.XR_HTCX_vive_tracker_interaction = XRCapabilities.check_HTCX_vive_tracker_interaction(provider, caps, ext);
        this.XR_HUAWEI_controller_interaction = ext.contains("XR_HUAWEI_controller_interaction");
        this.XR_KHR_binding_modification = ext.contains("XR_KHR_binding_modification");
        this.XR_KHR_composition_layer_color_scale_bias = ext.contains("XR_KHR_composition_layer_color_scale_bias");
        this.XR_KHR_composition_layer_cube = ext.contains("XR_KHR_composition_layer_cube");
        this.XR_KHR_composition_layer_cylinder = ext.contains("XR_KHR_composition_layer_cylinder");
        this.XR_KHR_composition_layer_depth = ext.contains("XR_KHR_composition_layer_depth");
        this.XR_KHR_composition_layer_equirect = ext.contains("XR_KHR_composition_layer_equirect");
        this.XR_KHR_composition_layer_equirect2 = ext.contains("XR_KHR_composition_layer_equirect2");
        this.XR_KHR_convert_timespec_time = XRCapabilities.check_KHR_convert_timespec_time(provider, caps, ext);
        this.XR_KHR_loader_init = ext.contains("XR_KHR_loader_init");
        this.XR_KHR_opengl_enable = XRCapabilities.check_KHR_opengl_enable(provider, caps, ext);
        this.XR_KHR_opengl_es_enable = XRCapabilities.check_KHR_opengl_es_enable(provider, caps, ext);
        this.XR_KHR_swapchain_usage_input_attachment_bit = ext.contains("XR_KHR_swapchain_usage_input_attachment_bit");
        this.XR_KHR_visibility_mask = XRCapabilities.check_KHR_visibility_mask(provider, caps, ext);
        this.XR_KHR_vulkan_enable = XRCapabilities.check_KHR_vulkan_enable(provider, caps, ext);
        this.XR_KHR_vulkan_enable2 = XRCapabilities.check_KHR_vulkan_enable2(provider, caps, ext);
        this.XR_KHR_vulkan_swapchain_format_list = ext.contains("XR_KHR_vulkan_swapchain_format_list");
        this.XR_KHR_win32_convert_performance_counter_time = XRCapabilities.check_KHR_win32_convert_performance_counter_time(provider, caps, ext);
        this.XR_MND_headless = ext.contains("XR_MND_headless");
        this.XR_MND_swapchain_usage_input_attachment_bit = ext.contains("XR_MND_swapchain_usage_input_attachment_bit");
        this.XR_MNDX_egl_enable = ext.contains("XR_MNDX_egl_enable");
        this.XR_MSFT_composition_layer_reprojection = XRCapabilities.check_MSFT_composition_layer_reprojection(provider, caps, ext);
        this.XR_MSFT_controller_model = XRCapabilities.check_MSFT_controller_model(provider, caps, ext);
        this.XR_MSFT_first_person_observer = ext.contains("XR_MSFT_first_person_observer");
        this.XR_MSFT_hand_interaction = ext.contains("XR_MSFT_hand_interaction");
        this.XR_MSFT_hand_tracking_mesh = XRCapabilities.check_MSFT_hand_tracking_mesh(provider, caps, ext);
        this.XR_MSFT_holographic_window_attachment = ext.contains("XR_MSFT_holographic_window_attachment");
        this.XR_MSFT_perception_anchor_interop = XRCapabilities.check_MSFT_perception_anchor_interop(provider, caps, ext);
        this.XR_MSFT_scene_understanding = XRCapabilities.check_MSFT_scene_understanding(provider, caps, ext);
        this.XR_MSFT_scene_understanding_serialization = XRCapabilities.check_MSFT_scene_understanding_serialization(provider, caps, ext);
        this.XR_MSFT_secondary_view_configuration = ext.contains("XR_MSFT_secondary_view_configuration");
        this.XR_MSFT_spatial_anchor = XRCapabilities.check_MSFT_spatial_anchor(provider, caps, ext);
        this.XR_MSFT_spatial_anchor_persistence = XRCapabilities.check_MSFT_spatial_anchor_persistence(provider, caps, ext);
        this.XR_MSFT_spatial_graph_bridge = XRCapabilities.check_MSFT_spatial_graph_bridge(provider, caps, ext);
        this.XR_MSFT_unbounded_reference_space = ext.contains("XR_MSFT_unbounded_reference_space");
        this.XR_OCULUS_audio_device_guid = XRCapabilities.check_OCULUS_audio_device_guid(provider, caps, ext);
        this.XR_VALVE_analog_threshold = ext.contains("XR_VALVE_analog_threshold");
        this.XR_VARJO_composition_layer_depth_test = ext.contains("XR_VARJO_composition_layer_depth_test");
        this.XR_VARJO_environment_depth_estimation = XRCapabilities.check_VARJO_environment_depth_estimation(provider, caps, ext);
        this.XR_VARJO_foveated_rendering = ext.contains("XR_VARJO_foveated_rendering");
        this.XR_VARJO_marker_tracking = XRCapabilities.check_VARJO_marker_tracking(provider, caps, ext);
        this.XR_VARJO_quad_views = ext.contains("XR_VARJO_quad_views");
        this.xrDestroyInstance = caps[0];
        this.xrGetInstanceProperties = caps[1];
        this.xrPollEvent = caps[2];
        this.xrResultToString = caps[3];
        this.xrStructureTypeToString = caps[4];
        this.xrGetSystem = caps[5];
        this.xrGetSystemProperties = caps[6];
        this.xrEnumerateEnvironmentBlendModes = caps[7];
        this.xrCreateSession = caps[8];
        this.xrDestroySession = caps[9];
        this.xrEnumerateReferenceSpaces = caps[10];
        this.xrCreateReferenceSpace = caps[11];
        this.xrGetReferenceSpaceBoundsRect = caps[12];
        this.xrCreateActionSpace = caps[13];
        this.xrLocateSpace = caps[14];
        this.xrDestroySpace = caps[15];
        this.xrEnumerateViewConfigurations = caps[16];
        this.xrGetViewConfigurationProperties = caps[17];
        this.xrEnumerateViewConfigurationViews = caps[18];
        this.xrEnumerateSwapchainFormats = caps[19];
        this.xrCreateSwapchain = caps[20];
        this.xrDestroySwapchain = caps[21];
        this.xrEnumerateSwapchainImages = caps[22];
        this.xrAcquireSwapchainImage = caps[23];
        this.xrWaitSwapchainImage = caps[24];
        this.xrReleaseSwapchainImage = caps[25];
        this.xrBeginSession = caps[26];
        this.xrEndSession = caps[27];
        this.xrRequestExitSession = caps[28];
        this.xrWaitFrame = caps[29];
        this.xrBeginFrame = caps[30];
        this.xrEndFrame = caps[31];
        this.xrLocateViews = caps[32];
        this.xrStringToPath = caps[33];
        this.xrPathToString = caps[34];
        this.xrCreateActionSet = caps[35];
        this.xrDestroyActionSet = caps[36];
        this.xrCreateAction = caps[37];
        this.xrDestroyAction = caps[38];
        this.xrSuggestInteractionProfileBindings = caps[39];
        this.xrAttachSessionActionSets = caps[40];
        this.xrGetCurrentInteractionProfile = caps[41];
        this.xrGetActionStateBoolean = caps[42];
        this.xrGetActionStateFloat = caps[43];
        this.xrGetActionStateVector2f = caps[44];
        this.xrGetActionStatePose = caps[45];
        this.xrSyncActions = caps[46];
        this.xrEnumerateBoundSourcesForAction = caps[47];
        this.xrGetInputSourceLocalizedName = caps[48];
        this.xrApplyHapticFeedback = caps[49];
        this.xrStopHapticFeedback = caps[50];
        this.xrSetDigitalLensControlALMALENCE = caps[51];
        this.xrSetInputDeviceActiveEXT = caps[52];
        this.xrSetInputDeviceStateBoolEXT = caps[53];
        this.xrSetInputDeviceStateFloatEXT = caps[54];
        this.xrSetInputDeviceStateVector2fEXT = caps[55];
        this.xrSetInputDeviceLocationEXT = caps[56];
        this.xrSetDebugUtilsObjectNameEXT = caps[57];
        this.xrCreateDebugUtilsMessengerEXT = caps[58];
        this.xrDestroyDebugUtilsMessengerEXT = caps[59];
        this.xrSubmitDebugUtilsMessageEXT = caps[60];
        this.xrSessionBeginDebugUtilsLabelRegionEXT = caps[61];
        this.xrSessionEndDebugUtilsLabelRegionEXT = caps[62];
        this.xrSessionInsertDebugUtilsLabelEXT = caps[63];
        this.xrCreateHandTrackerEXT = caps[64];
        this.xrDestroyHandTrackerEXT = caps[65];
        this.xrLocateHandJointsEXT = caps[66];
        this.xrPerfSettingsSetPerformanceLevelEXT = caps[67];
        this.xrThermalGetTemperatureTrendEXT = caps[68];
        this.xrEnumerateColorSpacesFB = caps[69];
        this.xrSetColorSpaceFB = caps[70];
        this.xrEnumerateDisplayRefreshRatesFB = caps[71];
        this.xrGetDisplayRefreshRateFB = caps[72];
        this.xrRequestDisplayRefreshRateFB = caps[73];
        this.xrCreateFoveationProfileFB = caps[74];
        this.xrDestroyFoveationProfileFB = caps[75];
        this.xrGetHandMeshFB = caps[76];
        this.xrQuerySystemTrackedKeyboardFB = caps[77];
        this.xrCreateKeyboardSpaceFB = caps[78];
        this.xrCreatePassthroughFB = caps[79];
        this.xrDestroyPassthroughFB = caps[80];
        this.xrPassthroughStartFB = caps[81];
        this.xrPassthroughPauseFB = caps[82];
        this.xrCreatePassthroughLayerFB = caps[83];
        this.xrDestroyPassthroughLayerFB = caps[84];
        this.xrPassthroughLayerPauseFB = caps[85];
        this.xrPassthroughLayerResumeFB = caps[86];
        this.xrPassthroughLayerSetStyleFB = caps[87];
        this.xrCreateGeometryInstanceFB = caps[88];
        this.xrDestroyGeometryInstanceFB = caps[89];
        this.xrGeometryInstanceSetTransformFB = caps[90];
        this.xrPassthroughLayerSetKeyboardHandsIntensityFB = caps[91];
        this.xrEnumerateRenderModelPathsFB = caps[92];
        this.xrGetRenderModelPropertiesFB = caps[93];
        this.xrLoadRenderModelFB = caps[94];
        this.xrUpdateSwapchainFB = caps[95];
        this.xrGetSwapchainStateFB = caps[96];
        this.xrCreateTriangleMeshFB = caps[97];
        this.xrDestroyTriangleMeshFB = caps[98];
        this.xrTriangleMeshGetVertexBufferFB = caps[99];
        this.xrTriangleMeshGetIndexBufferFB = caps[100];
        this.xrTriangleMeshBeginUpdateFB = caps[101];
        this.xrTriangleMeshEndUpdateFB = caps[102];
        this.xrTriangleMeshBeginVertexBufferUpdateFB = caps[103];
        this.xrTriangleMeshEndVertexBufferUpdateFB = caps[104];
        this.xrCreateFacialTrackerHTC = caps[105];
        this.xrDestroyFacialTrackerHTC = caps[106];
        this.xrGetFacialExpressionsHTC = caps[107];
        this.xrEnumerateViveTrackerPathsHTCX = caps[108];
        this.xrConvertTimespecTimeToTimeKHR = caps[109];
        this.xrConvertTimeToTimespecTimeKHR = caps[110];
        this.xrGetOpenGLGraphicsRequirementsKHR = caps[111];
        this.xrGetOpenGLESGraphicsRequirementsKHR = caps[112];
        this.xrGetVisibilityMaskKHR = caps[113];
        this.xrGetVulkanInstanceExtensionsKHR = caps[114];
        this.xrGetVulkanDeviceExtensionsKHR = caps[115];
        this.xrGetVulkanGraphicsDeviceKHR = caps[116];
        this.xrGetVulkanGraphicsRequirementsKHR = caps[117];
        this.xrCreateVulkanInstanceKHR = caps[118];
        this.xrCreateVulkanDeviceKHR = caps[119];
        this.xrGetVulkanGraphicsDevice2KHR = caps[120];
        this.xrGetVulkanGraphicsRequirements2KHR = caps[121];
        this.xrConvertWin32PerformanceCounterToTimeKHR = caps[122];
        this.xrConvertTimeToWin32PerformanceCounterKHR = caps[123];
        this.xrEnumerateReprojectionModesMSFT = caps[124];
        this.xrGetControllerModelKeyMSFT = caps[125];
        this.xrLoadControllerModelMSFT = caps[126];
        this.xrGetControllerModelPropertiesMSFT = caps[127];
        this.xrGetControllerModelStateMSFT = caps[128];
        this.xrCreateHandMeshSpaceMSFT = caps[129];
        this.xrUpdateHandMeshMSFT = caps[130];
        this.xrCreateSpatialAnchorFromPerceptionAnchorMSFT = caps[131];
        this.xrTryGetPerceptionAnchorFromSpatialAnchorMSFT = caps[132];
        this.xrEnumerateSceneComputeFeaturesMSFT = caps[133];
        this.xrCreateSceneObserverMSFT = caps[134];
        this.xrDestroySceneObserverMSFT = caps[135];
        this.xrCreateSceneMSFT = caps[136];
        this.xrDestroySceneMSFT = caps[137];
        this.xrComputeNewSceneMSFT = caps[138];
        this.xrGetSceneComputeStateMSFT = caps[139];
        this.xrGetSceneComponentsMSFT = caps[140];
        this.xrLocateSceneComponentsMSFT = caps[141];
        this.xrGetSceneMeshBuffersMSFT = caps[142];
        this.xrDeserializeSceneMSFT = caps[143];
        this.xrGetSerializedSceneFragmentDataMSFT = caps[144];
        this.xrCreateSpatialAnchorMSFT = caps[145];
        this.xrCreateSpatialAnchorSpaceMSFT = caps[146];
        this.xrDestroySpatialAnchorMSFT = caps[147];
        this.xrCreateSpatialAnchorStoreConnectionMSFT = caps[148];
        this.xrDestroySpatialAnchorStoreConnectionMSFT = caps[149];
        this.xrPersistSpatialAnchorMSFT = caps[150];
        this.xrEnumeratePersistedSpatialAnchorNamesMSFT = caps[151];
        this.xrCreateSpatialAnchorFromPersistedNameMSFT = caps[152];
        this.xrUnpersistSpatialAnchorMSFT = caps[153];
        this.xrClearSpatialAnchorStoreMSFT = caps[154];
        this.xrCreateSpatialGraphNodeSpaceMSFT = caps[155];
        this.xrGetAudioOutputDeviceGuidOculus = caps[156];
        this.xrGetAudioInputDeviceGuidOculus = caps[157];
        this.xrSetEnvironmentDepthEstimationVARJO = caps[158];
        this.xrSetMarkerTrackingVARJO = caps[159];
        this.xrSetMarkerTrackingTimeoutVARJO = caps[160];
        this.xrSetMarkerTrackingPredictionVARJO = caps[161];
        this.xrGetMarkerSizeVARJO = caps[162];
        this.xrCreateMarkerSpaceVARJO = caps[163];
    }

    private static boolean check_XR10(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("OpenXR10")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}, "xrDestroyInstance", "xrGetInstanceProperties", "xrPollEvent", "xrResultToString", "xrStructureTypeToString", "xrGetSystem", "xrGetSystemProperties", "xrEnumerateEnvironmentBlendModes", "xrCreateSession", "xrDestroySession", "xrEnumerateReferenceSpaces", "xrCreateReferenceSpace", "xrGetReferenceSpaceBoundsRect", "xrCreateActionSpace", "xrLocateSpace", "xrDestroySpace", "xrEnumerateViewConfigurations", "xrGetViewConfigurationProperties", "xrEnumerateViewConfigurationViews", "xrEnumerateSwapchainFormats", "xrCreateSwapchain", "xrDestroySwapchain", "xrEnumerateSwapchainImages", "xrAcquireSwapchainImage", "xrWaitSwapchainImage", "xrReleaseSwapchainImage", "xrBeginSession", "xrEndSession", "xrRequestExitSession", "xrWaitFrame", "xrBeginFrame", "xrEndFrame", "xrLocateViews", "xrStringToPath", "xrPathToString", "xrCreateActionSet", "xrDestroyActionSet", "xrCreateAction", "xrDestroyAction", "xrSuggestInteractionProfileBindings", "xrAttachSessionActionSets", "xrGetCurrentInteractionProfile", "xrGetActionStateBoolean", "xrGetActionStateFloat", "xrGetActionStateVector2f", "xrGetActionStatePose", "xrSyncActions", "xrEnumerateBoundSourcesForAction", "xrGetInputSourceLocalizedName", "xrApplyHapticFeedback", "xrStopHapticFeedback") || Checks.reportMissing("XR", "OpenXR10");
    }

    private static boolean check_ALMALENCE_digital_lens_control(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_ALMALENCE_digital_lens_control")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{51}, "xrSetDigitalLensControlALMALENCE") || Checks.reportMissing("XR", "XR_ALMALENCE_digital_lens_control");
    }

    private static boolean check_EXT_conformance_automation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_conformance_automation")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{52, 53, 54, 55, 56}, "xrSetInputDeviceActiveEXT", "xrSetInputDeviceStateBoolEXT", "xrSetInputDeviceStateFloatEXT", "xrSetInputDeviceStateVector2fEXT", "xrSetInputDeviceLocationEXT") || Checks.reportMissing("XR", "XR_EXT_conformance_automation");
    }

    private static boolean check_EXT_debug_utils(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_debug_utils")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{57, 58, 59, 60, 61, 62, 63}, "xrSetDebugUtilsObjectNameEXT", "xrCreateDebugUtilsMessengerEXT", "xrDestroyDebugUtilsMessengerEXT", "xrSubmitDebugUtilsMessageEXT", "xrSessionBeginDebugUtilsLabelRegionEXT", "xrSessionEndDebugUtilsLabelRegionEXT", "xrSessionInsertDebugUtilsLabelEXT") || Checks.reportMissing("XR", "XR_EXT_debug_utils");
    }

    private static boolean check_EXT_hand_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_hand_tracking")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{64, 65, 66}, "xrCreateHandTrackerEXT", "xrDestroyHandTrackerEXT", "xrLocateHandJointsEXT") || Checks.reportMissing("XR", "XR_EXT_hand_tracking");
    }

    private static boolean check_EXT_performance_settings(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_performance_settings")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{67}, "xrPerfSettingsSetPerformanceLevelEXT") || Checks.reportMissing("XR", "XR_EXT_performance_settings");
    }

    private static boolean check_EXT_thermal_query(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_EXT_thermal_query")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{68}, "xrThermalGetTemperatureTrendEXT") || Checks.reportMissing("XR", "XR_EXT_thermal_query");
    }

    private static boolean check_FB_color_space(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_color_space")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{69, 70}, "xrEnumerateColorSpacesFB", "xrSetColorSpaceFB") || Checks.reportMissing("XR", "XR_FB_color_space");
    }

    private static boolean check_FB_display_refresh_rate(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_display_refresh_rate")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{71, 72, 73}, "xrEnumerateDisplayRefreshRatesFB", "xrGetDisplayRefreshRateFB", "xrRequestDisplayRefreshRateFB") || Checks.reportMissing("XR", "XR_FB_display_refresh_rate");
    }

    private static boolean check_FB_foveation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_foveation")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{74, 75}, "xrCreateFoveationProfileFB", "xrDestroyFoveationProfileFB") || Checks.reportMissing("XR", "XR_FB_foveation");
    }

    private static boolean check_FB_hand_tracking_mesh(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_hand_tracking_mesh")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{76}, "xrGetHandMeshFB") || Checks.reportMissing("XR", "XR_FB_hand_tracking_mesh");
    }

    private static boolean check_FB_keyboard_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_keyboard_tracking")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{77, 78}, "xrQuerySystemTrackedKeyboardFB", "xrCreateKeyboardSpaceFB") || Checks.reportMissing("XR", "XR_FB_keyboard_tracking");
    }

    private static boolean check_FB_passthrough(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_passthrough")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90}, "xrCreatePassthroughFB", "xrDestroyPassthroughFB", "xrPassthroughStartFB", "xrPassthroughPauseFB", "xrCreatePassthroughLayerFB", "xrDestroyPassthroughLayerFB", "xrPassthroughLayerPauseFB", "xrPassthroughLayerResumeFB", "xrPassthroughLayerSetStyleFB", "xrCreateGeometryInstanceFB", "xrDestroyGeometryInstanceFB", "xrGeometryInstanceSetTransformFB") || Checks.reportMissing("XR", "XR_FB_passthrough");
    }

    private static boolean check_FB_passthrough_keyboard_hands(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_passthrough_keyboard_hands")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{91}, "xrPassthroughLayerSetKeyboardHandsIntensityFB") || Checks.reportMissing("XR", "XR_FB_passthrough_keyboard_hands");
    }

    private static boolean check_FB_render_model(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_render_model")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{92, 93, 94}, "xrEnumerateRenderModelPathsFB", "xrGetRenderModelPropertiesFB", "xrLoadRenderModelFB") || Checks.reportMissing("XR", "XR_FB_render_model");
    }

    private static boolean check_FB_swapchain_update_state(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_swapchain_update_state")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{95, 96}, "xrUpdateSwapchainFB", "xrGetSwapchainStateFB") || Checks.reportMissing("XR", "XR_FB_swapchain_update_state");
    }

    private static boolean check_FB_triangle_mesh(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_FB_triangle_mesh")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{97, 98, 99, 100, 101, 102, 103, 104}, "xrCreateTriangleMeshFB", "xrDestroyTriangleMeshFB", "xrTriangleMeshGetVertexBufferFB", "xrTriangleMeshGetIndexBufferFB", "xrTriangleMeshBeginUpdateFB", "xrTriangleMeshEndUpdateFB", "xrTriangleMeshBeginVertexBufferUpdateFB", "xrTriangleMeshEndVertexBufferUpdateFB") || Checks.reportMissing("XR", "XR_FB_triangle_mesh");
    }

    private static boolean check_HTC_facial_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_HTC_facial_tracking")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{105, 106, 107}, "xrCreateFacialTrackerHTC", "xrDestroyFacialTrackerHTC", "xrGetFacialExpressionsHTC") || Checks.reportMissing("XR", "XR_HTC_facial_tracking");
    }

    private static boolean check_HTCX_vive_tracker_interaction(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_HTCX_vive_tracker_interaction")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{108}, "xrEnumerateViveTrackerPathsHTCX") || Checks.reportMissing("XR", "XR_HTCX_vive_tracker_interaction");
    }

    private static boolean check_KHR_convert_timespec_time(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_convert_timespec_time")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{109, 110}, "xrConvertTimespecTimeToTimeKHR", "xrConvertTimeToTimespecTimeKHR") || Checks.reportMissing("XR", "XR_KHR_convert_timespec_time");
    }

    private static boolean check_KHR_opengl_enable(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_opengl_enable")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{111}, "xrGetOpenGLGraphicsRequirementsKHR") || Checks.reportMissing("XR", "XR_KHR_opengl_enable");
    }

    private static boolean check_KHR_opengl_es_enable(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_opengl_es_enable")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{112}, "xrGetOpenGLESGraphicsRequirementsKHR") || Checks.reportMissing("XR", "XR_KHR_opengl_es_enable");
    }

    private static boolean check_KHR_visibility_mask(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_visibility_mask")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{113}, "xrGetVisibilityMaskKHR") || Checks.reportMissing("XR", "XR_KHR_visibility_mask");
    }

    private static boolean check_KHR_vulkan_enable(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_vulkan_enable")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{114, 115, 116, 117}, "xrGetVulkanInstanceExtensionsKHR", "xrGetVulkanDeviceExtensionsKHR", "xrGetVulkanGraphicsDeviceKHR", "xrGetVulkanGraphicsRequirementsKHR") || Checks.reportMissing("XR", "XR_KHR_vulkan_enable");
    }

    private static boolean check_KHR_vulkan_enable2(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_vulkan_enable2")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{118, 119, 120, 121}, "xrCreateVulkanInstanceKHR", "xrCreateVulkanDeviceKHR", "xrGetVulkanGraphicsDevice2KHR", "xrGetVulkanGraphicsRequirements2KHR") || Checks.reportMissing("XR", "XR_KHR_vulkan_enable2");
    }

    private static boolean check_KHR_win32_convert_performance_counter_time(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_KHR_win32_convert_performance_counter_time")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{122, 123}, "xrConvertWin32PerformanceCounterToTimeKHR", "xrConvertTimeToWin32PerformanceCounterKHR") || Checks.reportMissing("XR", "XR_KHR_win32_convert_performance_counter_time");
    }

    private static boolean check_MSFT_composition_layer_reprojection(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_composition_layer_reprojection")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{124}, "xrEnumerateReprojectionModesMSFT") || Checks.reportMissing("XR", "XR_MSFT_composition_layer_reprojection");
    }

    private static boolean check_MSFT_controller_model(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_controller_model")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{125, 126, 127, 128}, "xrGetControllerModelKeyMSFT", "xrLoadControllerModelMSFT", "xrGetControllerModelPropertiesMSFT", "xrGetControllerModelStateMSFT") || Checks.reportMissing("XR", "XR_MSFT_controller_model");
    }

    private static boolean check_MSFT_hand_tracking_mesh(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_hand_tracking_mesh")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{129, 130}, "xrCreateHandMeshSpaceMSFT", "xrUpdateHandMeshMSFT") || Checks.reportMissing("XR", "XR_MSFT_hand_tracking_mesh");
    }

    private static boolean check_MSFT_perception_anchor_interop(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_perception_anchor_interop")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{131, 132}, "xrCreateSpatialAnchorFromPerceptionAnchorMSFT", "xrTryGetPerceptionAnchorFromSpatialAnchorMSFT") || Checks.reportMissing("XR", "XR_MSFT_perception_anchor_interop");
    }

    private static boolean check_MSFT_scene_understanding(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_scene_understanding")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{133, 134, 135, 136, 137, 138, 139, 140, 141, 142}, "xrEnumerateSceneComputeFeaturesMSFT", "xrCreateSceneObserverMSFT", "xrDestroySceneObserverMSFT", "xrCreateSceneMSFT", "xrDestroySceneMSFT", "xrComputeNewSceneMSFT", "xrGetSceneComputeStateMSFT", "xrGetSceneComponentsMSFT", "xrLocateSceneComponentsMSFT", "xrGetSceneMeshBuffersMSFT") || Checks.reportMissing("XR", "XR_MSFT_scene_understanding");
    }

    private static boolean check_MSFT_scene_understanding_serialization(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_scene_understanding_serialization")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{143, 144}, "xrDeserializeSceneMSFT", "xrGetSerializedSceneFragmentDataMSFT") || Checks.reportMissing("XR", "XR_MSFT_scene_understanding_serialization");
    }

    private static boolean check_MSFT_spatial_anchor(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_spatial_anchor")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{145, 146, 147}, "xrCreateSpatialAnchorMSFT", "xrCreateSpatialAnchorSpaceMSFT", "xrDestroySpatialAnchorMSFT") || Checks.reportMissing("XR", "XR_MSFT_spatial_anchor");
    }

    private static boolean check_MSFT_spatial_anchor_persistence(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_spatial_anchor_persistence")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{148, 149, 150, 151, 152, 153, 154}, "xrCreateSpatialAnchorStoreConnectionMSFT", "xrDestroySpatialAnchorStoreConnectionMSFT", "xrPersistSpatialAnchorMSFT", "xrEnumeratePersistedSpatialAnchorNamesMSFT", "xrCreateSpatialAnchorFromPersistedNameMSFT", "xrUnpersistSpatialAnchorMSFT", "xrClearSpatialAnchorStoreMSFT") || Checks.reportMissing("XR", "XR_MSFT_spatial_anchor_persistence");
    }

    private static boolean check_MSFT_spatial_graph_bridge(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_MSFT_spatial_graph_bridge")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{155}, "xrCreateSpatialGraphNodeSpaceMSFT") || Checks.reportMissing("XR", "XR_MSFT_spatial_graph_bridge");
    }

    private static boolean check_OCULUS_audio_device_guid(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_OCULUS_audio_device_guid")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{156, 157}, "xrGetAudioOutputDeviceGuidOculus", "xrGetAudioInputDeviceGuidOculus") || Checks.reportMissing("XR", "XR_OCULUS_audio_device_guid");
    }

    private static boolean check_VARJO_environment_depth_estimation(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_VARJO_environment_depth_estimation")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{158}, "xrSetEnvironmentDepthEstimationVARJO") || Checks.reportMissing("XR", "XR_VARJO_environment_depth_estimation");
    }

    private static boolean check_VARJO_marker_tracking(FunctionProvider provider, long[] caps, Set<String> ext) {
        if (!ext.contains("XR_VARJO_marker_tracking")) {
            return false;
        }
        return Checks.checkFunctions(provider, caps, new int[]{159, 160, 161, 162, 163}, "xrSetMarkerTrackingVARJO", "xrSetMarkerTrackingTimeoutVARJO", "xrSetMarkerTrackingPredictionVARJO", "xrGetMarkerSizeVARJO", "xrCreateMarkerSpaceVARJO") || Checks.reportMissing("XR", "XR_VARJO_marker_tracking");
    }
}

