/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.openxr.XrSpatialAnchorCreateInfoMSFT;
import org.lwjgl.openxr.XrSpatialAnchorMSFT;
import org.lwjgl.openxr.XrSpatialAnchorSpaceCreateInfoMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTSpatialAnchor {
    public static final int XR_MSFT_spatial_anchor_SPEC_VERSION = 2;
    public static final String XR_MSFT_SPATIAL_ANCHOR_EXTENSION_NAME = "XR_MSFT_spatial_anchor";
    public static final int XR_TYPE_SPATIAL_ANCHOR_CREATE_INFO_MSFT = 1000039000;
    public static final int XR_TYPE_SPATIAL_ANCHOR_SPACE_CREATE_INFO_MSFT = 1000039001;
    public static final int XR_OBJECT_TYPE_SPATIAL_ANCHOR_MSFT = 1000039000;
    public static final int XR_ERROR_CREATE_SPATIAL_ANCHOR_FAILED_MSFT = -1000039001;

    protected MSFTSpatialAnchor() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateSpatialAnchorMSFT(XrSession session, long createInfo, long anchor) {
        long __functionAddress = session.getCapabilities().xrCreateSpatialAnchorMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrSpatialAnchorCreateInfoMSFT.validate(createInfo);
        }
        return JNI.callPPPI(session.address(), createInfo, anchor, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSpatialAnchorMSFT(XrSession session, @NativeType(value="XrSpatialAnchorCreateInfoMSFT const *") XrSpatialAnchorCreateInfoMSFT createInfo, @NativeType(value="XrSpatialAnchorMSFT *") PointerBuffer anchor) {
        if (Checks.CHECKS) {
            Checks.check(anchor, 1);
        }
        return MSFTSpatialAnchor.nxrCreateSpatialAnchorMSFT(session, createInfo.address(), MemoryUtil.memAddress(anchor));
    }

    public static int nxrCreateSpatialAnchorSpaceMSFT(XrSession session, long createInfo, long space) {
        long __functionAddress = session.getCapabilities().xrCreateSpatialAnchorSpaceMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrSpatialAnchorSpaceCreateInfoMSFT.validate(createInfo);
        }
        return JNI.callPPPI(session.address(), createInfo, space, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateSpatialAnchorSpaceMSFT(XrSession session, @NativeType(value="XrSpatialAnchorSpaceCreateInfoMSFT const *") XrSpatialAnchorSpaceCreateInfoMSFT createInfo, @NativeType(value="XrSpace *") PointerBuffer space) {
        if (Checks.CHECKS) {
            Checks.check(space, 1);
        }
        return MSFTSpatialAnchor.nxrCreateSpatialAnchorSpaceMSFT(session, createInfo.address(), MemoryUtil.memAddress(space));
    }

    @NativeType(value="XrResult")
    public static int xrDestroySpatialAnchorMSFT(XrSpatialAnchorMSFT anchor) {
        long __functionAddress = anchor.getCapabilities().xrDestroySpatialAnchorMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(anchor.address(), __functionAddress);
    }
}

