/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openxr.XrControllerModelKeyStateMSFT;
import org.lwjgl.openxr.XrControllerModelPropertiesMSFT;
import org.lwjgl.openxr.XrControllerModelStateMSFT;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MSFTControllerModel {
    public static final int XR_MSFT_controller_model_SPEC_VERSION = 2;
    public static final String XR_MSFT_CONTROLLER_MODEL_EXTENSION_NAME = "XR_MSFT_controller_model";
    public static final int XR_MAX_CONTROLLER_MODEL_NODE_NAME_SIZE_MSFT = 64;
    public static final int XR_TYPE_CONTROLLER_MODEL_KEY_STATE_MSFT = 1000055000;
    public static final int XR_TYPE_CONTROLLER_MODEL_NODE_PROPERTIES_MSFT = 1000055001;
    public static final int XR_TYPE_CONTROLLER_MODEL_PROPERTIES_MSFT = 1000055002;
    public static final int XR_TYPE_CONTROLLER_MODEL_NODE_STATE_MSFT = 1000055003;
    public static final int XR_TYPE_CONTROLLER_MODEL_STATE_MSFT = 1000055004;
    public static final int XR_ERROR_CONTROLLER_MODEL_KEY_INVALID_MSFT = -1000055000;
    public static final long XR_NULL_CONTROLLER_MODEL_KEY_MSFT = 0L;

    protected MSFTControllerModel() {
        throw new UnsupportedOperationException();
    }

    public static int nxrGetControllerModelKeyMSFT(XrSession session, long topLevelUserPath, long controllerModelKeyState) {
        long __functionAddress = session.getCapabilities().xrGetControllerModelKeyMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(session.address(), topLevelUserPath, controllerModelKeyState, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetControllerModelKeyMSFT(XrSession session, @NativeType(value="XrPath") long topLevelUserPath, @NativeType(value="XrControllerModelKeyStateMSFT *") XrControllerModelKeyStateMSFT controllerModelKeyState) {
        return MSFTControllerModel.nxrGetControllerModelKeyMSFT(session, topLevelUserPath, controllerModelKeyState.address());
    }

    public static int nxrLoadControllerModelMSFT(XrSession session, long modelKey, int bufferCapacityInput, long bufferCountOutput, long buffer) {
        long __functionAddress = session.getCapabilities().xrLoadControllerModelMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPPI(session.address(), modelKey, bufferCapacityInput, bufferCountOutput, buffer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrLoadControllerModelMSFT(XrSession session, @NativeType(value="XrControllerModelKeyMSFT") long modelKey, @NativeType(value="uint32_t *") IntBuffer bufferCountOutput, @Nullable @NativeType(value="uint8_t *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)bufferCountOutput, 1);
        }
        return MSFTControllerModel.nxrLoadControllerModelMSFT(session, modelKey, Checks.remainingSafe(buffer), MemoryUtil.memAddress(bufferCountOutput), MemoryUtil.memAddressSafe(buffer));
    }

    public static int nxrGetControllerModelPropertiesMSFT(XrSession session, long modelKey, long properties) {
        long __functionAddress = session.getCapabilities().xrGetControllerModelPropertiesMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(session.address(), modelKey, properties, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetControllerModelPropertiesMSFT(XrSession session, @NativeType(value="XrControllerModelKeyMSFT") long modelKey, @NativeType(value="XrControllerModelPropertiesMSFT *") XrControllerModelPropertiesMSFT properties) {
        return MSFTControllerModel.nxrGetControllerModelPropertiesMSFT(session, modelKey, properties.address());
    }

    public static int nxrGetControllerModelStateMSFT(XrSession session, long modelKey, long state) {
        long __functionAddress = session.getCapabilities().xrGetControllerModelStateMSFT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJPI(session.address(), modelKey, state, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetControllerModelStateMSFT(XrSession session, @NativeType(value="XrControllerModelKeyMSFT") long modelKey, @NativeType(value="XrControllerModelStateMSFT *") XrControllerModelStateMSFT state) {
        return MSFTControllerModel.nxrGetControllerModelStateMSFT(session, modelKey, state.address());
    }
}

