/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrGeometryInstanceCreateInfoFB;
import org.lwjgl.openxr.XrGeometryInstanceFB;
import org.lwjgl.openxr.XrGeometryInstanceTransformFB;
import org.lwjgl.openxr.XrPassthroughCreateInfoFB;
import org.lwjgl.openxr.XrPassthroughFB;
import org.lwjgl.openxr.XrPassthroughLayerCreateInfoFB;
import org.lwjgl.openxr.XrPassthroughLayerFB;
import org.lwjgl.openxr.XrPassthroughStyleFB;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class FBPassthrough {
    public static final int XR_FB_passthrough_SPEC_VERSION = 1;
    public static final String XR_FB_PASSTHROUGH_EXTENSION_NAME = "XR_FB_passthrough";
    public static final int XR_TYPE_SYSTEM_PASSTHROUGH_PROPERTIES_FB = 1000118000;
    public static final int XR_TYPE_PASSTHROUGH_CREATE_INFO_FB = 1000118001;
    public static final int XR_TYPE_PASSTHROUGH_LAYER_CREATE_INFO_FB = 1000118002;
    public static final int XR_TYPE_COMPOSITION_LAYER_PASSTHROUGH_FB = 1000118003;
    public static final int XR_TYPE_GEOMETRY_INSTANCE_CREATE_INFO_FB = 1000118004;
    public static final int XR_TYPE_GEOMETRY_INSTANCE_TRANSFORM_FB = 1000118005;
    public static final int XR_TYPE_PASSTHROUGH_STYLE_FB = 1000118020;
    public static final int XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_RGBA_FB = 1000118021;
    public static final int XR_TYPE_PASSTHROUGH_COLOR_MAP_MONO_TO_MONO_FB = 1000118022;
    public static final int XR_TYPE_EVENT_DATA_PASSTHROUGH_STATE_CHANGED_FB = 1000118030;
    public static final int XR_ERROR_UNEXPECTED_STATE_PASSTHROUGH_FB = -1000118000;
    public static final int XR_ERROR_FEATURE_ALREADY_CREATED_PASSTHROUGH_FB = -1000118001;
    public static final int XR_ERROR_FEATURE_REQUIRED_PASSTHROUGH_FB = -1000118002;
    public static final int XR_ERROR_NOT_PERMITTED_PASSTHROUGH_FB = -1000118003;
    public static final int XR_ERROR_INSUFFICIENT_RESOURCES_PASSTHROUGH_FB = -1000118004;
    public static final int XR_ERROR_UNKNOWN_PASSTHROUGH_FB = -1000118050;
    public static final int XR_PASSTHROUGH_COLOR_MAP_MONO_SIZE_FB = 256;
    public static final int XR_OBJECT_TYPE_PASSTHROUGH_FB = 1000118000;
    public static final int XR_OBJECT_TYPE_PASSTHROUGH_LAYER_FB = 1000118002;
    public static final int XR_OBJECT_TYPE_GEOMETRY_INSTANCE_FB = 1000118004;
    public static final int XR_PASSTHROUGH_IS_RUNNING_AT_CREATION_BIT_FB = 1;
    public static final int XR_PASSTHROUGH_LAYER_PURPOSE_RECONSTRUCTION_FB = 0;
    public static final int XR_PASSTHROUGH_LAYER_PURPOSE_PROJECTED_FB = 1;
    public static final int XR_PASSTHROUGH_STATE_CHANGED_REINIT_REQUIRED_BIT_FB = 1;
    public static final int XR_PASSTHROUGH_STATE_CHANGED_NON_RECOVERABLE_ERROR_BIT_FB = 2;
    public static final int XR_PASSTHROUGH_STATE_CHANGED_RECOVERABLE_ERROR_BIT_FB = 4;
    public static final int XR_PASSTHROUGH_STATE_CHANGED_RESTORED_ERROR_BIT_FB = 8;

    protected FBPassthrough() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreatePassthroughFB(XrSession session, long createInfo, long outPassthrough) {
        long __functionAddress = session.getCapabilities().xrCreatePassthroughFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(session.address(), createInfo, outPassthrough, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreatePassthroughFB(XrSession session, @NativeType(value="XrPassthroughCreateInfoFB const *") XrPassthroughCreateInfoFB createInfo, @NativeType(value="XrPassthroughFB *") PointerBuffer outPassthrough) {
        if (Checks.CHECKS) {
            Checks.check(outPassthrough, 1);
        }
        return FBPassthrough.nxrCreatePassthroughFB(session, createInfo.address(), MemoryUtil.memAddress(outPassthrough));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyPassthroughFB(XrPassthroughFB passthrough) {
        long __functionAddress = passthrough.getCapabilities().xrDestroyPassthroughFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(passthrough.address(), __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPassthroughStartFB(XrPassthroughFB passthrough) {
        long __functionAddress = passthrough.getCapabilities().xrPassthroughStartFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(passthrough.address(), __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPassthroughPauseFB(XrPassthroughFB passthrough) {
        long __functionAddress = passthrough.getCapabilities().xrPassthroughPauseFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(passthrough.address(), __functionAddress);
    }

    public static int nxrCreatePassthroughLayerFB(XrSession session, long createInfo, long outLayer) {
        long __functionAddress = session.getCapabilities().xrCreatePassthroughLayerFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrPassthroughLayerCreateInfoFB.validate(createInfo);
        }
        return JNI.callPPPI(session.address(), createInfo, outLayer, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreatePassthroughLayerFB(XrSession session, @NativeType(value="XrPassthroughLayerCreateInfoFB const *") XrPassthroughLayerCreateInfoFB createInfo, @NativeType(value="XrPassthroughLayerFB *") PointerBuffer outLayer) {
        if (Checks.CHECKS) {
            Checks.check(outLayer, 1);
        }
        return FBPassthrough.nxrCreatePassthroughLayerFB(session, createInfo.address(), MemoryUtil.memAddress(outLayer));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyPassthroughLayerFB(XrPassthroughLayerFB layer) {
        long __functionAddress = layer.getCapabilities().xrDestroyPassthroughLayerFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(layer.address(), __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPassthroughLayerPauseFB(XrPassthroughLayerFB layer) {
        long __functionAddress = layer.getCapabilities().xrPassthroughLayerPauseFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(layer.address(), __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPassthroughLayerResumeFB(XrPassthroughLayerFB layer) {
        long __functionAddress = layer.getCapabilities().xrPassthroughLayerResumeFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(layer.address(), __functionAddress);
    }

    public static int nxrPassthroughLayerSetStyleFB(XrPassthroughLayerFB layer, long style) {
        long __functionAddress = layer.getCapabilities().xrPassthroughLayerSetStyleFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(layer.address(), style, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrPassthroughLayerSetStyleFB(XrPassthroughLayerFB layer, @NativeType(value="XrPassthroughStyleFB const *") XrPassthroughStyleFB style) {
        return FBPassthrough.nxrPassthroughLayerSetStyleFB(layer, style.address());
    }

    public static int nxrCreateGeometryInstanceFB(XrSession session, long createInfo, long outGeometryInstance) {
        long __functionAddress = session.getCapabilities().xrCreateGeometryInstanceFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrGeometryInstanceCreateInfoFB.validate(createInfo);
        }
        return JNI.callPPPI(session.address(), createInfo, outGeometryInstance, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateGeometryInstanceFB(XrSession session, @NativeType(value="XrGeometryInstanceCreateInfoFB const *") XrGeometryInstanceCreateInfoFB createInfo, @NativeType(value="XrGeometryInstanceFB *") PointerBuffer outGeometryInstance) {
        if (Checks.CHECKS) {
            Checks.check(outGeometryInstance, 1);
        }
        return FBPassthrough.nxrCreateGeometryInstanceFB(session, createInfo.address(), MemoryUtil.memAddress(outGeometryInstance));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyGeometryInstanceFB(XrGeometryInstanceFB instance) {
        long __functionAddress = instance.getCapabilities().xrDestroyGeometryInstanceFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(instance.address(), __functionAddress);
    }

    public static int nxrGeometryInstanceSetTransformFB(XrGeometryInstanceFB instance, long transformation) {
        long __functionAddress = instance.getCapabilities().xrGeometryInstanceSetTransformFB;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            XrGeometryInstanceTransformFB.validate(transformation);
        }
        return JNI.callPPI(instance.address(), transformation, __functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGeometryInstanceSetTransformFB(XrGeometryInstanceFB instance, @NativeType(value="XrGeometryInstanceTransformFB const *") XrGeometryInstanceTransformFB transformation) {
        return FBPassthrough.nxrGeometryInstanceSetTransformFB(instance, transformation.address());
    }
}

