/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VROverlayIntersectionParams_t")
public class VROverlayIntersectionParams
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VSOURCE;
    public static final int VDIRECTION;
    public static final int EORIGIN;

    public VROverlayIntersectionParams(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VROverlayIntersectionParams.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vSource() {
        return VROverlayIntersectionParams.nvSource(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vDirection() {
        return VROverlayIntersectionParams.nvDirection(this.address());
    }

    @NativeType(value="ETrackingUniverseOrigin")
    public int eOrigin() {
        return VROverlayIntersectionParams.neOrigin(this.address());
    }

    public VROverlayIntersectionParams vSource(@NativeType(value="HmdVector3_t") HmdVector3 value) {
        VROverlayIntersectionParams.nvSource(this.address(), value);
        return this;
    }

    public VROverlayIntersectionParams vSource(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vSource());
        return this;
    }

    public VROverlayIntersectionParams vDirection(@NativeType(value="HmdVector3_t") HmdVector3 value) {
        VROverlayIntersectionParams.nvDirection(this.address(), value);
        return this;
    }

    public VROverlayIntersectionParams vDirection(Consumer<HmdVector3> consumer) {
        consumer.accept(this.vDirection());
        return this;
    }

    public VROverlayIntersectionParams eOrigin(@NativeType(value="ETrackingUniverseOrigin") int value) {
        VROverlayIntersectionParams.neOrigin(this.address(), value);
        return this;
    }

    public VROverlayIntersectionParams set(HmdVector3 vSource, HmdVector3 vDirection, int eOrigin) {
        this.vSource(vSource);
        this.vDirection(vDirection);
        this.eOrigin(eOrigin);
        return this;
    }

    public VROverlayIntersectionParams set(VROverlayIntersectionParams src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VROverlayIntersectionParams malloc() {
        return VROverlayIntersectionParams.wrap(VROverlayIntersectionParams.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VROverlayIntersectionParams calloc() {
        return VROverlayIntersectionParams.wrap(VROverlayIntersectionParams.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VROverlayIntersectionParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VROverlayIntersectionParams.wrap(VROverlayIntersectionParams.class, MemoryUtil.memAddress(container), container);
    }

    public static VROverlayIntersectionParams create(long address) {
        return VROverlayIntersectionParams.wrap(VROverlayIntersectionParams.class, address);
    }

    @Nullable
    public static VROverlayIntersectionParams createSafe(long address) {
        return address == 0L ? null : VROverlayIntersectionParams.wrap(VROverlayIntersectionParams.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VROverlayIntersectionParams.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VROverlayIntersectionParams.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VROverlayIntersectionParams.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VROverlayIntersectionParams.__create(capacity, SIZEOF);
        return VROverlayIntersectionParams.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VROverlayIntersectionParams.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VROverlayIntersectionParams.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VROverlayIntersectionParams mallocStack() {
        return VROverlayIntersectionParams.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionParams callocStack() {
        return VROverlayIntersectionParams.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VROverlayIntersectionParams mallocStack(MemoryStack stack) {
        return VROverlayIntersectionParams.malloc(stack);
    }

    @Deprecated
    public static VROverlayIntersectionParams callocStack(MemoryStack stack) {
        return VROverlayIntersectionParams.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VROverlayIntersectionParams.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VROverlayIntersectionParams.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionParams.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VROverlayIntersectionParams.calloc(capacity, stack);
    }

    public static VROverlayIntersectionParams malloc(MemoryStack stack) {
        return VROverlayIntersectionParams.wrap(VROverlayIntersectionParams.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VROverlayIntersectionParams calloc(MemoryStack stack) {
        return VROverlayIntersectionParams.wrap(VROverlayIntersectionParams.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VROverlayIntersectionParams.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VROverlayIntersectionParams.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static HmdVector3 nvSource(long struct) {
        return HmdVector3.create(struct + (long)VSOURCE);
    }

    public static HmdVector3 nvDirection(long struct) {
        return HmdVector3.create(struct + (long)VDIRECTION);
    }

    public static int neOrigin(long struct) {
        return UNSAFE.getInt(null, struct + (long)EORIGIN);
    }

    public static void nvSource(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VSOURCE, HmdVector3.SIZEOF);
    }

    public static void nvDirection(long struct, HmdVector3 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VDIRECTION, HmdVector3.SIZEOF);
    }

    public static void neOrigin(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EORIGIN, value);
    }

    static {
        Struct.Layout layout = VROverlayIntersectionParams.__struct(VROverlayIntersectionParams.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionParams.__member(HmdVector3.SIZEOF, HmdVector3.ALIGNOF), VROverlayIntersectionParams.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VSOURCE = layout.offsetof(0);
        VDIRECTION = layout.offsetof(1);
        EORIGIN = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VROverlayIntersectionParams, Buffer>
    implements NativeResource {
        private static final VROverlayIntersectionParams ELEMENT_FACTORY = VROverlayIntersectionParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VROverlayIntersectionParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vSource() {
            return VROverlayIntersectionParams.nvSource(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vDirection() {
            return VROverlayIntersectionParams.nvDirection(this.address());
        }

        @NativeType(value="ETrackingUniverseOrigin")
        public int eOrigin() {
            return VROverlayIntersectionParams.neOrigin(this.address());
        }

        public Buffer vSource(@NativeType(value="HmdVector3_t") HmdVector3 value) {
            VROverlayIntersectionParams.nvSource(this.address(), value);
            return this;
        }

        public Buffer vSource(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vSource());
            return this;
        }

        public Buffer vDirection(@NativeType(value="HmdVector3_t") HmdVector3 value) {
            VROverlayIntersectionParams.nvDirection(this.address(), value);
            return this;
        }

        public Buffer vDirection(Consumer<HmdVector3> consumer) {
            consumer.accept(this.vDirection());
            return this;
        }

        public Buffer eOrigin(@NativeType(value="ETrackingUniverseOrigin") int value) {
            VROverlayIntersectionParams.neOrigin(this.address(), value);
            return this;
        }
    }
}

