/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Scroll_t")
public class VREventScroll
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XDELTA;
    public static final int YDELTA;
    public static final int UNUSED;
    public static final int VIEWPORTSCALE;

    public VREventScroll(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VREventScroll.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float xdelta() {
        return VREventScroll.nxdelta(this.address());
    }

    public float ydelta() {
        return VREventScroll.nydelta(this.address());
    }

    @NativeType(value="uint32_t")
    public int unused() {
        return VREventScroll.nunused(this.address());
    }

    public float viewportscale() {
        return VREventScroll.nviewportscale(this.address());
    }

    public static VREventScroll create(long address) {
        return VREventScroll.wrap(VREventScroll.class, address);
    }

    @Nullable
    public static VREventScroll createSafe(long address) {
        return address == 0L ? null : VREventScroll.wrap(VREventScroll.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return VREventScroll.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VREventScroll.wrap(Buffer.class, address, capacity);
    }

    public static float nxdelta(long struct) {
        return UNSAFE.getFloat(null, struct + (long)XDELTA);
    }

    public static float nydelta(long struct) {
        return UNSAFE.getFloat(null, struct + (long)YDELTA);
    }

    public static int nunused(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNUSED);
    }

    public static float nviewportscale(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VIEWPORTSCALE);
    }

    static {
        Struct.Layout layout = VREventScroll.__struct(VREventScroll.__member(4), VREventScroll.__member(4), VREventScroll.__member(4), VREventScroll.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XDELTA = layout.offsetof(0);
        YDELTA = layout.offsetof(1);
        UNUSED = layout.offsetof(2);
        VIEWPORTSCALE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VREventScroll, Buffer> {
        private static final VREventScroll ELEMENT_FACTORY = VREventScroll.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VREventScroll getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float xdelta() {
            return VREventScroll.nxdelta(this.address());
        }

        public float ydelta() {
            return VREventScroll.nydelta(this.address());
        }

        @NativeType(value="uint32_t")
        public int unused() {
            return VREventScroll.nunused(this.address());
        }

        public float viewportscale() {
            return VREventScroll.nviewportscale(this.address());
        }
    }
}

