/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Overlay_t")
public class VREventOverlay
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OVERLAYHANDLE;
    public static final int DEVICEPATH;
    public static final int MEMORYBLOCKID;

    public VREventOverlay(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VREventOverlay.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long overlayHandle() {
        return VREventOverlay.noverlayHandle(this.address());
    }

    @NativeType(value="uint64_t")
    public long devicePath() {
        return VREventOverlay.ndevicePath(this.address());
    }

    @NativeType(value="uint64_t")
    public long memoryBlockId() {
        return VREventOverlay.nmemoryBlockId(this.address());
    }

    public static VREventOverlay create(long address) {
        return VREventOverlay.wrap(VREventOverlay.class, address);
    }

    @Nullable
    public static VREventOverlay createSafe(long address) {
        return address == 0L ? null : VREventOverlay.wrap(VREventOverlay.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return VREventOverlay.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VREventOverlay.wrap(Buffer.class, address, capacity);
    }

    public static long noverlayHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)OVERLAYHANDLE);
    }

    public static long ndevicePath(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEVICEPATH);
    }

    public static long nmemoryBlockId(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYBLOCKID);
    }

    static {
        Struct.Layout layout = VREventOverlay.__struct(VREventOverlay.__member(8), VREventOverlay.__member(8), VREventOverlay.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OVERLAYHANDLE = layout.offsetof(0);
        DEVICEPATH = layout.offsetof(1);
        MEMORYBLOCKID = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VREventOverlay, Buffer> {
        private static final VREventOverlay ELEMENT_FACTORY = VREventOverlay.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VREventOverlay getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long overlayHandle() {
            return VREventOverlay.noverlayHandle(this.address());
        }

        @NativeType(value="uint64_t")
        public long devicePath() {
            return VREventOverlay.ndevicePath(this.address());
        }

        @NativeType(value="uint64_t")
        public long memoryBlockId() {
            return VREventOverlay.nmemoryBlockId(this.address());
        }
    }
}

