/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRDriverManager {
    protected VRDriverManager() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="uint32_t")
    public static int VRDriverManager_GetDriverCount() {
        long __functionAddress = OpenVR.VRDriverManager.GetDriverCount;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int nVRDriverManager_GetDriverName(int nDriver, long pchValue, int unBufferSize) {
        long __functionAddress = OpenVR.VRDriverManager.GetDriverName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(nDriver, pchValue, unBufferSize, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRDriverManager_GetDriverName(@NativeType(value="DriverId_t") int nDriver, @Nullable @NativeType(value="char *") ByteBuffer pchValue) {
        return VRDriverManager.nVRDriverManager_GetDriverName(nDriver, MemoryUtil.memAddressSafe(pchValue), Checks.remainingSafe(pchValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRDriverManager_GetDriverName(@NativeType(value="DriverId_t") int nDriver, @NativeType(value="uint32_t") int unBufferSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchValue = stack.malloc(unBufferSize);
            int __result = VRDriverManager.nVRDriverManager_GetDriverName(nDriver, MemoryUtil.memAddress(pchValue), unBufferSize);
            String string = MemoryUtil.memASCII(pchValue, __result - 1);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRDriverManager_GetDriverHandle(long pchDriverName) {
        long __functionAddress = OpenVR.VRDriverManager.GetDriverHandle;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPJ(pchDriverName, __functionAddress);
    }

    @NativeType(value="DriverHandle_t")
    public static long VRDriverManager_GetDriverHandle(@NativeType(value="char const *") ByteBuffer pchDriverName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(pchDriverName);
        }
        return VRDriverManager.nVRDriverManager_GetDriverHandle(MemoryUtil.memAddress(pchDriverName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="DriverHandle_t")
    public static long VRDriverManager_GetDriverHandle(@NativeType(value="char const *") CharSequence pchDriverName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchDriverName, true);
            long pchDriverNameEncoded = stack.getPointerAddress();
            long l = VRDriverManager.nVRDriverManager_GetDriverHandle(pchDriverNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="bool")
    public static boolean VRDriverManager_IsEnabled(@NativeType(value="DriverId_t") int nDriver) {
        long __functionAddress = OpenVR.VRDriverManager.IsEnabled;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callZ(nDriver, __functionAddress);
    }
}

