/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct Texture_t")
public class Texture
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;

    public Texture(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), Texture.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return Texture.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return Texture.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return Texture.neColorSpace(this.address());
    }

    public Texture handle(@NativeType(value="void *") long value) {
        Texture.nhandle(this.address(), value);
        return this;
    }

    public Texture eType(@NativeType(value="ETextureType") int value) {
        Texture.neType(this.address(), value);
        return this;
    }

    public Texture eColorSpace(@NativeType(value="EColorSpace") int value) {
        Texture.neColorSpace(this.address(), value);
        return this;
    }

    public Texture set(long handle, int eType, int eColorSpace) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        return this;
    }

    public Texture set(Texture src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static Texture malloc() {
        return Texture.wrap(Texture.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static Texture calloc() {
        return Texture.wrap(Texture.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static Texture create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return Texture.wrap(Texture.class, MemoryUtil.memAddress(container), container);
    }

    public static Texture create(long address) {
        return Texture.wrap(Texture.class, address);
    }

    @Nullable
    public static Texture createSafe(long address) {
        return address == 0L ? null : Texture.wrap(Texture.class, address);
    }

    public static Buffer malloc(int capacity) {
        return Texture.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(Texture.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return Texture.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = Texture.__create(capacity, SIZEOF);
        return Texture.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return Texture.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : Texture.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static Texture mallocStack() {
        return Texture.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static Texture callocStack() {
        return Texture.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static Texture mallocStack(MemoryStack stack) {
        return Texture.malloc(stack);
    }

    @Deprecated
    public static Texture callocStack(MemoryStack stack) {
        return Texture.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return Texture.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return Texture.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return Texture.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return Texture.calloc(capacity, stack);
    }

    public static Texture malloc(MemoryStack stack) {
        return Texture.wrap(Texture.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static Texture calloc(MemoryStack stack) {
        return Texture.wrap(Texture.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return Texture.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return Texture.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HANDLE);
    }

    public static int neType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ETYPE);
    }

    public static int neColorSpace(long struct) {
        return UNSAFE.getInt(null, struct + (long)ECOLORSPACE);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HANDLE, Checks.check(value));
    }

    public static void neType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ETYPE, value);
    }

    public static void neColorSpace(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ECOLORSPACE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HANDLE));
    }

    static {
        Struct.Layout layout = Texture.__struct(Texture.__member(POINTER_SIZE), Texture.__member(4), Texture.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<Texture, Buffer>
    implements NativeResource {
        private static final Texture ELEMENT_FACTORY = Texture.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Texture getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return Texture.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return Texture.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return Texture.neColorSpace(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            Texture.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            Texture.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            Texture.neColorSpace(this.address(), value);
            return this;
        }
    }
}

