/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.IntBuffer;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.VR;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;

public final class OpenVR {
    @Nullable
    public static IVRSystem VRSystem;
    @Nullable
    public static IVRChaperone VRChaperone;
    @Nullable
    public static IVRChaperoneSetup VRChaperoneSetup;
    @Nullable
    public static IVRCompositor VRCompositor;
    @Nullable
    public static IVRHeadsetView VRHeadsetView;
    @Nullable
    public static IVROverlay VROverlay;
    @Nullable
    public static IVROverlayView VROverlayView;
    @Nullable
    public static IVRResources VRResources;
    @Nullable
    public static IVRRenderModels VRRenderModels;
    @Nullable
    public static IVRExtendedDisplay VRExtendedDisplay;
    @Nullable
    public static IVRSettings VRSettings;
    @Nullable
    public static IVRApplications VRApplications;
    @Nullable
    public static IVRTrackedCamera VRTrackedCamera;
    @Nullable
    public static IVRScreenshots VRScreenshots;
    @Nullable
    public static IVRDriverManager VRDriverManager;
    @Nullable
    public static IVRInput VRInput;
    @Nullable
    public static IVRIOBuffer VRIOBuffer;
    @Nullable
    public static IVRSpatialAnchors VRSpatialAnchors;
    @Nullable
    public static IVRDebug VRDebug;
    @Nullable
    public static IVRNotifications VRNotifications;
    private static int token;

    private OpenVR() {
    }

    static void initialize() {
    }

    public static void create(int token) {
        OpenVR.token = token;
        VRSystem = OpenVR.getGenericInterface("IVRSystem_022", IVRSystem::new);
        VRChaperone = OpenVR.getGenericInterface("IVRChaperone_004", IVRChaperone::new);
        VRChaperoneSetup = OpenVR.getGenericInterface("IVRChaperoneSetup_006", IVRChaperoneSetup::new);
        VRCompositor = OpenVR.getGenericInterface("IVRCompositor_027", IVRCompositor::new);
        VRHeadsetView = OpenVR.getGenericInterface("IVRHeadsetView_001", IVRHeadsetView::new);
        VROverlay = OpenVR.getGenericInterface("IVROverlay_025", IVROverlay::new);
        VROverlayView = OpenVR.getGenericInterface("IVROverlayView_003", IVROverlayView::new);
        VRResources = OpenVR.getGenericInterface("IVRResources_001", IVRResources::new);
        VRRenderModels = OpenVR.getGenericInterface("IVRRenderModels_006", IVRRenderModels::new);
        VRExtendedDisplay = OpenVR.getGenericInterface("IVRExtendedDisplay_001", IVRExtendedDisplay::new);
        VRSettings = OpenVR.getGenericInterface("IVRSettings_003", IVRSettings::new);
        VRApplications = OpenVR.getGenericInterface("IVRApplications_007", IVRApplications::new);
        VRTrackedCamera = OpenVR.getGenericInterface("IVRTrackedCamera_006", IVRTrackedCamera::new);
        VRScreenshots = OpenVR.getGenericInterface("IVRScreenshots_001", IVRScreenshots::new);
        VRDriverManager = OpenVR.getGenericInterface("IVRDriverManager_001", IVRDriverManager::new);
        VRInput = OpenVR.getGenericInterface("IVRInput_010", IVRInput::new);
        VRIOBuffer = OpenVR.getGenericInterface("IVRIOBuffer_002", IVRIOBuffer::new);
        VRSpatialAnchors = OpenVR.getGenericInterface("IVRSpatialAnchors_001", IVRSpatialAnchors::new);
        VRDebug = OpenVR.getGenericInterface("IVRDebug_001", IVRDebug::new);
        VRNotifications = OpenVR.getGenericInterface("IVRNotifications_002", IVRNotifications::new);
    }

    @Nullable
    private static <T> T getGenericInterface(String interfaceNameVersion, LongFunction<T> supplier) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer peError = stack.mallocInt(1);
            long ivr = VR.VR_GetGenericInterface("FnTable:" + interfaceNameVersion, peError);
            T t = ivr != 0L && peError.get(0) == 0 ? (T)supplier.apply(ivr) : null;
            return t;
        }
    }

    public static void checkInitToken() {
        if (token == 0) {
            throw new IllegalStateException("The OpenVR API must be initialized first.");
        }
        int initToken = VR.VR_GetInitToken();
        if (token != initToken) {
            OpenVR.destroy();
            OpenVR.create(initToken);
        }
    }

    public static void destroy() {
        token = 0;
        VRSystem = null;
        VRChaperone = null;
        VRChaperoneSetup = null;
        VRCompositor = null;
        VRHeadsetView = null;
        VROverlay = null;
        VROverlayView = null;
        VRResources = null;
        VRRenderModels = null;
        VRExtendedDisplay = null;
        VRSettings = null;
        VRApplications = null;
        VRTrackedCamera = null;
        VRScreenshots = null;
        VRDriverManager = null;
        VRInput = null;
        VRIOBuffer = null;
        VRSpatialAnchors = null;
        VRDebug = null;
        VRNotifications = null;
    }

    static {
        String libName = Platform.mapLibraryNameBundled("lwjgl_openvr");
        Library.loadSystem(System::load, System::loadLibrary, OpenVR.class, "org.lwjgl.openvr", libName);
    }

    public static final class IVRNotifications {
        public final long CreateNotification;
        public final long RemoveNotification;

        public IVRNotifications(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 2);
            this.CreateNotification = table.get(0);
            this.RemoveNotification = table.get(1);
        }
    }

    public static final class IVRDebug {
        public final long EmitVrProfilerEvent;
        public final long BeginVrProfilerEvent;
        public final long FinishVrProfilerEvent;
        public final long DriverDebugRequest;

        public IVRDebug(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 4);
            this.EmitVrProfilerEvent = table.get(0);
            this.BeginVrProfilerEvent = table.get(1);
            this.FinishVrProfilerEvent = table.get(2);
            this.DriverDebugRequest = table.get(3);
        }
    }

    public static final class IVRSpatialAnchors {
        public final long CreateSpatialAnchorFromDescriptor;
        public final long CreateSpatialAnchorFromPose;
        public final long GetSpatialAnchorPose;
        public final long GetSpatialAnchorDescriptor;

        public IVRSpatialAnchors(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 4);
            this.CreateSpatialAnchorFromDescriptor = table.get(0);
            this.CreateSpatialAnchorFromPose = table.get(1);
            this.GetSpatialAnchorPose = table.get(2);
            this.GetSpatialAnchorDescriptor = table.get(3);
        }
    }

    public static final class IVRIOBuffer {
        public final long Open;
        public final long Close;
        public final long Read;
        public final long Write;
        public final long PropertyContainer;
        public final long HasReaders;

        public IVRIOBuffer(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 6);
            this.Open = table.get(0);
            this.Close = table.get(1);
            this.Read = table.get(2);
            this.Write = table.get(3);
            this.PropertyContainer = table.get(4);
            this.HasReaders = table.get(5);
        }
    }

    public static final class IVRInput {
        public final long SetActionManifestPath;
        public final long GetActionSetHandle;
        public final long GetActionHandle;
        public final long GetInputSourceHandle;
        public final long UpdateActionState;
        public final long GetDigitalActionData;
        public final long GetAnalogActionData;
        public final long GetPoseActionDataRelativeToNow;
        public final long GetPoseActionDataForNextFrame;
        public final long GetSkeletalActionData;
        public final long GetDominantHand;
        public final long SetDominantHand;
        public final long GetBoneCount;
        public final long GetBoneHierarchy;
        public final long GetBoneName;
        public final long GetSkeletalReferenceTransforms;
        public final long GetSkeletalTrackingLevel;
        public final long GetSkeletalBoneData;
        public final long GetSkeletalSummaryData;
        public final long GetSkeletalBoneDataCompressed;
        public final long DecompressSkeletalBoneData;
        public final long TriggerHapticVibrationAction;
        public final long GetActionOrigins;
        public final long GetOriginLocalizedName;
        public final long GetOriginTrackedDeviceInfo;
        public final long GetActionBindingInfo;
        public final long ShowActionOrigins;
        public final long ShowBindingsForActionSet;
        public final long GetComponentStateForBinding;
        public final long OpenBindingUI;
        public final long GetBindingVariant;

        public IVRInput(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 31);
            this.SetActionManifestPath = table.get(0);
            this.GetActionSetHandle = table.get(1);
            this.GetActionHandle = table.get(2);
            this.GetInputSourceHandle = table.get(3);
            this.UpdateActionState = table.get(4);
            this.GetDigitalActionData = table.get(5);
            this.GetAnalogActionData = table.get(6);
            this.GetPoseActionDataRelativeToNow = table.get(7);
            this.GetPoseActionDataForNextFrame = table.get(8);
            this.GetSkeletalActionData = table.get(9);
            this.GetDominantHand = table.get(10);
            this.SetDominantHand = table.get(11);
            this.GetBoneCount = table.get(12);
            this.GetBoneHierarchy = table.get(13);
            this.GetBoneName = table.get(14);
            this.GetSkeletalReferenceTransforms = table.get(15);
            this.GetSkeletalTrackingLevel = table.get(16);
            this.GetSkeletalBoneData = table.get(17);
            this.GetSkeletalSummaryData = table.get(18);
            this.GetSkeletalBoneDataCompressed = table.get(19);
            this.DecompressSkeletalBoneData = table.get(20);
            this.TriggerHapticVibrationAction = table.get(21);
            this.GetActionOrigins = table.get(22);
            this.GetOriginLocalizedName = table.get(23);
            this.GetOriginTrackedDeviceInfo = table.get(24);
            this.GetActionBindingInfo = table.get(25);
            this.ShowActionOrigins = table.get(26);
            this.ShowBindingsForActionSet = table.get(27);
            this.GetComponentStateForBinding = table.get(28);
            this.OpenBindingUI = table.get(29);
            this.GetBindingVariant = table.get(30);
        }
    }

    public static final class IVRDriverManager {
        public final long GetDriverCount;
        public final long GetDriverName;
        public final long GetDriverHandle;
        public final long IsEnabled;

        public IVRDriverManager(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 4);
            this.GetDriverCount = table.get(0);
            this.GetDriverName = table.get(1);
            this.GetDriverHandle = table.get(2);
            this.IsEnabled = table.get(3);
        }
    }

    public static final class IVRScreenshots {
        public final long RequestScreenshot;
        public final long HookScreenshot;
        public final long GetScreenshotPropertyType;
        public final long GetScreenshotPropertyFilename;
        public final long UpdateScreenshotProgress;
        public final long TakeStereoScreenshot;
        public final long SubmitScreenshot;

        public IVRScreenshots(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 7);
            this.RequestScreenshot = table.get(0);
            this.HookScreenshot = table.get(1);
            this.GetScreenshotPropertyType = table.get(2);
            this.GetScreenshotPropertyFilename = table.get(3);
            this.UpdateScreenshotProgress = table.get(4);
            this.TakeStereoScreenshot = table.get(5);
            this.SubmitScreenshot = table.get(6);
        }
    }

    public static final class IVRTrackedCamera {
        public final long GetCameraErrorNameFromEnum;
        public final long HasCamera;
        public final long GetCameraFrameSize;
        public final long GetCameraIntrinsics;
        public final long GetCameraProjection;
        public final long AcquireVideoStreamingService;
        public final long ReleaseVideoStreamingService;
        public final long GetVideoStreamFrameBuffer;
        public final long GetVideoStreamTextureSize;
        public final long GetVideoStreamTextureD3D11;
        public final long GetVideoStreamTextureGL;
        public final long ReleaseVideoStreamTextureGL;
        public final long SetCameraTrackingSpace;
        public final long GetCameraTrackingSpace;

        public IVRTrackedCamera(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 14);
            this.GetCameraErrorNameFromEnum = table.get(0);
            this.HasCamera = table.get(1);
            this.GetCameraFrameSize = table.get(2);
            this.GetCameraIntrinsics = table.get(3);
            this.GetCameraProjection = table.get(4);
            this.AcquireVideoStreamingService = table.get(5);
            this.ReleaseVideoStreamingService = table.get(6);
            this.GetVideoStreamFrameBuffer = table.get(7);
            this.GetVideoStreamTextureSize = table.get(8);
            this.GetVideoStreamTextureD3D11 = table.get(9);
            this.GetVideoStreamTextureGL = table.get(10);
            this.ReleaseVideoStreamTextureGL = table.get(11);
            this.SetCameraTrackingSpace = table.get(12);
            this.GetCameraTrackingSpace = table.get(13);
        }
    }

    public static final class IVRApplications {
        public final long AddApplicationManifest;
        public final long RemoveApplicationManifest;
        public final long IsApplicationInstalled;
        public final long GetApplicationCount;
        public final long GetApplicationKeyByIndex;
        public final long GetApplicationKeyByProcessId;
        public final long LaunchApplication;
        public final long LaunchTemplateApplication;
        public final long LaunchApplicationFromMimeType;
        public final long LaunchDashboardOverlay;
        public final long CancelApplicationLaunch;
        public final long IdentifyApplication;
        public final long GetApplicationProcessId;
        public final long GetApplicationsErrorNameFromEnum;
        public final long GetApplicationPropertyString;
        public final long GetApplicationPropertyBool;
        public final long GetApplicationPropertyUint64;
        public final long SetApplicationAutoLaunch;
        public final long GetApplicationAutoLaunch;
        public final long SetDefaultApplicationForMimeType;
        public final long GetDefaultApplicationForMimeType;
        public final long GetApplicationSupportedMimeTypes;
        public final long GetApplicationsThatSupportMimeType;
        public final long GetApplicationLaunchArguments;
        public final long GetStartingApplication;
        public final long GetSceneApplicationState;
        public final long PerformApplicationPrelaunchCheck;
        public final long GetSceneApplicationStateNameFromEnum;
        public final long LaunchInternalProcess;
        public final long GetCurrentSceneProcessId;

        public IVRApplications(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 30);
            this.AddApplicationManifest = table.get(0);
            this.RemoveApplicationManifest = table.get(1);
            this.IsApplicationInstalled = table.get(2);
            this.GetApplicationCount = table.get(3);
            this.GetApplicationKeyByIndex = table.get(4);
            this.GetApplicationKeyByProcessId = table.get(5);
            this.LaunchApplication = table.get(6);
            this.LaunchTemplateApplication = table.get(7);
            this.LaunchApplicationFromMimeType = table.get(8);
            this.LaunchDashboardOverlay = table.get(9);
            this.CancelApplicationLaunch = table.get(10);
            this.IdentifyApplication = table.get(11);
            this.GetApplicationProcessId = table.get(12);
            this.GetApplicationsErrorNameFromEnum = table.get(13);
            this.GetApplicationPropertyString = table.get(14);
            this.GetApplicationPropertyBool = table.get(15);
            this.GetApplicationPropertyUint64 = table.get(16);
            this.SetApplicationAutoLaunch = table.get(17);
            this.GetApplicationAutoLaunch = table.get(18);
            this.SetDefaultApplicationForMimeType = table.get(19);
            this.GetDefaultApplicationForMimeType = table.get(20);
            this.GetApplicationSupportedMimeTypes = table.get(21);
            this.GetApplicationsThatSupportMimeType = table.get(22);
            this.GetApplicationLaunchArguments = table.get(23);
            this.GetStartingApplication = table.get(24);
            this.GetSceneApplicationState = table.get(25);
            this.PerformApplicationPrelaunchCheck = table.get(26);
            this.GetSceneApplicationStateNameFromEnum = table.get(27);
            this.LaunchInternalProcess = table.get(28);
            this.GetCurrentSceneProcessId = table.get(29);
        }
    }

    public static final class IVRSettings {
        public final long GetSettingsErrorNameFromEnum;
        public final long SetBool;
        public final long SetInt32;
        public final long SetFloat;
        public final long SetString;
        public final long GetBool;
        public final long GetInt32;
        public final long GetFloat;
        public final long GetString;
        public final long RemoveSection;
        public final long RemoveKeyInSection;

        public IVRSettings(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 11);
            this.GetSettingsErrorNameFromEnum = table.get(0);
            this.SetBool = table.get(1);
            this.SetInt32 = table.get(2);
            this.SetFloat = table.get(3);
            this.SetString = table.get(4);
            this.GetBool = table.get(5);
            this.GetInt32 = table.get(6);
            this.GetFloat = table.get(7);
            this.GetString = table.get(8);
            this.RemoveSection = table.get(9);
            this.RemoveKeyInSection = table.get(10);
        }
    }

    public static final class IVRExtendedDisplay {
        public final long GetWindowBounds;
        public final long GetEyeOutputViewport;
        public final long GetDXGIOutputInfo;

        public IVRExtendedDisplay(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 3);
            this.GetWindowBounds = table.get(0);
            this.GetEyeOutputViewport = table.get(1);
            this.GetDXGIOutputInfo = table.get(2);
        }
    }

    public static final class IVRRenderModels {
        public final long LoadRenderModel_Async;
        public final long FreeRenderModel;
        public final long LoadTexture_Async;
        public final long FreeTexture;
        public final long LoadTextureD3D11_Async;
        public final long LoadIntoTextureD3D11_Async;
        public final long FreeTextureD3D11;
        public final long GetRenderModelName;
        public final long GetRenderModelCount;
        public final long GetComponentCount;
        public final long GetComponentName;
        public final long GetComponentButtonMask;
        public final long GetComponentRenderModelName;
        public final long GetComponentStateForDevicePath;
        public final long GetComponentState;
        public final long RenderModelHasComponent;
        public final long GetRenderModelThumbnailURL;
        public final long GetRenderModelOriginalPath;
        public final long GetRenderModelErrorNameFromEnum;

        public IVRRenderModels(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 19);
            this.LoadRenderModel_Async = table.get(0);
            this.FreeRenderModel = table.get(1);
            this.LoadTexture_Async = table.get(2);
            this.FreeTexture = table.get(3);
            this.LoadTextureD3D11_Async = table.get(4);
            this.LoadIntoTextureD3D11_Async = table.get(5);
            this.FreeTextureD3D11 = table.get(6);
            this.GetRenderModelName = table.get(7);
            this.GetRenderModelCount = table.get(8);
            this.GetComponentCount = table.get(9);
            this.GetComponentName = table.get(10);
            this.GetComponentButtonMask = table.get(11);
            this.GetComponentRenderModelName = table.get(12);
            this.GetComponentStateForDevicePath = table.get(13);
            this.GetComponentState = table.get(14);
            this.RenderModelHasComponent = table.get(15);
            this.GetRenderModelThumbnailURL = table.get(16);
            this.GetRenderModelOriginalPath = table.get(17);
            this.GetRenderModelErrorNameFromEnum = table.get(18);
        }
    }

    public static final class IVRResources {
        public final long LoadSharedResource;
        public final long GetResourceFullPath;

        public IVRResources(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 2);
            this.LoadSharedResource = table.get(0);
            this.GetResourceFullPath = table.get(1);
        }
    }

    public static final class IVROverlayView {
        public final long AcquireOverlayView;
        public final long ReleaseOverlayView;
        public final long PostOverlayEvent;
        public final long IsViewingPermitted;

        public IVROverlayView(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 4);
            this.AcquireOverlayView = table.get(0);
            this.ReleaseOverlayView = table.get(1);
            this.PostOverlayEvent = table.get(2);
            this.IsViewingPermitted = table.get(3);
        }
    }

    public static final class IVROverlay {
        public final long FindOverlay;
        public final long CreateOverlay;
        public final long DestroyOverlay;
        public final long GetOverlayKey;
        public final long GetOverlayName;
        public final long SetOverlayName;
        public final long GetOverlayImageData;
        public final long GetOverlayErrorNameFromEnum;
        public final long SetOverlayRenderingPid;
        public final long GetOverlayRenderingPid;
        public final long SetOverlayFlag;
        public final long GetOverlayFlag;
        public final long GetOverlayFlags;
        public final long SetOverlayColor;
        public final long GetOverlayColor;
        public final long SetOverlayAlpha;
        public final long GetOverlayAlpha;
        public final long SetOverlayTexelAspect;
        public final long GetOverlayTexelAspect;
        public final long SetOverlaySortOrder;
        public final long GetOverlaySortOrder;
        public final long SetOverlayWidthInMeters;
        public final long GetOverlayWidthInMeters;
        public final long SetOverlayCurvature;
        public final long GetOverlayCurvature;
        public final long SetOverlayTextureColorSpace;
        public final long GetOverlayTextureColorSpace;
        public final long SetOverlayTextureBounds;
        public final long GetOverlayTextureBounds;
        public final long GetOverlayTransformType;
        public final long SetOverlayTransformAbsolute;
        public final long GetOverlayTransformAbsolute;
        public final long SetOverlayTransformTrackedDeviceRelative;
        public final long GetOverlayTransformTrackedDeviceRelative;
        public final long SetOverlayTransformTrackedDeviceComponent;
        public final long GetOverlayTransformTrackedDeviceComponent;
        public final long GetOverlayTransformOverlayRelative;
        public final long SetOverlayTransformOverlayRelative;
        public final long SetOverlayTransformCursor;
        public final long GetOverlayTransformCursor;
        public final long SetOverlayTransformProjection;
        public final long ShowOverlay;
        public final long HideOverlay;
        public final long IsOverlayVisible;
        public final long GetTransformForOverlayCoordinates;
        public final long PollNextOverlayEvent;
        public final long GetOverlayInputMethod;
        public final long SetOverlayInputMethod;
        public final long GetOverlayMouseScale;
        public final long SetOverlayMouseScale;
        public final long ComputeOverlayIntersection;
        public final long IsHoverTargetOverlay;
        public final long SetOverlayIntersectionMask;
        public final long TriggerLaserMouseHapticVibration;
        public final long SetOverlayCursor;
        public final long SetOverlayCursorPositionOverride;
        public final long ClearOverlayCursorPositionOverride;
        public final long SetOverlayTexture;
        public final long ClearOverlayTexture;
        public final long SetOverlayRaw;
        public final long SetOverlayFromFile;
        public final long GetOverlayTexture;
        public final long ReleaseNativeOverlayHandle;
        public final long GetOverlayTextureSize;
        public final long CreateDashboardOverlay;
        public final long IsDashboardVisible;
        public final long IsActiveDashboardOverlay;
        public final long SetDashboardOverlaySceneProcess;
        public final long GetDashboardOverlaySceneProcess;
        public final long ShowDashboard;
        public final long GetPrimaryDashboardDevice;
        public final long ShowKeyboard;
        public final long ShowKeyboardForOverlay;
        public final long GetKeyboardText;
        public final long HideKeyboard;
        public final long SetKeyboardTransformAbsolute;
        public final long SetKeyboardPositionForOverlay;
        public final long ShowMessageOverlay;
        public final long CloseMessageOverlay;

        public IVROverlay(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 79);
            this.FindOverlay = table.get(0);
            this.CreateOverlay = table.get(1);
            this.DestroyOverlay = table.get(2);
            this.GetOverlayKey = table.get(3);
            this.GetOverlayName = table.get(4);
            this.SetOverlayName = table.get(5);
            this.GetOverlayImageData = table.get(6);
            this.GetOverlayErrorNameFromEnum = table.get(7);
            this.SetOverlayRenderingPid = table.get(8);
            this.GetOverlayRenderingPid = table.get(9);
            this.SetOverlayFlag = table.get(10);
            this.GetOverlayFlag = table.get(11);
            this.GetOverlayFlags = table.get(12);
            this.SetOverlayColor = table.get(13);
            this.GetOverlayColor = table.get(14);
            this.SetOverlayAlpha = table.get(15);
            this.GetOverlayAlpha = table.get(16);
            this.SetOverlayTexelAspect = table.get(17);
            this.GetOverlayTexelAspect = table.get(18);
            this.SetOverlaySortOrder = table.get(19);
            this.GetOverlaySortOrder = table.get(20);
            this.SetOverlayWidthInMeters = table.get(21);
            this.GetOverlayWidthInMeters = table.get(22);
            this.SetOverlayCurvature = table.get(23);
            this.GetOverlayCurvature = table.get(24);
            this.SetOverlayTextureColorSpace = table.get(25);
            this.GetOverlayTextureColorSpace = table.get(26);
            this.SetOverlayTextureBounds = table.get(27);
            this.GetOverlayTextureBounds = table.get(28);
            this.GetOverlayTransformType = table.get(29);
            this.SetOverlayTransformAbsolute = table.get(30);
            this.GetOverlayTransformAbsolute = table.get(31);
            this.SetOverlayTransformTrackedDeviceRelative = table.get(32);
            this.GetOverlayTransformTrackedDeviceRelative = table.get(33);
            this.SetOverlayTransformTrackedDeviceComponent = table.get(34);
            this.GetOverlayTransformTrackedDeviceComponent = table.get(35);
            this.GetOverlayTransformOverlayRelative = table.get(36);
            this.SetOverlayTransformOverlayRelative = table.get(37);
            this.SetOverlayTransformCursor = table.get(38);
            this.GetOverlayTransformCursor = table.get(39);
            this.SetOverlayTransformProjection = table.get(40);
            this.ShowOverlay = table.get(41);
            this.HideOverlay = table.get(42);
            this.IsOverlayVisible = table.get(43);
            this.GetTransformForOverlayCoordinates = table.get(44);
            this.PollNextOverlayEvent = table.get(45);
            this.GetOverlayInputMethod = table.get(46);
            this.SetOverlayInputMethod = table.get(47);
            this.GetOverlayMouseScale = table.get(48);
            this.SetOverlayMouseScale = table.get(49);
            this.ComputeOverlayIntersection = table.get(50);
            this.IsHoverTargetOverlay = table.get(51);
            this.SetOverlayIntersectionMask = table.get(52);
            this.TriggerLaserMouseHapticVibration = table.get(53);
            this.SetOverlayCursor = table.get(54);
            this.SetOverlayCursorPositionOverride = table.get(55);
            this.ClearOverlayCursorPositionOverride = table.get(56);
            this.SetOverlayTexture = table.get(57);
            this.ClearOverlayTexture = table.get(58);
            this.SetOverlayRaw = table.get(59);
            this.SetOverlayFromFile = table.get(60);
            this.GetOverlayTexture = table.get(61);
            this.ReleaseNativeOverlayHandle = table.get(62);
            this.GetOverlayTextureSize = table.get(63);
            this.CreateDashboardOverlay = table.get(64);
            this.IsDashboardVisible = table.get(65);
            this.IsActiveDashboardOverlay = table.get(66);
            this.SetDashboardOverlaySceneProcess = table.get(67);
            this.GetDashboardOverlaySceneProcess = table.get(68);
            this.ShowDashboard = table.get(69);
            this.GetPrimaryDashboardDevice = table.get(70);
            this.ShowKeyboard = table.get(71);
            this.ShowKeyboardForOverlay = table.get(72);
            this.GetKeyboardText = table.get(73);
            this.HideKeyboard = table.get(74);
            this.SetKeyboardTransformAbsolute = table.get(75);
            this.SetKeyboardPositionForOverlay = table.get(76);
            this.ShowMessageOverlay = table.get(77);
            this.CloseMessageOverlay = table.get(78);
        }
    }

    public static final class IVRHeadsetView {
        public final long SetHeadsetViewSize;
        public final long GetHeadsetViewSize;
        public final long SetHeadsetViewMode;
        public final long GetHeadsetViewMode;
        public final long SetHeadsetViewCropped;
        public final long GetHeadsetViewCropped;
        public final long GetHeadsetViewAspectRatio;
        public final long SetHeadsetViewBlendRange;
        public final long GetHeadsetViewBlendRange;

        public IVRHeadsetView(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 9);
            this.SetHeadsetViewSize = table.get(0);
            this.GetHeadsetViewSize = table.get(1);
            this.SetHeadsetViewMode = table.get(2);
            this.GetHeadsetViewMode = table.get(3);
            this.SetHeadsetViewCropped = table.get(4);
            this.GetHeadsetViewCropped = table.get(5);
            this.GetHeadsetViewAspectRatio = table.get(6);
            this.SetHeadsetViewBlendRange = table.get(7);
            this.GetHeadsetViewBlendRange = table.get(8);
        }
    }

    public static final class IVRCompositor {
        public final long SetTrackingSpace;
        public final long GetTrackingSpace;
        public final long WaitGetPoses;
        public final long GetLastPoses;
        public final long GetLastPoseForTrackedDeviceIndex;
        public final long Submit;
        public final long ClearLastSubmittedFrame;
        public final long PostPresentHandoff;
        public final long GetFrameTiming;
        public final long GetFrameTimings;
        public final long GetFrameTimeRemaining;
        public final long GetCumulativeStats;
        public final long FadeToColor;
        public final long GetCurrentFadeColor;
        public final long FadeGrid;
        public final long GetCurrentGridAlpha;
        public final long SetSkyboxOverride;
        public final long ClearSkyboxOverride;
        public final long CompositorBringToFront;
        public final long CompositorGoToBack;
        public final long CompositorQuit;
        public final long IsFullscreen;
        public final long GetCurrentSceneFocusProcess;
        public final long GetLastFrameRenderer;
        public final long CanRenderScene;
        public final long ShowMirrorWindow;
        public final long HideMirrorWindow;
        public final long IsMirrorWindowVisible;
        public final long CompositorDumpImages;
        public final long ShouldAppRenderWithLowResources;
        public final long ForceInterleavedReprojectionOn;
        public final long ForceReconnectProcess;
        public final long SuspendRendering;
        public final long GetMirrorTextureD3D11;
        public final long ReleaseMirrorTextureD3D11;
        public final long GetMirrorTextureGL;
        public final long ReleaseSharedGLTexture;
        public final long LockGLSharedTextureForAccess;
        public final long UnlockGLSharedTextureForAccess;
        public final long GetVulkanInstanceExtensionsRequired;
        public final long GetVulkanDeviceExtensionsRequired;
        public final long SetExplicitTimingMode;
        public final long SubmitExplicitTimingData;
        public final long IsMotionSmoothingEnabled;
        public final long IsMotionSmoothingSupported;
        public final long IsCurrentSceneFocusAppLoading;
        public final long SetStageOverride_Async;
        public final long ClearStageOverride;
        public final long GetCompositorBenchmarkResults;
        public final long GetLastPosePredictionIDs;
        public final long GetPosesForFrame;

        public IVRCompositor(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 51);
            this.SetTrackingSpace = table.get(0);
            this.GetTrackingSpace = table.get(1);
            this.WaitGetPoses = table.get(2);
            this.GetLastPoses = table.get(3);
            this.GetLastPoseForTrackedDeviceIndex = table.get(4);
            this.Submit = table.get(5);
            this.ClearLastSubmittedFrame = table.get(6);
            this.PostPresentHandoff = table.get(7);
            this.GetFrameTiming = table.get(8);
            this.GetFrameTimings = table.get(9);
            this.GetFrameTimeRemaining = table.get(10);
            this.GetCumulativeStats = table.get(11);
            this.FadeToColor = table.get(12);
            this.GetCurrentFadeColor = table.get(13);
            this.FadeGrid = table.get(14);
            this.GetCurrentGridAlpha = table.get(15);
            this.SetSkyboxOverride = table.get(16);
            this.ClearSkyboxOverride = table.get(17);
            this.CompositorBringToFront = table.get(18);
            this.CompositorGoToBack = table.get(19);
            this.CompositorQuit = table.get(20);
            this.IsFullscreen = table.get(21);
            this.GetCurrentSceneFocusProcess = table.get(22);
            this.GetLastFrameRenderer = table.get(23);
            this.CanRenderScene = table.get(24);
            this.ShowMirrorWindow = table.get(25);
            this.HideMirrorWindow = table.get(26);
            this.IsMirrorWindowVisible = table.get(27);
            this.CompositorDumpImages = table.get(28);
            this.ShouldAppRenderWithLowResources = table.get(29);
            this.ForceInterleavedReprojectionOn = table.get(30);
            this.ForceReconnectProcess = table.get(31);
            this.SuspendRendering = table.get(32);
            this.GetMirrorTextureD3D11 = table.get(33);
            this.ReleaseMirrorTextureD3D11 = table.get(34);
            this.GetMirrorTextureGL = table.get(35);
            this.ReleaseSharedGLTexture = table.get(36);
            this.LockGLSharedTextureForAccess = table.get(37);
            this.UnlockGLSharedTextureForAccess = table.get(38);
            this.GetVulkanInstanceExtensionsRequired = table.get(39);
            this.GetVulkanDeviceExtensionsRequired = table.get(40);
            this.SetExplicitTimingMode = table.get(41);
            this.SubmitExplicitTimingData = table.get(42);
            this.IsMotionSmoothingEnabled = table.get(43);
            this.IsMotionSmoothingSupported = table.get(44);
            this.IsCurrentSceneFocusAppLoading = table.get(45);
            this.SetStageOverride_Async = table.get(46);
            this.ClearStageOverride = table.get(47);
            this.GetCompositorBenchmarkResults = table.get(48);
            this.GetLastPosePredictionIDs = table.get(49);
            this.GetPosesForFrame = table.get(50);
        }
    }

    public static final class IVRChaperoneSetup {
        public final long CommitWorkingCopy;
        public final long RevertWorkingCopy;
        public final long GetWorkingPlayAreaSize;
        public final long GetWorkingPlayAreaRect;
        public final long GetWorkingCollisionBoundsInfo;
        public final long GetLiveCollisionBoundsInfo;
        public final long GetWorkingSeatedZeroPoseToRawTrackingPose;
        public final long GetWorkingStandingZeroPoseToRawTrackingPose;
        public final long SetWorkingPlayAreaSize;
        public final long SetWorkingCollisionBoundsInfo;
        public final long SetWorkingPerimeter;
        public final long SetWorkingSeatedZeroPoseToRawTrackingPose;
        public final long SetWorkingStandingZeroPoseToRawTrackingPose;
        public final long ReloadFromDisk;
        public final long GetLiveSeatedZeroPoseToRawTrackingPose;
        public final long ExportLiveToBuffer;
        public final long ImportFromBufferToWorking;
        public final long ShowWorkingSetPreview;
        public final long HideWorkingSetPreview;
        public final long RoomSetupStarting;

        public IVRChaperoneSetup(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 20);
            this.CommitWorkingCopy = table.get(0);
            this.RevertWorkingCopy = table.get(1);
            this.GetWorkingPlayAreaSize = table.get(2);
            this.GetWorkingPlayAreaRect = table.get(3);
            this.GetWorkingCollisionBoundsInfo = table.get(4);
            this.GetLiveCollisionBoundsInfo = table.get(5);
            this.GetWorkingSeatedZeroPoseToRawTrackingPose = table.get(6);
            this.GetWorkingStandingZeroPoseToRawTrackingPose = table.get(7);
            this.SetWorkingPlayAreaSize = table.get(8);
            this.SetWorkingCollisionBoundsInfo = table.get(9);
            this.SetWorkingPerimeter = table.get(10);
            this.SetWorkingSeatedZeroPoseToRawTrackingPose = table.get(11);
            this.SetWorkingStandingZeroPoseToRawTrackingPose = table.get(12);
            this.ReloadFromDisk = table.get(13);
            this.GetLiveSeatedZeroPoseToRawTrackingPose = table.get(14);
            this.ExportLiveToBuffer = table.get(15);
            this.ImportFromBufferToWorking = table.get(16);
            this.ShowWorkingSetPreview = table.get(17);
            this.HideWorkingSetPreview = table.get(18);
            this.RoomSetupStarting = table.get(19);
        }
    }

    public static final class IVRChaperone {
        public final long GetCalibrationState;
        public final long GetPlayAreaSize;
        public final long GetPlayAreaRect;
        public final long ReloadInfo;
        public final long SetSceneColor;
        public final long GetBoundsColor;
        public final long AreBoundsVisible;
        public final long ForceBoundsVisible;
        public final long ResetZeroPose;

        public IVRChaperone(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 9);
            this.GetCalibrationState = table.get(0);
            this.GetPlayAreaSize = table.get(1);
            this.GetPlayAreaRect = table.get(2);
            this.ReloadInfo = table.get(3);
            this.SetSceneColor = table.get(4);
            this.GetBoundsColor = table.get(5);
            this.AreBoundsVisible = table.get(6);
            this.ForceBoundsVisible = table.get(7);
            this.ResetZeroPose = table.get(8);
        }
    }

    public static final class IVRSystem {
        public final long GetRecommendedRenderTargetSize;
        public final long GetProjectionMatrix;
        public final long GetProjectionRaw;
        public final long ComputeDistortion;
        public final long GetEyeToHeadTransform;
        public final long GetTimeSinceLastVsync;
        public final long GetD3D9AdapterIndex;
        public final long GetDXGIOutputInfo;
        public final long GetOutputDevice;
        public final long IsDisplayOnDesktop;
        public final long SetDisplayVisibility;
        public final long GetDeviceToAbsoluteTrackingPose;
        public final long GetSeatedZeroPoseToStandingAbsoluteTrackingPose;
        public final long GetRawZeroPoseToStandingAbsoluteTrackingPose;
        public final long GetSortedTrackedDeviceIndicesOfClass;
        public final long GetTrackedDeviceActivityLevel;
        public final long ApplyTransform;
        public final long GetTrackedDeviceIndexForControllerRole;
        public final long GetControllerRoleForTrackedDeviceIndex;
        public final long GetTrackedDeviceClass;
        public final long IsTrackedDeviceConnected;
        public final long GetBoolTrackedDeviceProperty;
        public final long GetFloatTrackedDeviceProperty;
        public final long GetInt32TrackedDeviceProperty;
        public final long GetUint64TrackedDeviceProperty;
        public final long GetMatrix34TrackedDeviceProperty;
        public final long GetArrayTrackedDeviceProperty;
        public final long GetStringTrackedDeviceProperty;
        public final long GetPropErrorNameFromEnum;
        public final long PollNextEvent;
        public final long PollNextEventWithPose;
        public final long GetEventTypeNameFromEnum;
        public final long GetHiddenAreaMesh;
        public final long GetControllerState;
        public final long GetControllerStateWithPose;
        public final long TriggerHapticPulse;
        public final long GetButtonIdNameFromEnum;
        public final long GetControllerAxisTypeNameFromEnum;
        public final long IsInputAvailable;
        public final long IsSteamVRDrawingControllers;
        public final long ShouldApplicationPause;
        public final long ShouldApplicationReduceRenderingWork;
        public final long PerformFirmwareUpdate;
        public final long AcknowledgeQuit_Exiting;
        public final long GetAppContainerFilePaths;
        public final long GetRuntimeVersion;

        public IVRSystem(long tableAddress) {
            PointerBuffer table = MemoryUtil.memPointerBuffer(tableAddress, 46);
            this.GetRecommendedRenderTargetSize = table.get(0);
            this.GetProjectionMatrix = table.get(1);
            this.GetProjectionRaw = table.get(2);
            this.ComputeDistortion = table.get(3);
            this.GetEyeToHeadTransform = table.get(4);
            this.GetTimeSinceLastVsync = table.get(5);
            this.GetD3D9AdapterIndex = table.get(6);
            this.GetDXGIOutputInfo = table.get(7);
            this.GetOutputDevice = table.get(8);
            this.IsDisplayOnDesktop = table.get(9);
            this.SetDisplayVisibility = table.get(10);
            this.GetDeviceToAbsoluteTrackingPose = table.get(11);
            this.GetSeatedZeroPoseToStandingAbsoluteTrackingPose = table.get(12);
            this.GetRawZeroPoseToStandingAbsoluteTrackingPose = table.get(13);
            this.GetSortedTrackedDeviceIndicesOfClass = table.get(14);
            this.GetTrackedDeviceActivityLevel = table.get(15);
            this.ApplyTransform = table.get(16);
            this.GetTrackedDeviceIndexForControllerRole = table.get(17);
            this.GetControllerRoleForTrackedDeviceIndex = table.get(18);
            this.GetTrackedDeviceClass = table.get(19);
            this.IsTrackedDeviceConnected = table.get(20);
            this.GetBoolTrackedDeviceProperty = table.get(21);
            this.GetFloatTrackedDeviceProperty = table.get(22);
            this.GetInt32TrackedDeviceProperty = table.get(23);
            this.GetUint64TrackedDeviceProperty = table.get(24);
            this.GetMatrix34TrackedDeviceProperty = table.get(25);
            this.GetArrayTrackedDeviceProperty = table.get(26);
            this.GetStringTrackedDeviceProperty = table.get(27);
            this.GetPropErrorNameFromEnum = table.get(28);
            this.PollNextEvent = table.get(29);
            this.PollNextEventWithPose = table.get(30);
            this.GetEventTypeNameFromEnum = table.get(31);
            this.GetHiddenAreaMesh = table.get(32);
            this.GetControllerState = table.get(33);
            this.GetControllerStateWithPose = table.get(34);
            this.TriggerHapticPulse = table.get(35);
            this.GetButtonIdNameFromEnum = table.get(36);
            this.GetControllerAxisTypeNameFromEnum = table.get(37);
            this.IsInputAvailable = table.get(38);
            this.IsSteamVRDrawingControllers = table.get(39);
            this.ShouldApplicationPause = table.get(40);
            this.ShouldApplicationReduceRenderingWork = table.get(41);
            this.PerformFirmwareUpdate = table.get(42);
            this.AcknowledgeQuit_Exiting = table.get(43);
            this.GetAppContainerFilePaths = table.get(44);
            this.GetRuntimeVersion = table.get(45);
        }
    }
}

