/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputSkeletalActionData_t")
public class InputSkeletalActionData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACTIVE;
    public static final int ACTIVEORIGIN;

    public InputSkeletalActionData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), InputSkeletalActionData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean bActive() {
        return InputSkeletalActionData.nbActive(this.address());
    }

    @NativeType(value="VRInputValueHandle_t")
    public long activeOrigin() {
        return InputSkeletalActionData.nactiveOrigin(this.address());
    }

    public static InputSkeletalActionData malloc() {
        return InputSkeletalActionData.wrap(InputSkeletalActionData.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static InputSkeletalActionData calloc() {
        return InputSkeletalActionData.wrap(InputSkeletalActionData.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static InputSkeletalActionData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return InputSkeletalActionData.wrap(InputSkeletalActionData.class, MemoryUtil.memAddress(container), container);
    }

    public static InputSkeletalActionData create(long address) {
        return InputSkeletalActionData.wrap(InputSkeletalActionData.class, address);
    }

    @Nullable
    public static InputSkeletalActionData createSafe(long address) {
        return address == 0L ? null : InputSkeletalActionData.wrap(InputSkeletalActionData.class, address);
    }

    public static Buffer malloc(int capacity) {
        return InputSkeletalActionData.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(InputSkeletalActionData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return InputSkeletalActionData.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputSkeletalActionData.__create(capacity, SIZEOF);
        return InputSkeletalActionData.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return InputSkeletalActionData.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : InputSkeletalActionData.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static InputSkeletalActionData mallocStack() {
        return InputSkeletalActionData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputSkeletalActionData callocStack() {
        return InputSkeletalActionData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static InputSkeletalActionData mallocStack(MemoryStack stack) {
        return InputSkeletalActionData.malloc(stack);
    }

    @Deprecated
    public static InputSkeletalActionData callocStack(MemoryStack stack) {
        return InputSkeletalActionData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return InputSkeletalActionData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return InputSkeletalActionData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.calloc(capacity, stack);
    }

    public static InputSkeletalActionData malloc(MemoryStack stack) {
        return InputSkeletalActionData.wrap(InputSkeletalActionData.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputSkeletalActionData calloc(MemoryStack stack) {
        return InputSkeletalActionData.wrap(InputSkeletalActionData.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return InputSkeletalActionData.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nbActive(long struct) {
        return UNSAFE.getByte(null, struct + (long)BACTIVE) != 0;
    }

    public static long nactiveOrigin(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACTIVEORIGIN);
    }

    static {
        Struct.Layout layout = InputSkeletalActionData.__struct(InputSkeletalActionData.__member(1), InputSkeletalActionData.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACTIVE = layout.offsetof(0);
        ACTIVEORIGIN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<InputSkeletalActionData, Buffer>
    implements NativeResource {
        private static final InputSkeletalActionData ELEMENT_FACTORY = InputSkeletalActionData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected InputSkeletalActionData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean bActive() {
            return InputSkeletalActionData.nbActive(this.address());
        }

        @NativeType(value="VRInputValueHandle_t")
        public long activeOrigin() {
            return InputSkeletalActionData.nactiveOrigin(this.address());
        }
    }
}

