/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdVector3d_t")
public class HmdVector3d
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    public HmdVector3d(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdVector3d.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="double[3]")
    public DoubleBuffer v() {
        return HmdVector3d.nv(this.address());
    }

    public double v(int index) {
        return HmdVector3d.nv(this.address(), index);
    }

    public HmdVector3d v(@NativeType(value="double[3]") DoubleBuffer value) {
        HmdVector3d.nv(this.address(), value);
        return this;
    }

    public HmdVector3d v(int index, double value) {
        HmdVector3d.nv(this.address(), index, value);
        return this;
    }

    public HmdVector3d set(HmdVector3d src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdVector3d malloc() {
        return HmdVector3d.wrap(HmdVector3d.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdVector3d calloc() {
        return HmdVector3d.wrap(HmdVector3d.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdVector3d create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return HmdVector3d.wrap(HmdVector3d.class, MemoryUtil.memAddress(container), container);
    }

    public static HmdVector3d create(long address) {
        return HmdVector3d.wrap(HmdVector3d.class, address);
    }

    @Nullable
    public static HmdVector3d createSafe(long address) {
        return address == 0L ? null : HmdVector3d.wrap(HmdVector3d.class, address);
    }

    public static Buffer malloc(int capacity) {
        return HmdVector3d.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(HmdVector3d.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdVector3d.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdVector3d.__create(capacity, SIZEOF);
        return HmdVector3d.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return HmdVector3d.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdVector3d.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static HmdVector3d mallocStack() {
        return HmdVector3d.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector3d callocStack() {
        return HmdVector3d.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector3d mallocStack(MemoryStack stack) {
        return HmdVector3d.malloc(stack);
    }

    @Deprecated
    public static HmdVector3d callocStack(MemoryStack stack) {
        return HmdVector3d.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdVector3d.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdVector3d.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector3d.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector3d.calloc(capacity, stack);
    }

    public static HmdVector3d malloc(MemoryStack stack) {
        return HmdVector3d.wrap(HmdVector3d.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdVector3d calloc(MemoryStack stack) {
        return HmdVector3d.wrap(HmdVector3d.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return HmdVector3d.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return HmdVector3d.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static DoubleBuffer nv(long struct) {
        return MemoryUtil.memDoubleBuffer(struct + (long)V, 3);
    }

    public static double nv(long struct, int index) {
        return UNSAFE.getDouble(null, struct + (long)V + Checks.check(index, 3) * 8L);
    }

    public static void nv(long struct, DoubleBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)V, value.remaining() * 8);
    }

    public static void nv(long struct, int index, double value) {
        UNSAFE.putDouble(null, struct + (long)V + Checks.check(index, 3) * 8L, value);
    }

    static {
        Struct.Layout layout = HmdVector3d.__struct(HmdVector3d.__array(8, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector3d, Buffer>
    implements NativeResource {
        private static final HmdVector3d ELEMENT_FACTORY = HmdVector3d.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected HmdVector3d getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="double[3]")
        public DoubleBuffer v() {
            return HmdVector3d.nv(this.address());
        }

        public double v(int index) {
            return HmdVector3d.nv(this.address(), index);
        }

        public Buffer v(@NativeType(value="double[3]") DoubleBuffer value) {
            HmdVector3d.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, double value) {
            HmdVector3d.nv(this.address(), index, value);
            return this;
        }
    }
}

