/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct HmdVector3_t")
public class HmdVector3
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int V;

    public HmdVector3(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), HmdVector3.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[3]")
    public FloatBuffer v() {
        return HmdVector3.nv(this.address());
    }

    public float v(int index) {
        return HmdVector3.nv(this.address(), index);
    }

    public HmdVector3 v(@NativeType(value="float[3]") FloatBuffer value) {
        HmdVector3.nv(this.address(), value);
        return this;
    }

    public HmdVector3 v(int index, float value) {
        HmdVector3.nv(this.address(), index, value);
        return this;
    }

    public HmdVector3 set(HmdVector3 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static HmdVector3 malloc() {
        return HmdVector3.wrap(HmdVector3.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static HmdVector3 calloc() {
        return HmdVector3.wrap(HmdVector3.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static HmdVector3 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return HmdVector3.wrap(HmdVector3.class, MemoryUtil.memAddress(container), container);
    }

    public static HmdVector3 create(long address) {
        return HmdVector3.wrap(HmdVector3.class, address);
    }

    @Nullable
    public static HmdVector3 createSafe(long address) {
        return address == 0L ? null : HmdVector3.wrap(HmdVector3.class, address);
    }

    public static Buffer malloc(int capacity) {
        return HmdVector3.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(HmdVector3.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return HmdVector3.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = HmdVector3.__create(capacity, SIZEOF);
        return HmdVector3.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return HmdVector3.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : HmdVector3.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static HmdVector3 mallocStack() {
        return HmdVector3.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector3 callocStack() {
        return HmdVector3.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HmdVector3 mallocStack(MemoryStack stack) {
        return HmdVector3.malloc(stack);
    }

    @Deprecated
    public static HmdVector3 callocStack(MemoryStack stack) {
        return HmdVector3.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return HmdVector3.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return HmdVector3.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return HmdVector3.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return HmdVector3.calloc(capacity, stack);
    }

    public static HmdVector3 malloc(MemoryStack stack) {
        return HmdVector3.wrap(HmdVector3.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static HmdVector3 calloc(MemoryStack stack) {
        return HmdVector3.wrap(HmdVector3.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return HmdVector3.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return HmdVector3.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nv(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)V, 3);
    }

    public static float nv(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)V + Checks.check(index, 3) * 4L);
    }

    public static void nv(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)V, value.remaining() * 4);
    }

    public static void nv(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)V + Checks.check(index, 3) * 4L, value);
    }

    static {
        Struct.Layout layout = HmdVector3.__struct(HmdVector3.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        V = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<HmdVector3, Buffer>
    implements NativeResource {
        private static final HmdVector3 ELEMENT_FACTORY = HmdVector3.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected HmdVector3 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[3]")
        public FloatBuffer v() {
            return HmdVector3.nv(this.address());
        }

        public float v(int index) {
            return HmdVector3.nv(this.address(), index);
        }

        public Buffer v(@NativeType(value="float[3]") FloatBuffer value) {
            HmdVector3.nv(this.address(), value);
            return this;
        }

        public Buffer v(int index, float value) {
            HmdVector3.nv(this.address(), index, value);
            return this;
        }
    }
}

