/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct DriverDirectMode_FrameTiming")
public class DriverDirectModeFrameTiming
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NSIZE;
    public static final int M_NNUMFRAMEPRESENTS;
    public static final int M_NNUMMISPRESENTED;
    public static final int M_NNUMDROPPEDFRAMES;
    public static final int M_NREPROJECTIONFLAGS;

    public DriverDirectModeFrameTiming(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), DriverDirectModeFrameTiming.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int m_nSize() {
        return DriverDirectModeFrameTiming.nm_nSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumFramePresents() {
        return DriverDirectModeFrameTiming.nm_nNumFramePresents(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumMisPresented() {
        return DriverDirectModeFrameTiming.nm_nNumMisPresented(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumDroppedFrames() {
        return DriverDirectModeFrameTiming.nm_nNumDroppedFrames(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nReprojectionFlags() {
        return DriverDirectModeFrameTiming.nm_nReprojectionFlags(this.address());
    }

    public static DriverDirectModeFrameTiming create(long address) {
        return DriverDirectModeFrameTiming.wrap(DriverDirectModeFrameTiming.class, address);
    }

    @Nullable
    public static DriverDirectModeFrameTiming createSafe(long address) {
        return address == 0L ? null : DriverDirectModeFrameTiming.wrap(DriverDirectModeFrameTiming.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return DriverDirectModeFrameTiming.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : DriverDirectModeFrameTiming.wrap(Buffer.class, address, capacity);
    }

    public static int nm_nSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NSIZE);
    }

    public static int nm_nNumFramePresents(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMFRAMEPRESENTS);
    }

    public static int nm_nNumMisPresented(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMMISPRESENTED);
    }

    public static int nm_nNumDroppedFrames(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMDROPPEDFRAMES);
    }

    public static int nm_nReprojectionFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NREPROJECTIONFLAGS);
    }

    static {
        Struct.Layout layout = DriverDirectModeFrameTiming.__struct(DriverDirectModeFrameTiming.__member(4), DriverDirectModeFrameTiming.__member(4), DriverDirectModeFrameTiming.__member(4), DriverDirectModeFrameTiming.__member(4), DriverDirectModeFrameTiming.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NSIZE = layout.offsetof(0);
        M_NNUMFRAMEPRESENTS = layout.offsetof(1);
        M_NNUMMISPRESENTED = layout.offsetof(2);
        M_NNUMDROPPEDFRAMES = layout.offsetof(3);
        M_NREPROJECTIONFLAGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<DriverDirectModeFrameTiming, Buffer> {
        private static final DriverDirectModeFrameTiming ELEMENT_FACTORY = DriverDirectModeFrameTiming.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected DriverDirectModeFrameTiming getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int m_nSize() {
            return DriverDirectModeFrameTiming.nm_nSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumFramePresents() {
            return DriverDirectModeFrameTiming.nm_nNumFramePresents(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumMisPresented() {
            return DriverDirectModeFrameTiming.nm_nNumMisPresented(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumDroppedFrames() {
            return DriverDirectModeFrameTiming.nm_nNumDroppedFrames(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nReprojectionFlags() {
            return DriverDirectModeFrameTiming.nm_nReprojectionFlags(this.address());
        }
    }
}

