/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CameraVideoStreamFrameHeader_t")
public class CameraVideoStreamFrameHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EFRAMETYPE;
    public static final int NWIDTH;
    public static final int NHEIGHT;
    public static final int NBYTESPERPIXEL;
    public static final int NFRAMESEQUENCE;
    public static final int TRACKEDDEVICEPOSE;
    public static final int ULFRAMEEXPOSURETIME;

    public CameraVideoStreamFrameHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CameraVideoStreamFrameHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="EVRTrackedCameraFrameType")
    public int eFrameType() {
        return CameraVideoStreamFrameHeader.neFrameType(this.address());
    }

    @NativeType(value="uint32_t")
    public int nWidth() {
        return CameraVideoStreamFrameHeader.nnWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int nHeight() {
        return CameraVideoStreamFrameHeader.nnHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int nBytesPerPixel() {
        return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
    }

    @NativeType(value="uint32_t")
    public int nFrameSequence() {
        return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
    }

    @NativeType(value="TrackedDevicePose_t")
    public TrackedDevicePose trackedDevicePose() {
        return CameraVideoStreamFrameHeader.ntrackedDevicePose(this.address());
    }

    @NativeType(value="uint64_t")
    public long ulFrameExposureTime() {
        return CameraVideoStreamFrameHeader.nulFrameExposureTime(this.address());
    }

    public static CameraVideoStreamFrameHeader malloc() {
        return CameraVideoStreamFrameHeader.wrap(CameraVideoStreamFrameHeader.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CameraVideoStreamFrameHeader calloc() {
        return CameraVideoStreamFrameHeader.wrap(CameraVideoStreamFrameHeader.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CameraVideoStreamFrameHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CameraVideoStreamFrameHeader.wrap(CameraVideoStreamFrameHeader.class, MemoryUtil.memAddress(container), container);
    }

    public static CameraVideoStreamFrameHeader create(long address) {
        return CameraVideoStreamFrameHeader.wrap(CameraVideoStreamFrameHeader.class, address);
    }

    @Nullable
    public static CameraVideoStreamFrameHeader createSafe(long address) {
        return address == 0L ? null : CameraVideoStreamFrameHeader.wrap(CameraVideoStreamFrameHeader.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CameraVideoStreamFrameHeader.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CameraVideoStreamFrameHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CameraVideoStreamFrameHeader.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CameraVideoStreamFrameHeader.__create(capacity, SIZEOF);
        return CameraVideoStreamFrameHeader.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CameraVideoStreamFrameHeader.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CameraVideoStreamFrameHeader.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader mallocStack() {
        return CameraVideoStreamFrameHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader callocStack() {
        return CameraVideoStreamFrameHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader mallocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.malloc(stack);
    }

    @Deprecated
    public static CameraVideoStreamFrameHeader callocStack(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CameraVideoStreamFrameHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CameraVideoStreamFrameHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.calloc(capacity, stack);
    }

    public static CameraVideoStreamFrameHeader malloc(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.wrap(CameraVideoStreamFrameHeader.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CameraVideoStreamFrameHeader calloc(MemoryStack stack) {
        return CameraVideoStreamFrameHeader.wrap(CameraVideoStreamFrameHeader.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CameraVideoStreamFrameHeader.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int neFrameType(long struct) {
        return UNSAFE.getInt(null, struct + (long)EFRAMETYPE);
    }

    public static int nnWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)NWIDTH);
    }

    public static int nnHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)NHEIGHT);
    }

    public static int nnBytesPerPixel(long struct) {
        return UNSAFE.getInt(null, struct + (long)NBYTESPERPIXEL);
    }

    public static int nnFrameSequence(long struct) {
        return UNSAFE.getInt(null, struct + (long)NFRAMESEQUENCE);
    }

    public static TrackedDevicePose ntrackedDevicePose(long struct) {
        return TrackedDevicePose.create(struct + (long)TRACKEDDEVICEPOSE);
    }

    public static long nulFrameExposureTime(long struct) {
        return UNSAFE.getLong(null, struct + (long)ULFRAMEEXPOSURETIME);
    }

    static {
        Struct.Layout layout = CameraVideoStreamFrameHeader.__struct(CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(4), CameraVideoStreamFrameHeader.__member(TrackedDevicePose.SIZEOF, TrackedDevicePose.ALIGNOF), CameraVideoStreamFrameHeader.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EFRAMETYPE = layout.offsetof(0);
        NWIDTH = layout.offsetof(1);
        NHEIGHT = layout.offsetof(2);
        NBYTESPERPIXEL = layout.offsetof(3);
        NFRAMESEQUENCE = layout.offsetof(4);
        TRACKEDDEVICEPOSE = layout.offsetof(5);
        ULFRAMEEXPOSURETIME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<CameraVideoStreamFrameHeader, Buffer>
    implements NativeResource {
        private static final CameraVideoStreamFrameHeader ELEMENT_FACTORY = CameraVideoStreamFrameHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CameraVideoStreamFrameHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="EVRTrackedCameraFrameType")
        public int eFrameType() {
            return CameraVideoStreamFrameHeader.neFrameType(this.address());
        }

        @NativeType(value="uint32_t")
        public int nWidth() {
            return CameraVideoStreamFrameHeader.nnWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int nHeight() {
            return CameraVideoStreamFrameHeader.nnHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int nBytesPerPixel() {
            return CameraVideoStreamFrameHeader.nnBytesPerPixel(this.address());
        }

        @NativeType(value="uint32_t")
        public int nFrameSequence() {
            return CameraVideoStreamFrameHeader.nnFrameSequence(this.address());
        }

        @NativeType(value="TrackedDevicePose_t")
        public TrackedDevicePose trackedDevicePose() {
            return CameraVideoStreamFrameHeader.ntrackedDevicePose(this.address());
        }

        @NativeType(value="uint64_t")
        public long ulFrameExposureTime() {
            return CameraVideoStreamFrameHeader.nulFrameExposureTime(this.address());
        }
    }
}

