/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct AppOverrideKeys_t")
public class AppOverrideKeys
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PCHKEY;
    public static final int PCHVALUE;

    public AppOverrideKeys(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AppOverrideKeys.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer pchKey() {
        return AppOverrideKeys.npchKey(this.address());
    }

    @NativeType(value="char *")
    public String pchKeyString() {
        return AppOverrideKeys.npchKeyString(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer pchValue(int capacity) {
        return AppOverrideKeys.npchValue(this.address(), capacity);
    }

    public AppOverrideKeys pchKey(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchKey(this.address(), value);
        return this;
    }

    public AppOverrideKeys pchValue(@NativeType(value="char *") ByteBuffer value) {
        AppOverrideKeys.npchValue(this.address(), value);
        return this;
    }

    public AppOverrideKeys set(ByteBuffer pchKey, ByteBuffer pchValue) {
        this.pchKey(pchKey);
        this.pchValue(pchValue);
        return this;
    }

    public AppOverrideKeys set(AppOverrideKeys src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AppOverrideKeys malloc() {
        return AppOverrideKeys.wrap(AppOverrideKeys.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AppOverrideKeys calloc() {
        return AppOverrideKeys.wrap(AppOverrideKeys.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AppOverrideKeys create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AppOverrideKeys.wrap(AppOverrideKeys.class, MemoryUtil.memAddress(container), container);
    }

    public static AppOverrideKeys create(long address) {
        return AppOverrideKeys.wrap(AppOverrideKeys.class, address);
    }

    @Nullable
    public static AppOverrideKeys createSafe(long address) {
        return address == 0L ? null : AppOverrideKeys.wrap(AppOverrideKeys.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AppOverrideKeys.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AppOverrideKeys.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AppOverrideKeys.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AppOverrideKeys.__create(capacity, SIZEOF);
        return AppOverrideKeys.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AppOverrideKeys.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AppOverrideKeys.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AppOverrideKeys mallocStack() {
        return AppOverrideKeys.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AppOverrideKeys callocStack() {
        return AppOverrideKeys.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AppOverrideKeys mallocStack(MemoryStack stack) {
        return AppOverrideKeys.malloc(stack);
    }

    @Deprecated
    public static AppOverrideKeys callocStack(MemoryStack stack) {
        return AppOverrideKeys.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AppOverrideKeys.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AppOverrideKeys.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AppOverrideKeys.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AppOverrideKeys.calloc(capacity, stack);
    }

    public static AppOverrideKeys malloc(MemoryStack stack) {
        return AppOverrideKeys.wrap(AppOverrideKeys.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AppOverrideKeys calloc(MemoryStack stack) {
        return AppOverrideKeys.wrap(AppOverrideKeys.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AppOverrideKeys.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AppOverrideKeys.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npchKey(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PCHKEY));
    }

    public static String npchKeyString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)PCHKEY));
    }

    public static ByteBuffer npchValue(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PCHVALUE), capacity);
    }

    public static void npchKey(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PCHKEY, MemoryUtil.memAddress(value));
    }

    public static void npchValue(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCHVALUE, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCHKEY));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCHVALUE));
    }

    static {
        Struct.Layout layout = AppOverrideKeys.__struct(AppOverrideKeys.__member(POINTER_SIZE), AppOverrideKeys.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PCHKEY = layout.offsetof(0);
        PCHVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AppOverrideKeys, Buffer>
    implements NativeResource {
        private static final AppOverrideKeys ELEMENT_FACTORY = AppOverrideKeys.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AppOverrideKeys getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char *")
        public ByteBuffer pchKey() {
            return AppOverrideKeys.npchKey(this.address());
        }

        @NativeType(value="char *")
        public String pchKeyString() {
            return AppOverrideKeys.npchKeyString(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pchValue(int capacity) {
            return AppOverrideKeys.npchValue(this.address(), capacity);
        }

        public Buffer pchKey(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchKey(this.address(), value);
            return this;
        }

        public Buffer pchValue(@NativeType(value="char *") ByteBuffer value) {
            AppOverrideKeys.npchValue(this.address(), value);
            return this;
        }
    }
}

