/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.OESDrawBuffersIndexed;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class OESViewportArray {
    public static final int GL_MAX_VIEWPORTS_OES = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_OES = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_OES = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_OES = 33375;

    protected OESViewportArray() {
        throw new UnsupportedOperationException();
    }

    public static native void nglViewportArrayvOES(int var0, int var1, long var2);

    public static void glViewportArrayvOES(@NativeType(value="GLuint") int first, @NativeType(value="GLfloat const *") FloatBuffer v) {
        OESViewportArray.nglViewportArrayvOES(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glViewportIndexedfOES(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2, @NativeType(value="GLfloat") float var3, @NativeType(value="GLfloat") float var4);

    public static native void nglViewportIndexedfvOES(int var0, long var1);

    public static void glViewportIndexedfvOES(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        OESViewportArray.nglViewportIndexedfvOES(index, MemoryUtil.memAddress(v));
    }

    public static native void nglScissorArrayvOES(int var0, int var1, long var2);

    public static void glScissorArrayvOES(@NativeType(value="GLuint") int first, @NativeType(value="GLint const *") IntBuffer v) {
        OESViewportArray.nglScissorArrayvOES(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void glScissorIndexedOES(@NativeType(value="GLuint") int var0, @NativeType(value="GLint") int var1, @NativeType(value="GLint") int var2, @NativeType(value="GLsizei") int var3, @NativeType(value="GLsizei") int var4);

    public static native void nglScissorIndexedvOES(int var0, long var1);

    public static void glScissorIndexedvOES(@NativeType(value="GLuint") int index, @NativeType(value="GLint const *") IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)v, 4);
        }
        OESViewportArray.nglScissorIndexedvOES(index, MemoryUtil.memAddress(v));
    }

    public static native void nglDepthRangeArrayfvOES(int var0, int var1, long var2);

    public static void glDepthRangeArrayfvOES(@NativeType(value="GLuint") int first, @NativeType(value="GLfloat const *") FloatBuffer v) {
        OESViewportArray.nglDepthRangeArrayfvOES(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void glDepthRangeIndexedfOES(@NativeType(value="GLuint") int var0, @NativeType(value="GLfloat") float var1, @NativeType(value="GLfloat") float var2);

    public static native void nglGetFloati_vOES(int var0, int var1, long var2);

    public static void glGetFloati_vOES(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLfloat *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)data, 1);
        }
        OESViewportArray.nglGetFloati_vOES(target, index, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static float glGetFloatiOES(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            OESViewportArray.nglGetFloati_vOES(target, index, MemoryUtil.memAddress(data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glEnableiOES(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        OESDrawBuffersIndexed.glEnableiOES(target, index);
    }

    public static void glDisableiOES(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        OESDrawBuffersIndexed.glDisableiOES(target, index);
    }

    @NativeType(value="GLboolean")
    public static boolean glIsEnablediOES(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index) {
        return OESDrawBuffersIndexed.glIsEnablediOES(target, index);
    }

    public static void glViewportArrayvOES(@NativeType(value="GLuint") int first, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glViewportArrayvOES;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(first, v.length >> 2, v, __functionAddress);
    }

    public static void glViewportIndexedfvOES(@NativeType(value="GLuint") int index, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glViewportIndexedfvOES;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(index, v, __functionAddress);
    }

    public static void glScissorArrayvOES(@NativeType(value="GLuint") int first, @NativeType(value="GLint const *") int[] v) {
        long __functionAddress = GLES.getICD().glScissorArrayvOES;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(first, v.length >> 2, v, __functionAddress);
    }

    public static void glScissorIndexedvOES(@NativeType(value="GLuint") int index, @NativeType(value="GLint const *") int[] v) {
        long __functionAddress = GLES.getICD().glScissorIndexedvOES;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(v, 4);
        }
        JNI.callPV(index, v, __functionAddress);
    }

    public static void glDepthRangeArrayfvOES(@NativeType(value="GLuint") int first, @NativeType(value="GLfloat const *") float[] v) {
        long __functionAddress = GLES.getICD().glDepthRangeArrayfvOES;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(first, v.length >> 1, v, __functionAddress);
    }

    public static void glGetFloati_vOES(@NativeType(value="GLenum") int target, @NativeType(value="GLuint") int index, @NativeType(value="GLfloat *") float[] data) {
        long __functionAddress = GLES.getICD().glGetFloati_vOES;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(data, 1);
        }
        JNI.callPV(target, index, data, __functionAddress);
    }

    static {
        GLES.initialize();
    }
}

