/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DBMONEY
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNYHIGH;
    public static final int MNYLOW;

    public DBMONEY(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), DBMONEY.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int mnyhigh() {
        return DBMONEY.nmnyhigh(this.address());
    }

    @NativeType(value="ULONG")
    public int mnylow() {
        return DBMONEY.nmnylow(this.address());
    }

    public DBMONEY mnyhigh(@NativeType(value="LONG") int value) {
        DBMONEY.nmnyhigh(this.address(), value);
        return this;
    }

    public DBMONEY mnylow(@NativeType(value="ULONG") int value) {
        DBMONEY.nmnylow(this.address(), value);
        return this;
    }

    public DBMONEY set(int mnyhigh, int mnylow) {
        this.mnyhigh(mnyhigh);
        this.mnylow(mnylow);
        return this;
    }

    public DBMONEY set(DBMONEY src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static DBMONEY malloc() {
        return DBMONEY.wrap(DBMONEY.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static DBMONEY calloc() {
        return DBMONEY.wrap(DBMONEY.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static DBMONEY create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return DBMONEY.wrap(DBMONEY.class, MemoryUtil.memAddress(container), container);
    }

    public static DBMONEY create(long address) {
        return DBMONEY.wrap(DBMONEY.class, address);
    }

    @Nullable
    public static DBMONEY createSafe(long address) {
        return address == 0L ? null : DBMONEY.wrap(DBMONEY.class, address);
    }

    public static Buffer malloc(int capacity) {
        return DBMONEY.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(DBMONEY.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return DBMONEY.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = DBMONEY.__create(capacity, SIZEOF);
        return DBMONEY.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return DBMONEY.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : DBMONEY.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static DBMONEY mallocStack() {
        return DBMONEY.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBMONEY callocStack() {
        return DBMONEY.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBMONEY mallocStack(MemoryStack stack) {
        return DBMONEY.malloc(stack);
    }

    @Deprecated
    public static DBMONEY callocStack(MemoryStack stack) {
        return DBMONEY.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return DBMONEY.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return DBMONEY.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return DBMONEY.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return DBMONEY.calloc(capacity, stack);
    }

    public static DBMONEY malloc(MemoryStack stack) {
        return DBMONEY.wrap(DBMONEY.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static DBMONEY calloc(MemoryStack stack) {
        return DBMONEY.wrap(DBMONEY.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return DBMONEY.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return DBMONEY.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmnyhigh(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNYHIGH);
    }

    public static int nmnylow(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNYLOW);
    }

    public static void nmnyhigh(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNYHIGH, value);
    }

    public static void nmnylow(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNYLOW, value);
    }

    static {
        Struct.Layout layout = DBMONEY.__struct(DBMONEY.__member(4), DBMONEY.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNYHIGH = layout.offsetof(0);
        MNYLOW = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<DBMONEY, Buffer>
    implements NativeResource {
        private static final DBMONEY ELEMENT_FACTORY = DBMONEY.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected DBMONEY getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LONG")
        public int mnyhigh() {
            return DBMONEY.nmnyhigh(this.address());
        }

        @NativeType(value="ULONG")
        public int mnylow() {
            return DBMONEY.nmnylow(this.address());
        }

        public Buffer mnyhigh(@NativeType(value="LONG") int value) {
            DBMONEY.nmnyhigh(this.address(), value);
            return this;
        }

        public Buffer mnylow(@NativeType(value="ULONG") int value) {
            DBMONEY.nmnylow(this.address(), value);
            return this;
        }
    }
}

