/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class DBDATETIME
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DTDAYS;
    public static final int DTTIME;

    public DBDATETIME(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), DBDATETIME.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int dtdays() {
        return DBDATETIME.ndtdays(this.address());
    }

    @NativeType(value="ULONG")
    public int dttime() {
        return DBDATETIME.ndttime(this.address());
    }

    public DBDATETIME dtdays(@NativeType(value="LONG") int value) {
        DBDATETIME.ndtdays(this.address(), value);
        return this;
    }

    public DBDATETIME dttime(@NativeType(value="ULONG") int value) {
        DBDATETIME.ndttime(this.address(), value);
        return this;
    }

    public DBDATETIME set(int dtdays, int dttime) {
        this.dtdays(dtdays);
        this.dttime(dttime);
        return this;
    }

    public DBDATETIME set(DBDATETIME src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static DBDATETIME malloc() {
        return DBDATETIME.wrap(DBDATETIME.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static DBDATETIME calloc() {
        return DBDATETIME.wrap(DBDATETIME.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static DBDATETIME create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return DBDATETIME.wrap(DBDATETIME.class, MemoryUtil.memAddress(container), container);
    }

    public static DBDATETIME create(long address) {
        return DBDATETIME.wrap(DBDATETIME.class, address);
    }

    @Nullable
    public static DBDATETIME createSafe(long address) {
        return address == 0L ? null : DBDATETIME.wrap(DBDATETIME.class, address);
    }

    public static Buffer malloc(int capacity) {
        return DBDATETIME.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(DBDATETIME.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return DBDATETIME.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = DBDATETIME.__create(capacity, SIZEOF);
        return DBDATETIME.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return DBDATETIME.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : DBDATETIME.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static DBDATETIME mallocStack() {
        return DBDATETIME.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBDATETIME callocStack() {
        return DBDATETIME.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static DBDATETIME mallocStack(MemoryStack stack) {
        return DBDATETIME.malloc(stack);
    }

    @Deprecated
    public static DBDATETIME callocStack(MemoryStack stack) {
        return DBDATETIME.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return DBDATETIME.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return DBDATETIME.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return DBDATETIME.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return DBDATETIME.calloc(capacity, stack);
    }

    public static DBDATETIME malloc(MemoryStack stack) {
        return DBDATETIME.wrap(DBDATETIME.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static DBDATETIME calloc(MemoryStack stack) {
        return DBDATETIME.wrap(DBDATETIME.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return DBDATETIME.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return DBDATETIME.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndtdays(long struct) {
        return UNSAFE.getInt(null, struct + (long)DTDAYS);
    }

    public static int ndttime(long struct) {
        return UNSAFE.getInt(null, struct + (long)DTTIME);
    }

    public static void ndtdays(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DTDAYS, value);
    }

    public static void ndttime(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DTTIME, value);
    }

    static {
        Struct.Layout layout = DBDATETIME.__struct(DBDATETIME.__member(4), DBDATETIME.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DTDAYS = layout.offsetof(0);
        DTTIME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<DBDATETIME, Buffer>
    implements NativeResource {
        private static final DBDATETIME ELEMENT_FACTORY = DBDATETIME.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected DBDATETIME getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LONG")
        public int dtdays() {
            return DBDATETIME.ndtdays(this.address());
        }

        @NativeType(value="ULONG")
        public int dttime() {
            return DBDATETIME.ndttime(this.address());
        }

        public Buffer dtdays(@NativeType(value="LONG") int value) {
            DBDATETIME.ndtdays(this.address(), value);
            return this;
        }

        public Buffer dttime(@NativeType(value="ULONG") int value) {
            DBDATETIME.ndttime(this.address(), value);
            return this;
        }
    }
}

