/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_user_font_glyph")
public class NkUserFontGlyph
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UV;
    public static final int OFFSET;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int XADVANCE;

    public NkUserFontGlyph(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkUserFontGlyph.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_vec2[2]")
    public NkVec2.Buffer uv() {
        return NkUserFontGlyph.nuv(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 uv(int index) {
        return NkUserFontGlyph.nuv(this.address(), index);
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 offset() {
        return NkUserFontGlyph.noffset(this.address());
    }

    public float width() {
        return NkUserFontGlyph.nwidth(this.address());
    }

    public float height() {
        return NkUserFontGlyph.nheight(this.address());
    }

    public float xadvance() {
        return NkUserFontGlyph.nxadvance(this.address());
    }

    public NkUserFontGlyph uv(@NativeType(value="struct nk_vec2[2]") NkVec2.Buffer value) {
        NkUserFontGlyph.nuv(this.address(), value);
        return this;
    }

    public NkUserFontGlyph uv(int index, @NativeType(value="struct nk_vec2") NkVec2 value) {
        NkUserFontGlyph.nuv(this.address(), index, value);
        return this;
    }

    public NkUserFontGlyph uv(Consumer<NkVec2.Buffer> consumer) {
        consumer.accept(this.uv());
        return this;
    }

    public NkUserFontGlyph uv(int index, Consumer<NkVec2> consumer) {
        consumer.accept(this.uv(index));
        return this;
    }

    public NkUserFontGlyph offset(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkUserFontGlyph.noffset(this.address(), value);
        return this;
    }

    public NkUserFontGlyph offset(Consumer<NkVec2> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public NkUserFontGlyph width(float value) {
        NkUserFontGlyph.nwidth(this.address(), value);
        return this;
    }

    public NkUserFontGlyph height(float value) {
        NkUserFontGlyph.nheight(this.address(), value);
        return this;
    }

    public NkUserFontGlyph xadvance(float value) {
        NkUserFontGlyph.nxadvance(this.address(), value);
        return this;
    }

    public NkUserFontGlyph set(NkVec2.Buffer uv, NkVec2 offset, float width, float height, float xadvance) {
        this.uv(uv);
        this.offset(offset);
        this.width(width);
        this.height(height);
        this.xadvance(xadvance);
        return this;
    }

    public NkUserFontGlyph set(NkUserFontGlyph src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkUserFontGlyph malloc() {
        return NkUserFontGlyph.wrap(NkUserFontGlyph.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkUserFontGlyph calloc() {
        return NkUserFontGlyph.wrap(NkUserFontGlyph.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkUserFontGlyph create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkUserFontGlyph.wrap(NkUserFontGlyph.class, MemoryUtil.memAddress(container), container);
    }

    public static NkUserFontGlyph create(long address) {
        return NkUserFontGlyph.wrap(NkUserFontGlyph.class, address);
    }

    @Nullable
    public static NkUserFontGlyph createSafe(long address) {
        return address == 0L ? null : NkUserFontGlyph.wrap(NkUserFontGlyph.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkUserFontGlyph.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkUserFontGlyph.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkUserFontGlyph.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkUserFontGlyph.__create(capacity, SIZEOF);
        return NkUserFontGlyph.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkUserFontGlyph.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkUserFontGlyph.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkUserFontGlyph mallocStack() {
        return NkUserFontGlyph.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkUserFontGlyph callocStack() {
        return NkUserFontGlyph.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkUserFontGlyph mallocStack(MemoryStack stack) {
        return NkUserFontGlyph.malloc(stack);
    }

    @Deprecated
    public static NkUserFontGlyph callocStack(MemoryStack stack) {
        return NkUserFontGlyph.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkUserFontGlyph.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkUserFontGlyph.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.calloc(capacity, stack);
    }

    public static NkUserFontGlyph malloc(MemoryStack stack) {
        return NkUserFontGlyph.wrap(NkUserFontGlyph.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkUserFontGlyph calloc(MemoryStack stack) {
        return NkUserFontGlyph.wrap(NkUserFontGlyph.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkUserFontGlyph.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkVec2.Buffer nuv(long struct) {
        return NkVec2.create(struct + (long)UV, 2);
    }

    public static NkVec2 nuv(long struct, int index) {
        return NkVec2.create(struct + (long)UV + Checks.check(index, 2) * (long)NkVec2.SIZEOF);
    }

    public static NkVec2 noffset(long struct) {
        return NkVec2.create(struct + (long)OFFSET);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static float nxadvance(long struct) {
        return UNSAFE.getFloat(null, struct + (long)XADVANCE);
    }

    public static void nuv(long struct, NkVec2.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)UV, value.remaining() * NkVec2.SIZEOF);
    }

    public static void nuv(long struct, int index, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)UV + Checks.check(index, 2) * (long)NkVec2.SIZEOF, NkVec2.SIZEOF);
    }

    public static void noffset(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, NkVec2.SIZEOF);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    public static void nxadvance(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)XADVANCE, value);
    }

    static {
        Struct.Layout layout = NkUserFontGlyph.__struct(NkUserFontGlyph.__array(NkVec2.SIZEOF, NkVec2.ALIGNOF, 2), NkUserFontGlyph.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkUserFontGlyph.__member(4), NkUserFontGlyph.__member(4), NkUserFontGlyph.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UV = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        XADVANCE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkUserFontGlyph, Buffer>
    implements NativeResource {
        private static final NkUserFontGlyph ELEMENT_FACTORY = NkUserFontGlyph.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkUserFontGlyph getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_vec2[2]")
        public NkVec2.Buffer uv() {
            return NkUserFontGlyph.nuv(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 uv(int index) {
            return NkUserFontGlyph.nuv(this.address(), index);
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 offset() {
            return NkUserFontGlyph.noffset(this.address());
        }

        public float width() {
            return NkUserFontGlyph.nwidth(this.address());
        }

        public float height() {
            return NkUserFontGlyph.nheight(this.address());
        }

        public float xadvance() {
            return NkUserFontGlyph.nxadvance(this.address());
        }

        public Buffer uv(@NativeType(value="struct nk_vec2[2]") NkVec2.Buffer value) {
            NkUserFontGlyph.nuv(this.address(), value);
            return this;
        }

        public Buffer uv(int index, @NativeType(value="struct nk_vec2") NkVec2 value) {
            NkUserFontGlyph.nuv(this.address(), index, value);
            return this;
        }

        public Buffer uv(Consumer<NkVec2.Buffer> consumer) {
            consumer.accept(this.uv());
            return this;
        }

        public Buffer uv(int index, Consumer<NkVec2> consumer) {
            consumer.accept(this.uv(index));
            return this;
        }

        public Buffer offset(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkUserFontGlyph.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<NkVec2> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer width(float value) {
            NkUserFontGlyph.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            NkUserFontGlyph.nheight(this.address(), value);
            return this;
        }

        public Buffer xadvance(float value) {
            NkUserFontGlyph.nxadvance(this.address(), value);
            return this;
        }
    }
}

