/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkTextUndoRecord;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_text_undo_state")
public class NkTextUndoState
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UNDO_REC;
    public static final int UNDO_CHAR;
    public static final int UNDO_POINT;
    public static final int REDO_POINT;
    public static final int UNDO_CHAR_POINT;
    public static final int REDO_CHAR_POINT;

    public NkTextUndoState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkTextUndoState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_text_undo_record[99]")
    public NkTextUndoRecord.Buffer undo_rec() {
        return NkTextUndoState.nundo_rec(this.address());
    }

    @NativeType(value="struct nk_text_undo_record")
    public NkTextUndoRecord undo_rec(int index) {
        return NkTextUndoState.nundo_rec(this.address(), index);
    }

    @NativeType(value="nk_rune[999]")
    public IntBuffer undo_char() {
        return NkTextUndoState.nundo_char(this.address());
    }

    @NativeType(value="nk_rune")
    public int undo_char(int index) {
        return NkTextUndoState.nundo_char(this.address(), index);
    }

    public short undo_point() {
        return NkTextUndoState.nundo_point(this.address());
    }

    public short redo_point() {
        return NkTextUndoState.nredo_point(this.address());
    }

    public short undo_char_point() {
        return NkTextUndoState.nundo_char_point(this.address());
    }

    public short redo_char_point() {
        return NkTextUndoState.nredo_char_point(this.address());
    }

    public static NkTextUndoState create(long address) {
        return NkTextUndoState.wrap(NkTextUndoState.class, address);
    }

    @Nullable
    public static NkTextUndoState createSafe(long address) {
        return address == 0L ? null : NkTextUndoState.wrap(NkTextUndoState.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkTextUndoState.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkTextUndoState.wrap(Buffer.class, address, capacity);
    }

    public static NkTextUndoRecord.Buffer nundo_rec(long struct) {
        return NkTextUndoRecord.create(struct + (long)UNDO_REC, 99);
    }

    public static NkTextUndoRecord nundo_rec(long struct, int index) {
        return NkTextUndoRecord.create(struct + (long)UNDO_REC + Checks.check(index, 99) * (long)NkTextUndoRecord.SIZEOF);
    }

    public static IntBuffer nundo_char(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)UNDO_CHAR, 999);
    }

    public static int nundo_char(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)UNDO_CHAR + Checks.check(index, 999) * 4L);
    }

    public static short nundo_point(long struct) {
        return UNSAFE.getShort(null, struct + (long)UNDO_POINT);
    }

    public static short nredo_point(long struct) {
        return UNSAFE.getShort(null, struct + (long)REDO_POINT);
    }

    public static short nundo_char_point(long struct) {
        return UNSAFE.getShort(null, struct + (long)UNDO_CHAR_POINT);
    }

    public static short nredo_char_point(long struct) {
        return UNSAFE.getShort(null, struct + (long)REDO_CHAR_POINT);
    }

    static {
        Struct.Layout layout = NkTextUndoState.__struct(NkTextUndoState.__array(NkTextUndoRecord.SIZEOF, NkTextUndoRecord.ALIGNOF, 99), NkTextUndoState.__array(4, 999), NkTextUndoState.__member(2), NkTextUndoState.__member(2), NkTextUndoState.__member(2), NkTextUndoState.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UNDO_REC = layout.offsetof(0);
        UNDO_CHAR = layout.offsetof(1);
        UNDO_POINT = layout.offsetof(2);
        REDO_POINT = layout.offsetof(3);
        UNDO_CHAR_POINT = layout.offsetof(4);
        REDO_CHAR_POINT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NkTextUndoState, Buffer> {
        private static final NkTextUndoState ELEMENT_FACTORY = NkTextUndoState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkTextUndoState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_text_undo_record[99]")
        public NkTextUndoRecord.Buffer undo_rec() {
            return NkTextUndoState.nundo_rec(this.address());
        }

        @NativeType(value="struct nk_text_undo_record")
        public NkTextUndoRecord undo_rec(int index) {
            return NkTextUndoState.nundo_rec(this.address(), index);
        }

        @NativeType(value="nk_rune[999]")
        public IntBuffer undo_char() {
            return NkTextUndoState.nundo_char(this.address());
        }

        @NativeType(value="nk_rune")
        public int undo_char(int index) {
            return NkTextUndoState.nundo_char(this.address(), index);
        }

        public short undo_point() {
            return NkTextUndoState.nundo_point(this.address());
        }

        public short redo_point() {
            return NkTextUndoState.nredo_point(this.address());
        }

        public short undo_char_point() {
            return NkTextUndoState.nundo_char_point(this.address());
        }

        public short redo_char_point() {
            return NkTextUndoState.nredo_char_point(this.address());
        }
    }
}

