/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkClipboard;
import org.lwjgl.nuklear.NkPluginFilter;
import org.lwjgl.nuklear.NkStr;
import org.lwjgl.nuklear.NkTextUndoState;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_text_edit")
public class NkTextEdit
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CLIP;
    public static final int STRING;
    public static final int FILTER;
    public static final int SCROLLBAR;
    public static final int CURSOR;
    public static final int SELECT_START;
    public static final int SELECT_END;
    public static final int MODE;
    public static final int CURSOR_AT_END_OF_LINE;
    public static final int INITIALIZED;
    public static final int HAS_PREFERRED_X;
    public static final int SINGLE_LINE;
    public static final int ACTIVE;
    public static final int PREFERRED_X;
    public static final int UNDO;

    public NkTextEdit(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkTextEdit.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_clipboard")
    public NkClipboard clip() {
        return NkTextEdit.nclip(this.address());
    }

    @NativeType(value="struct nk_str")
    public NkStr string() {
        return NkTextEdit.nstring(this.address());
    }

    @Nullable
    @NativeType(value="nk_plugin_filter")
    public NkPluginFilter filter() {
        return NkTextEdit.nfilter(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 scrollbar() {
        return NkTextEdit.nscrollbar(this.address());
    }

    public int cursor() {
        return NkTextEdit.ncursor(this.address());
    }

    public int select_start() {
        return NkTextEdit.nselect_start(this.address());
    }

    public int select_end() {
        return NkTextEdit.nselect_end(this.address());
    }

    @NativeType(value="unsigned char")
    public byte mode() {
        return NkTextEdit.nmode(this.address());
    }

    @NativeType(value="bool")
    public boolean cursor_at_end_of_line() {
        return NkTextEdit.ncursor_at_end_of_line(this.address());
    }

    @NativeType(value="bool")
    public boolean initialized() {
        return NkTextEdit.ninitialized(this.address());
    }

    @NativeType(value="bool")
    public boolean has_preferred_x() {
        return NkTextEdit.nhas_preferred_x(this.address());
    }

    @NativeType(value="bool")
    public boolean single_line() {
        return NkTextEdit.nsingle_line(this.address());
    }

    @NativeType(value="bool")
    public boolean active() {
        return NkTextEdit.nactive(this.address());
    }

    public float preferred_x() {
        return NkTextEdit.npreferred_x(this.address());
    }

    @NativeType(value="struct nk_text_undo_state")
    public NkTextUndoState undo() {
        return NkTextEdit.nundo(this.address());
    }

    public static NkTextEdit malloc() {
        return NkTextEdit.wrap(NkTextEdit.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkTextEdit calloc() {
        return NkTextEdit.wrap(NkTextEdit.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkTextEdit create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkTextEdit.wrap(NkTextEdit.class, MemoryUtil.memAddress(container), container);
    }

    public static NkTextEdit create(long address) {
        return NkTextEdit.wrap(NkTextEdit.class, address);
    }

    @Nullable
    public static NkTextEdit createSafe(long address) {
        return address == 0L ? null : NkTextEdit.wrap(NkTextEdit.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkTextEdit.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkTextEdit.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkTextEdit.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkTextEdit.__create(capacity, SIZEOF);
        return NkTextEdit.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkTextEdit.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkTextEdit.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkTextEdit mallocStack() {
        return NkTextEdit.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkTextEdit callocStack() {
        return NkTextEdit.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkTextEdit mallocStack(MemoryStack stack) {
        return NkTextEdit.malloc(stack);
    }

    @Deprecated
    public static NkTextEdit callocStack(MemoryStack stack) {
        return NkTextEdit.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkTextEdit.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkTextEdit.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkTextEdit.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkTextEdit.calloc(capacity, stack);
    }

    public static NkTextEdit malloc(MemoryStack stack) {
        return NkTextEdit.wrap(NkTextEdit.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkTextEdit calloc(MemoryStack stack) {
        return NkTextEdit.wrap(NkTextEdit.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkTextEdit.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkTextEdit.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkClipboard nclip(long struct) {
        return NkClipboard.create(struct + (long)CLIP);
    }

    public static NkStr nstring(long struct) {
        return NkStr.create(struct + (long)STRING);
    }

    @Nullable
    public static NkPluginFilter nfilter(long struct) {
        return NkPluginFilter.createSafe(MemoryUtil.memGetAddress(struct + (long)FILTER));
    }

    public static NkVec2 nscrollbar(long struct) {
        return NkVec2.create(struct + (long)SCROLLBAR);
    }

    public static int ncursor(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSOR);
    }

    public static int nselect_start(long struct) {
        return UNSAFE.getInt(null, struct + (long)SELECT_START);
    }

    public static int nselect_end(long struct) {
        return UNSAFE.getInt(null, struct + (long)SELECT_END);
    }

    public static byte nmode(long struct) {
        return UNSAFE.getByte(null, struct + (long)MODE);
    }

    public static boolean ncursor_at_end_of_line(long struct) {
        return UNSAFE.getByte(null, struct + (long)CURSOR_AT_END_OF_LINE) != 0;
    }

    public static boolean ninitialized(long struct) {
        return UNSAFE.getByte(null, struct + (long)INITIALIZED) != 0;
    }

    public static boolean nhas_preferred_x(long struct) {
        return UNSAFE.getByte(null, struct + (long)HAS_PREFERRED_X) != 0;
    }

    public static boolean nsingle_line(long struct) {
        return UNSAFE.getByte(null, struct + (long)SINGLE_LINE) != 0;
    }

    public static boolean nactive(long struct) {
        return UNSAFE.getByte(null, struct + (long)ACTIVE) != 0;
    }

    public static float npreferred_x(long struct) {
        return UNSAFE.getFloat(null, struct + (long)PREFERRED_X);
    }

    public static NkTextUndoState nundo(long struct) {
        return NkTextUndoState.create(struct + (long)UNDO);
    }

    static {
        Struct.Layout layout = NkTextEdit.__struct(NkTextEdit.__member(NkClipboard.SIZEOF, NkClipboard.ALIGNOF), NkTextEdit.__member(NkStr.SIZEOF, NkStr.ALIGNOF), NkTextEdit.__member(POINTER_SIZE), NkTextEdit.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkTextEdit.__member(4), NkTextEdit.__member(4), NkTextEdit.__member(4), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__member(1), NkTextEdit.__padding(1, true), NkTextEdit.__member(4), NkTextEdit.__member(NkTextUndoState.SIZEOF, NkTextUndoState.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CLIP = layout.offsetof(0);
        STRING = layout.offsetof(1);
        FILTER = layout.offsetof(2);
        SCROLLBAR = layout.offsetof(3);
        CURSOR = layout.offsetof(4);
        SELECT_START = layout.offsetof(5);
        SELECT_END = layout.offsetof(6);
        MODE = layout.offsetof(7);
        CURSOR_AT_END_OF_LINE = layout.offsetof(8);
        INITIALIZED = layout.offsetof(9);
        HAS_PREFERRED_X = layout.offsetof(10);
        SINGLE_LINE = layout.offsetof(11);
        ACTIVE = layout.offsetof(12);
        PREFERRED_X = layout.offsetof(14);
        UNDO = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<NkTextEdit, Buffer>
    implements NativeResource {
        private static final NkTextEdit ELEMENT_FACTORY = NkTextEdit.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkTextEdit getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_clipboard")
        public NkClipboard clip() {
            return NkTextEdit.nclip(this.address());
        }

        @NativeType(value="struct nk_str")
        public NkStr string() {
            return NkTextEdit.nstring(this.address());
        }

        @Nullable
        @NativeType(value="nk_plugin_filter")
        public NkPluginFilter filter() {
            return NkTextEdit.nfilter(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 scrollbar() {
            return NkTextEdit.nscrollbar(this.address());
        }

        public int cursor() {
            return NkTextEdit.ncursor(this.address());
        }

        public int select_start() {
            return NkTextEdit.nselect_start(this.address());
        }

        public int select_end() {
            return NkTextEdit.nselect_end(this.address());
        }

        @NativeType(value="unsigned char")
        public byte mode() {
            return NkTextEdit.nmode(this.address());
        }

        @NativeType(value="bool")
        public boolean cursor_at_end_of_line() {
            return NkTextEdit.ncursor_at_end_of_line(this.address());
        }

        @NativeType(value="bool")
        public boolean initialized() {
            return NkTextEdit.ninitialized(this.address());
        }

        @NativeType(value="bool")
        public boolean has_preferred_x() {
            return NkTextEdit.nhas_preferred_x(this.address());
        }

        @NativeType(value="bool")
        public boolean single_line() {
            return NkTextEdit.nsingle_line(this.address());
        }

        @NativeType(value="bool")
        public boolean active() {
            return NkTextEdit.nactive(this.address());
        }

        public float preferred_x() {
            return NkTextEdit.npreferred_x(this.address());
        }

        @NativeType(value="struct nk_text_undo_state")
        public NkTextUndoState undo() {
            return NkTextEdit.nundo(this.address());
        }
    }
}

