/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_rect")
public class NkRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    public NkRect(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkRect.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return NkRect.nx(this.address());
    }

    public float y() {
        return NkRect.ny(this.address());
    }

    public float w() {
        return NkRect.nw(this.address());
    }

    public float h() {
        return NkRect.nh(this.address());
    }

    public NkRect x(float value) {
        NkRect.nx(this.address(), value);
        return this;
    }

    public NkRect y(float value) {
        NkRect.ny(this.address(), value);
        return this;
    }

    public NkRect w(float value) {
        NkRect.nw(this.address(), value);
        return this;
    }

    public NkRect h(float value) {
        NkRect.nh(this.address(), value);
        return this;
    }

    public NkRect set(float x, float y, float w, float h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public NkRect set(NkRect src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkRect malloc() {
        return NkRect.wrap(NkRect.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkRect calloc() {
        return NkRect.wrap(NkRect.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkRect create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkRect.wrap(NkRect.class, MemoryUtil.memAddress(container), container);
    }

    public static NkRect create(long address) {
        return NkRect.wrap(NkRect.class, address);
    }

    @Nullable
    public static NkRect createSafe(long address) {
        return address == 0L ? null : NkRect.wrap(NkRect.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkRect.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkRect.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkRect.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkRect.__create(capacity, SIZEOF);
        return NkRect.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkRect.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkRect.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkRect mallocStack() {
        return NkRect.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkRect callocStack() {
        return NkRect.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkRect mallocStack(MemoryStack stack) {
        return NkRect.malloc(stack);
    }

    @Deprecated
    public static NkRect callocStack(MemoryStack stack) {
        return NkRect.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkRect.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkRect.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkRect.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkRect.calloc(capacity, stack);
    }

    public static NkRect malloc(MemoryStack stack) {
        return NkRect.wrap(NkRect.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkRect calloc(MemoryStack stack) {
        return NkRect.wrap(NkRect.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkRect.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkRect.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static float nh(long struct) {
        return UNSAFE.getFloat(null, struct + (long)H);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    public static void nw(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)W, value);
    }

    public static void nh(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)H, value);
    }

    static {
        Struct.Layout layout = NkRect.__struct(NkRect.__member(4), NkRect.__member(4), NkRect.__member(4), NkRect.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkRect, Buffer>
    implements NativeResource {
        private static final NkRect ELEMENT_FACTORY = NkRect.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkRect getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return NkRect.nx(this.address());
        }

        public float y() {
            return NkRect.ny(this.address());
        }

        public float w() {
            return NkRect.nw(this.address());
        }

        public float h() {
            return NkRect.nh(this.address());
        }

        public Buffer x(float value) {
            NkRect.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            NkRect.ny(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            NkRect.nw(this.address(), value);
            return this;
        }

        public Buffer h(float value) {
            NkRect.nh(this.address(), value);
            return this;
        }
    }
}

