/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkKeyboard;
import org.lwjgl.nuklear.NkMouse;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_input")
public class NkInput
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEYBOARD;
    public static final int MOUSE;

    public NkInput(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkInput.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_keyboard")
    public NkKeyboard keyboard() {
        return NkInput.nkeyboard(this.address());
    }

    @NativeType(value="struct nk_mouse")
    public NkMouse mouse() {
        return NkInput.nmouse(this.address());
    }

    public static NkInput malloc() {
        return NkInput.wrap(NkInput.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkInput calloc() {
        return NkInput.wrap(NkInput.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkInput create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkInput.wrap(NkInput.class, MemoryUtil.memAddress(container), container);
    }

    public static NkInput create(long address) {
        return NkInput.wrap(NkInput.class, address);
    }

    @Nullable
    public static NkInput createSafe(long address) {
        return address == 0L ? null : NkInput.wrap(NkInput.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkInput.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkInput.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkInput.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkInput.__create(capacity, SIZEOF);
        return NkInput.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkInput.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkInput.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkInput mallocStack() {
        return NkInput.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkInput callocStack() {
        return NkInput.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkInput mallocStack(MemoryStack stack) {
        return NkInput.malloc(stack);
    }

    @Deprecated
    public static NkInput callocStack(MemoryStack stack) {
        return NkInput.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkInput.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkInput.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkInput.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkInput.calloc(capacity, stack);
    }

    public static NkInput malloc(MemoryStack stack) {
        return NkInput.wrap(NkInput.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkInput calloc(MemoryStack stack) {
        return NkInput.wrap(NkInput.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkInput.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkInput.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkKeyboard nkeyboard(long struct) {
        return NkKeyboard.create(struct + (long)KEYBOARD);
    }

    public static NkMouse nmouse(long struct) {
        return NkMouse.create(struct + (long)MOUSE);
    }

    static {
        Struct.Layout layout = NkInput.__struct(NkInput.__member(NkKeyboard.SIZEOF, NkKeyboard.ALIGNOF), NkInput.__member(NkMouse.SIZEOF, NkMouse.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEYBOARD = layout.offsetof(0);
        MOUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkInput, Buffer>
    implements NativeResource {
        private static final NkInput ELEMENT_FACTORY = NkInput.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkInput getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_keyboard")
        public NkKeyboard keyboard() {
            return NkInput.nkeyboard(this.address());
        }

        @NativeType(value="struct nk_mouse")
        public NkMouse mouse() {
            return NkInput.nmouse(this.address());
        }
    }
}

