/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBuffer;
import org.lwjgl.nuklear.NkClipboard;
import org.lwjgl.nuklear.NkCommandBuffer;
import org.lwjgl.nuklear.NkConfigurationStacks;
import org.lwjgl.nuklear.NkDrawList;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkInput;
import org.lwjgl.nuklear.NkPool;
import org.lwjgl.nuklear.NkStyle;
import org.lwjgl.nuklear.NkTextEdit;
import org.lwjgl.nuklear.NkWindow;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct nk_context")
public class NkContext
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INPUT;
    public static final int STYLE;
    public static final int MEMORY;
    public static final int CLIP;
    public static final int LAST_WIDGET_STATE;
    public static final int BUTTON_BEHAVIOR;
    public static final int STACKS;
    public static final int DELTA_TIME_SECONDS;
    public static final int DRAW_LIST;
    public static final int USERDATA;
    public static final int TEXT_EDIT;
    public static final int OVERLAY;
    public static final int BUILD;
    public static final int USE_POOL;
    public static final int POOL;
    public static final int BEGIN;
    public static final int END;
    public static final int ACTIVE;
    public static final int CURRENT;
    public static final int FREELIST;
    public static final int COUNT;
    public static final int SEQ;

    public NkContext(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkContext.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_input")
    public NkInput input() {
        return NkContext.ninput(this.address());
    }

    @NativeType(value="struct nk_style")
    public NkStyle style() {
        return NkContext.nstyle(this.address());
    }

    @NativeType(value="struct nk_buffer")
    public NkBuffer memory() {
        return NkContext.nmemory(this.address());
    }

    @NativeType(value="struct nk_clipboard")
    public NkClipboard clip() {
        return NkContext.nclip(this.address());
    }

    @NativeType(value="nk_flags")
    public int last_widget_state() {
        return NkContext.nlast_widget_state(this.address());
    }

    @NativeType(value="enum nk_button_behavior")
    public int button_behavior() {
        return NkContext.nbutton_behavior(this.address());
    }

    @NativeType(value="struct nk_configuration_stacks")
    public NkConfigurationStacks stacks() {
        return NkContext.nstacks(this.address());
    }

    public float delta_time_seconds() {
        return NkContext.ndelta_time_seconds(this.address());
    }

    public static NkContext malloc() {
        return NkContext.wrap(NkContext.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkContext calloc() {
        return NkContext.wrap(NkContext.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkContext create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkContext.wrap(NkContext.class, MemoryUtil.memAddress(container), container);
    }

    public static NkContext create(long address) {
        return NkContext.wrap(NkContext.class, address);
    }

    @Nullable
    public static NkContext createSafe(long address) {
        return address == 0L ? null : NkContext.wrap(NkContext.class, address);
    }

    @Deprecated
    public static NkContext mallocStack() {
        return NkContext.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkContext callocStack() {
        return NkContext.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkContext mallocStack(MemoryStack stack) {
        return NkContext.malloc(stack);
    }

    @Deprecated
    public static NkContext callocStack(MemoryStack stack) {
        return NkContext.calloc(stack);
    }

    public static NkContext malloc(MemoryStack stack) {
        return NkContext.wrap(NkContext.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkContext calloc(MemoryStack stack) {
        return NkContext.wrap(NkContext.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static NkInput ninput(long struct) {
        return NkInput.create(struct + (long)INPUT);
    }

    public static NkStyle nstyle(long struct) {
        return NkStyle.create(struct + (long)STYLE);
    }

    public static NkBuffer nmemory(long struct) {
        return NkBuffer.create(struct + (long)MEMORY);
    }

    public static NkClipboard nclip(long struct) {
        return NkClipboard.create(struct + (long)CLIP);
    }

    public static int nlast_widget_state(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAST_WIDGET_STATE);
    }

    public static int nbutton_behavior(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUTTON_BEHAVIOR);
    }

    public static NkConfigurationStacks nstacks(long struct) {
        return NkConfigurationStacks.create(struct + (long)STACKS);
    }

    public static float ndelta_time_seconds(long struct) {
        return UNSAFE.getFloat(null, struct + (long)DELTA_TIME_SECONDS);
    }

    public static NkDrawList ndraw_list(long struct) {
        return NkDrawList.create(struct + (long)DRAW_LIST);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    public static NkTextEdit ntext_edit(long struct) {
        return NkTextEdit.create(struct + (long)TEXT_EDIT);
    }

    public static NkCommandBuffer noverlay(long struct) {
        return NkCommandBuffer.create(struct + (long)OVERLAY);
    }

    public static int nbuild(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUILD);
    }

    public static int nuse_pool(long struct) {
        return UNSAFE.getInt(null, struct + (long)USE_POOL);
    }

    public static NkPool npool(long struct) {
        return NkPool.create(struct + (long)POOL);
    }

    @Nullable
    public static NkWindow nbegin(long struct) {
        return NkWindow.createSafe(MemoryUtil.memGetAddress(struct + (long)BEGIN));
    }

    @Nullable
    public static NkWindow nend(long struct) {
        return NkWindow.createSafe(MemoryUtil.memGetAddress(struct + (long)END));
    }

    @Nullable
    public static NkWindow nactive(long struct) {
        return NkWindow.createSafe(MemoryUtil.memGetAddress(struct + (long)ACTIVE));
    }

    @Nullable
    public static NkWindow ncurrent(long struct) {
        return NkWindow.createSafe(MemoryUtil.memGetAddress(struct + (long)CURRENT));
    }

    public static long nfreelist(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FREELIST);
    }

    public static int ncount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNT);
    }

    public static int nseq(long struct) {
        return UNSAFE.getInt(null, struct + (long)SEQ);
    }

    static {
        Struct.Layout layout = NkContext.__struct(NkContext.__member(NkInput.SIZEOF, NkInput.ALIGNOF), NkContext.__member(NkStyle.SIZEOF, NkStyle.ALIGNOF), NkContext.__member(NkBuffer.SIZEOF, NkBuffer.ALIGNOF), NkContext.__member(NkClipboard.SIZEOF, NkClipboard.ALIGNOF), NkContext.__member(4), NkContext.__member(4), NkContext.__member(NkConfigurationStacks.SIZEOF, NkConfigurationStacks.ALIGNOF), NkContext.__member(4), NkContext.__member(NkDrawList.SIZEOF, NkDrawList.ALIGNOF), NkContext.__member(NkHandle.SIZEOF, NkHandle.ALIGNOF), NkContext.__member(NkTextEdit.SIZEOF, NkTextEdit.ALIGNOF), NkContext.__member(NkCommandBuffer.SIZEOF, NkCommandBuffer.ALIGNOF), NkContext.__member(4), NkContext.__member(4), NkContext.__member(NkPool.SIZEOF, NkPool.ALIGNOF), NkContext.__member(POINTER_SIZE), NkContext.__member(POINTER_SIZE), NkContext.__member(POINTER_SIZE), NkContext.__member(POINTER_SIZE), NkContext.__member(POINTER_SIZE), NkContext.__member(4), NkContext.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INPUT = layout.offsetof(0);
        STYLE = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        CLIP = layout.offsetof(3);
        LAST_WIDGET_STATE = layout.offsetof(4);
        BUTTON_BEHAVIOR = layout.offsetof(5);
        STACKS = layout.offsetof(6);
        DELTA_TIME_SECONDS = layout.offsetof(7);
        DRAW_LIST = layout.offsetof(8);
        USERDATA = layout.offsetof(9);
        TEXT_EDIT = layout.offsetof(10);
        OVERLAY = layout.offsetof(11);
        BUILD = layout.offsetof(12);
        USE_POOL = layout.offsetof(13);
        POOL = layout.offsetof(14);
        BEGIN = layout.offsetof(15);
        END = layout.offsetof(16);
        ACTIVE = layout.offsetof(17);
        CURRENT = layout.offsetof(18);
        FREELIST = layout.offsetof(19);
        COUNT = layout.offsetof(20);
        SEQ = layout.offsetof(21);
    }
}

