/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkConfigStackFloatElement;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_config_stack_float")
class NkConfigStackFloat
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int ELEMENTS;

    NkConfigStackFloat(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkConfigStackFloat.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int head() {
        return NkConfigStackFloat.nhead(this.address());
    }

    @NativeType(value="struct nk_config_stack_float_element[32]")
    public NkConfigStackFloatElement.Buffer elements() {
        return NkConfigStackFloat.nelements(this.address());
    }

    @NativeType(value="struct nk_config_stack_float_element")
    public NkConfigStackFloatElement elements(int index) {
        return NkConfigStackFloat.nelements(this.address(), index);
    }

    public static NkConfigStackFloat create(long address) {
        return NkConfigStackFloat.wrap(NkConfigStackFloat.class, address);
    }

    @Nullable
    public static NkConfigStackFloat createSafe(long address) {
        return address == 0L ? null : NkConfigStackFloat.wrap(NkConfigStackFloat.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkConfigStackFloat.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkConfigStackFloat.wrap(Buffer.class, address, capacity);
    }

    public static int nhead(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEAD);
    }

    public static NkConfigStackFloatElement.Buffer nelements(long struct) {
        return NkConfigStackFloatElement.create(struct + (long)ELEMENTS, 32);
    }

    public static NkConfigStackFloatElement nelements(long struct, int index) {
        return NkConfigStackFloatElement.create(struct + (long)ELEMENTS + Checks.check(index, 32) * (long)NkConfigStackFloatElement.SIZEOF);
    }

    static {
        Struct.Layout layout = NkConfigStackFloat.__struct(NkConfigStackFloat.__member(4), NkConfigStackFloat.__array(NkConfigStackFloatElement.SIZEOF, NkConfigStackFloatElement.ALIGNOF, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEAD = layout.offsetof(0);
        ELEMENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkConfigStackFloat, Buffer> {
        private static final NkConfigStackFloat ELEMENT_FACTORY = NkConfigStackFloat.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkConfigStackFloat getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int head() {
            return NkConfigStackFloat.nhead(this.address());
        }

        @NativeType(value="struct nk_config_stack_float_element[32]")
        public NkConfigStackFloatElement.Buffer elements() {
            return NkConfigStackFloat.nelements(this.address());
        }

        @NativeType(value="struct nk_config_stack_float_element")
        public NkConfigStackFloatElement elements(int index) {
            return NkConfigStackFloat.nelements(this.address(), index);
        }
    }
}

