/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_color")
public class NkColor
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    public NkColor(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkColor.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_byte")
    public byte r() {
        return NkColor.nr(this.address());
    }

    @NativeType(value="nk_byte")
    public byte g() {
        return NkColor.ng(this.address());
    }

    @NativeType(value="nk_byte")
    public byte b() {
        return NkColor.nb(this.address());
    }

    @NativeType(value="nk_byte")
    public byte a() {
        return NkColor.na(this.address());
    }

    public NkColor r(@NativeType(value="nk_byte") byte value) {
        NkColor.nr(this.address(), value);
        return this;
    }

    public NkColor g(@NativeType(value="nk_byte") byte value) {
        NkColor.ng(this.address(), value);
        return this;
    }

    public NkColor b(@NativeType(value="nk_byte") byte value) {
        NkColor.nb(this.address(), value);
        return this;
    }

    public NkColor a(@NativeType(value="nk_byte") byte value) {
        NkColor.na(this.address(), value);
        return this;
    }

    public NkColor set(byte r, byte g, byte b, byte a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public NkColor set(NkColor src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkColor malloc() {
        return NkColor.wrap(NkColor.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NkColor calloc() {
        return NkColor.wrap(NkColor.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NkColor create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NkColor.wrap(NkColor.class, MemoryUtil.memAddress(container), container);
    }

    public static NkColor create(long address) {
        return NkColor.wrap(NkColor.class, address);
    }

    @Nullable
    public static NkColor createSafe(long address) {
        return address == 0L ? null : NkColor.wrap(NkColor.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NkColor.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NkColor.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NkColor.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkColor.__create(capacity, SIZEOF);
        return NkColor.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NkColor.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkColor.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NkColor mallocStack() {
        return NkColor.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkColor callocStack() {
        return NkColor.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkColor mallocStack(MemoryStack stack) {
        return NkColor.malloc(stack);
    }

    @Deprecated
    public static NkColor callocStack(MemoryStack stack) {
        return NkColor.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkColor.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkColor.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkColor.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkColor.calloc(capacity, stack);
    }

    public static NkColor malloc(MemoryStack stack) {
        return NkColor.wrap(NkColor.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkColor calloc(MemoryStack stack) {
        return NkColor.wrap(NkColor.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NkColor.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NkColor.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nr(long struct) {
        return UNSAFE.getByte(null, struct + (long)R);
    }

    public static byte ng(long struct) {
        return UNSAFE.getByte(null, struct + (long)G);
    }

    public static byte nb(long struct) {
        return UNSAFE.getByte(null, struct + (long)B);
    }

    public static byte na(long struct) {
        return UNSAFE.getByte(null, struct + (long)A);
    }

    public static void nr(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)R, value);
    }

    public static void ng(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)G, value);
    }

    public static void nb(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)B, value);
    }

    public static void na(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = NkColor.__struct(NkColor.__member(1), NkColor.__member(1), NkColor.__member(1), NkColor.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkColor, Buffer>
    implements NativeResource {
        private static final NkColor ELEMENT_FACTORY = NkColor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkColor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_byte")
        public byte r() {
            return NkColor.nr(this.address());
        }

        @NativeType(value="nk_byte")
        public byte g() {
            return NkColor.ng(this.address());
        }

        @NativeType(value="nk_byte")
        public byte b() {
            return NkColor.nb(this.address());
        }

        @NativeType(value="nk_byte")
        public byte a() {
            return NkColor.na(this.address());
        }

        public Buffer r(@NativeType(value="nk_byte") byte value) {
            NkColor.nr(this.address(), value);
            return this;
        }

        public Buffer g(@NativeType(value="nk_byte") byte value) {
            NkColor.ng(this.address(), value);
            return this;
        }

        public Buffer b(@NativeType(value="nk_byte") byte value) {
            NkColor.nb(this.address(), value);
            return this;
        }

        public Buffer a(@NativeType(value="nk_byte") byte value) {
            NkColor.na(this.address(), value);
            return this;
        }
    }
}

