/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_buffer_marker")
public class NkBufferMarker
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIVE;
    public static final int OFFSET;

    public NkBufferMarker(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkBufferMarker.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_bool")
    public boolean active() {
        return NkBufferMarker.nactive(this.address());
    }

    @NativeType(value="nk_size")
    public long offset() {
        return NkBufferMarker.noffset(this.address());
    }

    public static NkBufferMarker create(long address) {
        return NkBufferMarker.wrap(NkBufferMarker.class, address);
    }

    @Nullable
    public static NkBufferMarker createSafe(long address) {
        return address == 0L ? null : NkBufferMarker.wrap(NkBufferMarker.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return NkBufferMarker.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NkBufferMarker.wrap(Buffer.class, address, capacity);
    }

    public static boolean nactive(long struct) {
        return UNSAFE.getByte(null, struct + (long)ACTIVE) != 0;
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)OFFSET);
    }

    static {
        Struct.Layout layout = NkBufferMarker.__struct(NkBufferMarker.__member(1), NkBufferMarker.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIVE = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkBufferMarker, Buffer> {
        private static final NkBufferMarker ELEMENT_FACTORY = NkBufferMarker.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NkBufferMarker getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_bool")
        public boolean active() {
            return NkBufferMarker.nactive(this.address());
        }

        @NativeType(value="nk_size")
        public long offset() {
            return NkBufferMarker.noffset(this.address());
        }
    }
}

