/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMTargetMachine {
    public static final int LLVMCodeGenLevelNone = 0;
    public static final int LLVMCodeGenLevelLess = 1;
    public static final int LLVMCodeGenLevelDefault = 2;
    public static final int LLVMCodeGenLevelAggressive = 3;
    public static final int LLVMRelocDefault = 0;
    public static final int LLVMRelocStatic = 1;
    public static final int LLVMRelocPIC = 2;
    public static final int LLVMRelocDynamicNoPic = 3;
    public static final int LLVMRelocROPI = 4;
    public static final int LLVMRelocRWPI = 5;
    public static final int LLVMRelocROPI_RWPI = 6;
    public static final int LLVMCodeModelDefault = 0;
    public static final int LLVMCodeModelJITDefault = 1;
    public static final int LLVMCodeModelTiny = 2;
    public static final int LLVMCodeModelSmall = 3;
    public static final int LLVMCodeModelKernel = 4;
    public static final int LLVMCodeModelMedium = 5;
    public static final int LLVMCodeModelLarge = 6;
    public static final int LLVMAssemblyFile = 0;
    public static final int LLVMObjectFile = 1;

    protected LLVMTargetMachine() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetFirstTarget() {
        long __functionAddress = Functions.GetFirstTarget;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetNextTarget(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.GetNextTarget;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    public static long nLLVMGetTargetFromName(long Name2) {
        long __functionAddress = Functions.GetTargetFromName;
        return JNI.invokePP(Name2, __functionAddress);
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetTargetFromName(@NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMTargetMachine.nLLVMGetTargetFromName(MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetTargetFromName(@NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMTargetMachine.nLLVMGetTargetFromName(NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetTargetFromTriple(long Triple, long T, long ErrorMessage) {
        long __functionAddress = Functions.GetTargetFromTriple;
        return JNI.invokePPPI(Triple, T, ErrorMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetTargetFromTriple(@NativeType(value="char const *") ByteBuffer Triple, @NativeType(value="LLVMTargetRef *") PointerBuffer T, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Triple);
            Checks.check(T, 1);
            Checks.check(ErrorMessage, 1);
        }
        return LLVMTargetMachine.nLLVMGetTargetFromTriple(MemoryUtil.memAddress(Triple), MemoryUtil.memAddress(T), MemoryUtil.memAddress(ErrorMessage)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMGetTargetFromTriple(@NativeType(value="char const *") CharSequence Triple, @NativeType(value="LLVMTargetRef *") PointerBuffer T, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check(T, 1);
            Checks.check(ErrorMessage, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            boolean bl = LLVMTargetMachine.nLLVMGetTargetFromTriple(TripleEncoded, MemoryUtil.memAddress(T), MemoryUtil.memAddress(ErrorMessage)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetTargetName(long T) {
        long __functionAddress = Functions.GetTargetName;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetTargetName(@NativeType(value="LLVMTargetRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetName(T);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nLLVMGetTargetDescription(long T) {
        long __functionAddress = Functions.GetTargetDescription;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetTargetDescription(@NativeType(value="LLVMTargetRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetDescription(T);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetHasJIT(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.TargetHasJIT;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePI(T, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetHasTargetMachine(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.TargetHasTargetMachine;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePI(T, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetHasAsmBackend(@NativeType(value="LLVMTargetRef") long T) {
        long __functionAddress = Functions.TargetHasAsmBackend;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePI(T, __functionAddress) != 0;
    }

    public static long nLLVMCreateTargetMachine(long T, long Triple, long CPU, long Features, int Level2, int Reloc, int CodeModel) {
        long __functionAddress = Functions.CreateTargetMachine;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePPPPP(T, Triple, CPU, Features, Level2, Reloc, CodeModel, __functionAddress);
    }

    @NativeType(value="LLVMTargetMachineRef")
    public static long LLVMCreateTargetMachine(@NativeType(value="LLVMTargetRef") long T, @NativeType(value="char const *") ByteBuffer Triple, @NativeType(value="char const *") ByteBuffer CPU, @NativeType(value="char const *") ByteBuffer Features, @NativeType(value="LLVMCodeGenOptLevel") int Level2, @NativeType(value="LLVMRelocMode") int Reloc, @NativeType(value="LLVMCodeModel") int CodeModel) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Triple);
            Checks.checkNT1(CPU);
            Checks.checkNT1(Features);
        }
        return LLVMTargetMachine.nLLVMCreateTargetMachine(T, MemoryUtil.memAddress(Triple), MemoryUtil.memAddress(CPU), MemoryUtil.memAddress(Features), Level2, Reloc, CodeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTargetMachineRef")
    public static long LLVMCreateTargetMachine(@NativeType(value="LLVMTargetRef") long T, @NativeType(value="char const *") CharSequence Triple, @NativeType(value="char const *") CharSequence CPU, @NativeType(value="char const *") CharSequence Features, @NativeType(value="LLVMCodeGenOptLevel") int Level2, @NativeType(value="LLVMRelocMode") int Reloc, @NativeType(value="LLVMCodeModel") int CodeModel) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            stack.nUTF8(CPU, true);
            long CPUEncoded = stack.getPointerAddress();
            stack.nUTF8(Features, true);
            long FeaturesEncoded = stack.getPointerAddress();
            long l = LLVMTargetMachine.nLLVMCreateTargetMachine(T, TripleEncoded, CPUEncoded, FeaturesEncoded, Level2, Reloc, CodeModel);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDisposeTargetMachine(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __functionAddress = Functions.DisposeTargetMachine;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        JNI.invokePV(T, __functionAddress);
    }

    @NativeType(value="LLVMTargetRef")
    public static long LLVMGetTargetMachineTarget(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __functionAddress = Functions.GetTargetMachineTarget;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    public static long nLLVMGetTargetMachineTriple(long T) {
        long __functionAddress = Functions.GetTargetMachineTriple;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetTargetMachineTriple(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetMachineTriple(T);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nLLVMGetTargetMachineCPU(long T) {
        long __functionAddress = Functions.GetTargetMachineCPU;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetTargetMachineCPU(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetMachineCPU(T);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nLLVMGetTargetMachineFeatureString(long T) {
        long __functionAddress = Functions.GetTargetMachineFeatureString;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetTargetMachineFeatureString(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __result = LLVMTargetMachine.nLLVMGetTargetMachineFeatureString(T);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMCreateTargetDataLayout(@NativeType(value="LLVMTargetMachineRef") long T) {
        long __functionAddress = Functions.CreateTargetDataLayout;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        return JNI.invokePP(T, __functionAddress);
    }

    public static void LLVMSetTargetMachineAsmVerbosity(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMBool") boolean VerboseAsm) {
        long __functionAddress = Functions.SetTargetMachineAsmVerbosity;
        if (Checks.CHECKS) {
            Checks.check(T);
        }
        JNI.invokePV(T, VerboseAsm ? 1 : 0, __functionAddress);
    }

    public static int nLLVMTargetMachineEmitToFile(long T, long M, long Filename, int codegen, long ErrorMessage) {
        long __functionAddress = Functions.TargetMachineEmitToFile;
        if (Checks.CHECKS) {
            Checks.check(T);
            Checks.check(M);
        }
        return JNI.invokePPPPI(T, M, Filename, codegen, ErrorMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetMachineEmitToFile(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="char *") ByteBuffer Filename, @NativeType(value="LLVMCodeGenFileType") int codegen, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Filename);
            Checks.check(ErrorMessage, 1);
        }
        return LLVMTargetMachine.nLLVMTargetMachineEmitToFile(T, M, MemoryUtil.memAddress(Filename), codegen, MemoryUtil.memAddress(ErrorMessage)) != 0;
    }

    public static int nLLVMTargetMachineEmitToMemoryBuffer(long T, long M, int codegen, long ErrorMessage, long OutMemBuf) {
        long __functionAddress = Functions.TargetMachineEmitToMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check(T);
            Checks.check(M);
        }
        return JNI.invokePPPPI(T, M, codegen, ErrorMessage, OutMemBuf, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTargetMachineEmitToMemoryBuffer(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMCodeGenFileType") int codegen, @NativeType(value="char **") PointerBuffer ErrorMessage, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf) {
        if (Checks.CHECKS) {
            Checks.check(ErrorMessage, 1);
            Checks.check(OutMemBuf, 1);
        }
        return LLVMTargetMachine.nLLVMTargetMachineEmitToMemoryBuffer(T, M, codegen, MemoryUtil.memAddress(ErrorMessage), MemoryUtil.memAddress(OutMemBuf)) != 0;
    }

    public static long nLLVMGetDefaultTargetTriple() {
        long __functionAddress = Functions.GetDefaultTargetTriple;
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetDefaultTargetTriple() {
        long __result = LLVMTargetMachine.nLLVMGetDefaultTargetTriple();
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nLLVMNormalizeTargetTriple(long triple) {
        long __functionAddress = Functions.NormalizeTargetTriple;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(triple, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMNormalizeTargetTriple(@NativeType(value="char const *") ByteBuffer triple) {
        if (Checks.CHECKS) {
            Checks.checkNT1(triple);
        }
        long __result = LLVMTargetMachine.nLLVMNormalizeTargetTriple(MemoryUtil.memAddress(triple));
        return MemoryUtil.memUTF8Safe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char *")
    public static String LLVMNormalizeTargetTriple(@NativeType(value="char const *") CharSequence triple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(triple, true);
            long tripleEncoded = stack.getPointerAddress();
            long __result = LLVMTargetMachine.nLLVMNormalizeTargetTriple(tripleEncoded);
            String string = MemoryUtil.memUTF8Safe(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetHostCPUName() {
        long __functionAddress = Functions.GetHostCPUName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetHostCPUName() {
        long __result = LLVMTargetMachine.nLLVMGetHostCPUName();
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static long nLLVMGetHostCPUFeatures() {
        long __functionAddress = Functions.GetHostCPUFeatures;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMGetHostCPUFeatures() {
        long __result = LLVMTargetMachine.nLLVMGetHostCPUFeatures();
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void LLVMAddAnalysisPasses(@NativeType(value="LLVMTargetMachineRef") long T, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddAnalysisPasses;
        if (Checks.CHECKS) {
            Checks.check(T);
            Checks.check(PM);
        }
        JNI.invokePPV(T, PM, __functionAddress);
    }

    public static final class Functions {
        public static final long GetFirstTarget = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetFirstTarget");
        public static final long GetNextTarget = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetNextTarget");
        public static final long GetTargetFromName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetFromName");
        public static final long GetTargetFromTriple = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetFromTriple");
        public static final long GetTargetName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetName");
        public static final long GetTargetDescription = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetDescription");
        public static final long TargetHasJIT = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMTargetHasJIT");
        public static final long TargetHasTargetMachine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMTargetHasTargetMachine");
        public static final long TargetHasAsmBackend = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMTargetHasAsmBackend");
        public static final long CreateTargetMachine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateTargetMachine");
        public static final long DisposeTargetMachine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeTargetMachine");
        public static final long GetTargetMachineTarget = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetMachineTarget");
        public static final long GetTargetMachineTriple = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetMachineTriple");
        public static final long GetTargetMachineCPU = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetMachineCPU");
        public static final long GetTargetMachineFeatureString = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetTargetMachineFeatureString");
        public static final long CreateTargetDataLayout = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateTargetDataLayout");
        public static final long SetTargetMachineAsmVerbosity = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMSetTargetMachineAsmVerbosity");
        public static final long TargetMachineEmitToFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMTargetMachineEmitToFile");
        public static final long TargetMachineEmitToMemoryBuffer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMTargetMachineEmitToMemoryBuffer");
        public static final long GetDefaultTargetTriple = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetDefaultTargetTriple");
        public static final long NormalizeTargetTriple = LLVMCore.getLibrary().getFunctionAddress("LLVMNormalizeTargetTriple");
        public static final long GetHostCPUName = LLVMCore.getLibrary().getFunctionAddress("LLVMGetHostCPUName");
        public static final long GetHostCPUFeatures = LLVMCore.getLibrary().getFunctionAddress("LLVMGetHostCPUFeatures");
        public static final long AddAnalysisPasses = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddAnalysisPasses");

        private Functions() {
        }
    }
}

